REM The following example uses the Absolute routine to execute a
REM machine-language program stored in an array. The program displays
REM messages on installed equipment.
 
REM Note: To use the Absolute routine, you must load the Quick library
REM QBX.QLB using the /L switch when you begin QBX.
 
'AsmBytes is a label; nASMBYTES is a symbolic constant.
CONST nASMBYTES = 14
DEFINT A-Z
DIM AsmProg(1 TO (nASMBYTES / 2))
 
REM The machine-language program stored as data to read into the array.
AsmBytes:
DATA &H55              : 'PUSH BP        Save base pointer.
DATA &H8B, &HEC        : 'MOV  BP,SP     Get our own.
DATA &HCD, &H11        : 'INT  11H       Make the ROM-BIOS call.
DATA &H8B, &H5E, &H06  : 'MOV  BX,[BP+6] Get argument address.
DATA &H89, &H07        : 'MOV  [BX],AX   Save list in argument.
DATA &H5D              : 'POP  BP        Restore base pointer.
DATA &HCA, &H02, &H00  : 'RET  2         Pop argument off stack
                         '               and make far return.
REM Get the starting offset of the array.
Pointer = VARPTR(AsmProg(1))
REM Poke the machine-language program into the array.
DEF SEG = VARSEG(AsmProg(1)) ' Change the segment.
FOR Element = 0 TO nASMBYTES - 1
   READ ByteValue
   POKE (Pointer + Element), ByteValue
NEXT
 
REM Execute the program. The program expects a single integer argument.
CALL Absolute(RetValue%, VARPTR(AsmProg(1)))
DEF SEG ' Restore the segment.
REM RetValue% now contains bit-encoded equipment list returned by DOS.
REM Print header message
COLOR 15, 0
PRINT "Bios list v1.0a:"
COLOR 14, 0
REM Check math coprocessor bit
IF (RetValue% AND &H2) = &H2 THEN
   PRINT "Math coprocessor present."
ELSE
   PRINT "No math coprocessor."
END IF
REM Check game controller bit
IF (RetValue% AND &H1000) = &H1000 THEN
   PRINT "Game controller present."
ELSE
   PRINT "No game controller."
END IF
REM Check floppy bit
IF (RetValue% AND &H1) = &H1 THEN
   REM Count floppies
   NumFloppies% = RetValue% AND &HC0
   NumFloppies% = NumFloppies% / 64
   PRINT "Floppy drives =";NumFloppies% + 1
END IF
REM Count serial ports
NumSerial% = RetValue% AND &HE00
NumSerial% = NumSerial% / 512
PRINT "Serial ports =";NumSerial%
REM Count parallel ports
NumParallel% = RetValue% AND &HC000
REM Increment high byte of twos-complement
IF NumParallel% < 0 THEN
   NumParallel% = NumParallel% + 32768
END IF
NumParallel% = NumParallel% / 16384
PRINT "Parallel ports =";NumParallel%
COLOR 7, 0
PRINT "Exiting to system:"
END
