;
; LSD os library for use with C compilers
;
; Copyright(c) 1996 LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
	.386
	MODEL USE32 SMALL

include lib.asi

	PUBLIC	_OSSerialEnable,_OSSerialDisable,_OSSerialPutChar
	PUBLIC	_OSSerialGetChar,_OSSerialSetMode,_OSSerialGetMode
	PUBLIC	_OSSerialClearTransmit, _OSSerialClearReceive
	PUBLIC	_OSSerialTransmitStatus, _OSSerialReceiveStatus

_TEXT	SEGMENT	
;
;* void OSSerialEnable(int line);
;
_OSSerialEnable	PROC	
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS 	SP_ENABLE
	pop	ebx
	LEAVE
	ret
_OSSerialEnable	ENDP	
;
;* void OSSerialDisable(int line);
;
_OSSerialDisable	PROC	
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_DISABLE
	pop	ebx
	LEAVE
	ret
_OSSerialDisable	ENDP	
;
;* void OSSerialPutChar(int line, unsigned char theChar);
;
_OSSerialPutChar	PROC	
	ARG	LINE : DWORD, THECHAR : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	mov	dl,[BYTE PTR THECHAR]
	OS	SP_PUTCHAR
	pop	ebx
	LEAVE
	ret
_OSSerialPutChar	ENDP	
;
;* unsigned char OSSerialGetChar(int line);
;
_OSSerialGetChar	PROC	
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_GETCHAR
	jc	short retneg1
	pop	ebx
	LEAVE
	ret
retneg1:
	sub	eax,eax
	dec	eax
	LEAVE
	ret
_OSSerialGetChar	ENDP	
;
;* void OSSerialSetMode(int line, int modes, int baudrate);
;
_OSSerialSetMode	PROC	
	ARG	LINE : DWORD, MODES : DWORD, BAUDRATE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	mov	ecx,[BAUDRATE]
	mov	edx,[MODES]
	OS	SP_SETMODE
	pop	ebx
	LEAVE
	ret
_OSSerialSetMode	ENDP	
;
;* int OSSerialGetMode(int line);
;
_OSSerialGetMode	PROC	
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS      SP_GETMODE
	pop	ebx
	LEAVE	
	ret
_OSSerialGetMode	ENDP	
;
;* void OSSerialClearTransmit(int line);
;
_OSSerialClearTransmit	PROC	
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_CLEARXMIT
	pop	ebx
	LEAVE
	ret
_OSSerialClearTransmit	ENDP	
;
;* void OSSerialClearReceive(int line);
;
_OSSerialClearReceive	PROC	
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_CLEARRCV
	pop	ebx
	LEAVE
	ret
_OSSerialClearReceive	ENDP	
;
;* int OSSerialTransmitStatus(int line);
;
_OSSerialTransmitStatus	PROC	
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_XMITSTATUS
	pop	ebx
	LEAVE
	ret
_OSSerialTransmitStatus	ENDP	
;
;* int OSSerialReceiveStatus(int line);
;
_OSSerialReceiveStatus	PROC	
	ARG	LINE : DWORD
	ENTER	0,0
	push	ebx
	mov	ebx,[LINE]
	OS	SP_RCVSTATUS
	pop	ebx
	LEAVE
	ret
_OSSerialReceiveStatus	ENDP	
_TEXT	ENDS	
END