;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
; VGAINI.ASM
;
; Function: Support for VGA mode switches.  Supports modes 3 and 12h
;   Handle VGA OS calls
;   Handle Program various controllers for appropriate mode
;   Handle Load Text mode Font into VGA plane
;   Handle Clear VGA screen
;
	;MASM MODE
	.386p
include  segs.asi 
include  os.asi 
include  vga.asi 
include  vga.mac 
include  sys.mac 
include  boot.ase 
include  prints.ase 
include  dispatch.ase 
include  vga.ase 
include  iodelay.asi 

MISCOUTPUT = 3c2h
FEATURECONTROL = 3dah
SEQUENCER = 3c4h
CRTC = 03d4h
GRAPHICS = 3ceh
ATTRIBS = 03c0h
PELADDRESSWRITE = 3c8h
PELDATAREG = 3c9h

MAXSEQ = 5
MAXCRTC = 19h
MAXGRAPH = 9
MAXATTRIB = 015h

ENABLEATTRIB = 20h
NOPROT = 7fh

BYTESPERFONT = 16
FONTENTRIES = 256
FONTBASE = 0a0000h
PALETTELEN = 64

VREND = 11h
SQREGMAPMASK = 2
SQREGMEMORY = 4
GRREGWRMODE = 5
GRREGMISC = 6
	public	textmode, graphics_handler, theGraphicsMode, ClearVGA
	public	SysTextChar, vga_rundown
	extrn	f8x16 : BYTE

absdata	SEGMENT	
	org	49h
biosmode db	?
absdata	ENDS	
seg386data	SEGMENT	
theGraphicsMode	db	0
mode3	db	63h,00h,70h,05h
	db	03,01,03,00,02
ifdef VGA
	db	5fh,4fh,50h,82h,55h,81h,0bfh,1fh,0,0c7h,06,7,0,0,0,59h,9ch,8eh,8fh,28h,1fh,96h,0b9h,0a3h,0ffh
endif
ifdef NOTEBOOK
	db	5fh,4fh,50h,82h,55h,81h,0bfh,1fh,0,04fh,0eh,0fh,0,0,7,80h,9ch,0aeh,8fh,28h,1fh,96h,0b9h,0a3h,0ffh
endif
	db	0,0,0,0,0,10h,0eh,00h,0ffh
	db	0,1,2,3,4,5,6,7,10h,11h,12h,13h,14h,15h,16h,17h,8,0,0fh,0,0
mode12	db	0e3h,0,70h,4
	db	3,1,0fh,0,6
ifdef VGA
	db	5fh,4fh,50h,82h,54h,80h,0bfh,3eh,0,40h,0,0,0,0,0,059h,0eah,8ch,0dfh,28h,0,0e7h,4,0e3h,0ffh
endif
ifdef NOTEBOOK
	db	5fh,4fh,50h,82h,54h,80h,0bfh,3eh,0,40h,0eh,0fh,0,0,3,070h,0eah,0ach,0dfh,28h,0,0e7h,4,0e3h,0ffh
endif
	db	0,0,0,0,0,40,5,0fh,0ffh
	db	0,1,2,3,4,5,14h,7,38h,39h,3ah,3bh,3ch,3dh,3eh,3fh,1,0,0fh,0,0
palette	db	000h, 000h, 000h
	db	000h, 000h, 02ah
	db	000h, 02ah, 000h
	db	000h, 02ah, 02ah
	db	02ah, 000h, 000h
	db	02ah, 000h, 02ah
	db	02ah, 02ah, 000h
	db	02ah, 02ah, 02ah
	db	000h, 000h, 015h
	db	000h, 000h, 03fh
	db	000h, 02ah, 015h
	db	000h, 02ah, 03fh
	db	02ah, 000h, 015h
	db	02ah, 000h, 03fh
	db	02ah, 02ah, 015h
	db	02ah, 02ah, 03fh
	db	000h, 015h, 000h
	db	000h, 015h, 02ah
	db	000h, 03fh, 000h
	db	000h, 03fh, 02ah
	db	02ah, 015h, 000h
	db	02ah, 015h, 02ah
	db	02ah, 03fh, 000h
	db	02ah, 03fh, 02ah
	db	000h, 015h, 015h
	db	000h, 015h, 03fh
	db	000h, 03fh, 015h
	db	000h, 03fh, 03fh
	db	02ah, 015h, 015h
	db	02ah, 015h, 03fh
	db	02ah, 03fh, 015h
	db	02ah, 03fh, 03fh
	db	015h, 000h, 000h
	db	015h, 000h, 02ah
	db	015h, 02ah, 000h
	db	015h, 02ah, 02ah
	db	03fh, 000h, 000h
	db	03fh, 000h, 02ah
	db	03fh, 02ah, 000h
	db	03fh, 02ah, 02ah
	db	015h, 000h, 015h
	db	015h, 000h, 03fh
	db	015h, 02ah, 015h
	db	015h, 02ah, 03fh
	db	03fh, 000h, 015h
	db	03fh, 000h, 03fh
	db	03fh, 02ah, 015h
	db	03fh, 02ah, 03fh
	db	015h, 015h, 000h
	db	015h, 015h, 02ah
	db	015h, 03fh, 000h
	db	015h, 03fh, 02ah
	db	03fh, 015h, 000h
	db	03fh, 015h, 02ah
	db	03fh, 03fh, 000h
	db	03fh, 03fh, 02ah
	db	015h, 015h, 015h
	db	015h, 015h, 03fh
	db	015h, 03fh, 015h
	db	015h, 03fh, 03fh
	db	03fh, 015h, 015h
	db	03fh, 015h, 03fh
	db	03fh, 03fh, 015h
	db	03fh, 03fh, 03fh

seg386data	ENDS	

seg386	SEGMENT	
;
; Inform BIOS of the video mode
;
vga_rundown	PROC	
	assume	fs:absdata
	mov	al,3
	test	[theGraphicsMode],1
	jz	short biostextmode
	mov	al,12h
biostextmode:
	mov	[biosmode],al
	ret
	assume	fs:nothing
vga_rundown	ENDP	
;
; Subroutine to output a set of address/ value pairs
;
outregs	PROC	
	sub	ah,ah		; Start with reg 0
reglp:
	lodsb			; Get output value
	xchg	al,ah		; Swap to put reg in al
	out	dx,ax		; Output address/data pair
	xchg	al,ah		; Reg back in ah
	inc	ah		; Next reg
	cmp	ah,cl		; See if done
	jc	reglp		; Loop if not
	ret
outregs	ENDP	
;
; Set the graphics mode
;
setmode	PROC	
	lodsb			; Get MISC Output Reg value
	mov	dx,MISCOUTPUT	; And reg
	out	dx,ax		; Output it
	lodsb			; Get Feature Control Reg value
	mov	dx,FEATURECONTROL; And reg
	out	dx,ax		; Output it
	lodsb			; Skip input values
	lodsb			;
	mov	dx,SEQUENCER	; Loading sequencer
	mov	cl,MAXSEQ	; Number of items to load
	call	outregs		; Load SEQUENCER

	mov	ah,[esi + VREND]; Get Protection bit
	and	ah,NOPROT	; Mask it out
	mov	al,VREND	; Enable write to regs 0-8
	mov	dx,CRTC		; Loading CRTC
	out	dx,ax		; Disable protection
	mov	cl,MAXCRTC	; Number of items to load
	call	outregs		; Load CRTC
	mov	dx,GRAPHICS	; Loading graphics controller
	mov	cl,MAXGRAPH	; Number of items to load
	call	outregs		; Load graphics controller
	mov	dx,FEATURECONTROL; Read Feature controll reg to
	in	al,dx		;    Reset attribute controller flip-flop
	mov	dx,ATTRIBS	; Attribute controller reg
	mov	cl,MAXATTRIB	; Items to load
	sub	ah,ah		; Start with reg 0
atlp:
	lodsb			; Read value to load
	xchg	al,ah		; Output address
	out	dx,al		;
	IODELAY
	xchg	al,ah		;
	out	dx,al		; Output value
	inc	ah		; Next reg
	cmp	ah,cl		; See if done
	jc	atlp		;
	mov	al,ENABLEATTRIB	; Enable Display mem reading of attribute regs
	out	dx,al		;
	ret
setmode	ENDP	
;
; Read from VGA register
;
ReadVGA	PROC	
	out	dx,al		; Select the register
	inc	dx		; Point at data
	xchg	ah,al		; Get data
	in	al,dx		;
	xchg	ah,al		;
	dec	dx		; Reselect address register
	ret
ReadVGA	ENDP	
;
; Map font memory linearly at a0000h
;   Font memory is not documented ANYWHERE that I could find.  Except in
;   Bits and pieces.  What you do is set mapping to a0000h and turn off all
;   the odd/even support you can find.  Set sequencer to map plane 2 (red)
;   then copy the font to the memory.  Except each character in the font is
;   32 bytes long and you have to move less than that into each font buffer
;   depending on what kind of pixel setup you've programmed in the controller.
;   Oh, and you can do multiple fonts but I didn't get into the vagaries of
;   selecting font pages.  Looked like just an offset, probably 8K/page
;
MapFontMem	PROC	
	pop	ebx		; Return address
	mov	dx,GRAPHICS	; Select graphics controller
	mov	al,GRREGWRMODE	; Write mode will be 0
	call	ReadVGA		;
	push	eax		;
	and	ah,0fch		;
	out	dx,ax		;
	mov	al,GRREGMISC	; Set mapping to 64K at a0000h & turn off o/e at graphics controller
	call	ReadVGA
	push	eax		;
	and	ah,0f1h		;
	or	ah,4		;
	out	dx,ax		;
	mov	dx,SEQUENCER	; Get sequencer
	mov	al,SQREGMAPMASK ; Start by setting map mask reg to plane 2
	call	ReadVGA		;
	push	eax		;
	mov	ah,4		;
	out	dx,ax		;
	mov	al,SQREGMEMORY	; Turn Odd/Even off at the sequencer
	call	ReadVGA		;
	push	eax		;
	or	ah,4		;
	out	dx,ax		;
	jmp	ebx		; Return
MapFontMem	ENDP	
;
; Unmap the font memory
;
UnmapFontMem	PROC	
	pop	ebx		; Return address
	mov	dx,SEQUENCER	; Now popping sequencer info
	pop	eax             ;
	out	dx,ax           ;
	pop	eax             ;
	out	dx,ax           ;
	mov	dx,GRAPHICS	; Popping graphics controller info first
	pop	eax		;
	out	dx,ax		;
	pop	eax		;
	out	dx,ax		;
	jmp	ebx             ; Return
UnmapFontMem	ENDP	
;
; Load the font
;
LoadFont	PROC	
	call	MapFontMem	; Map font memory
	mov	esi,offset dgroup:f8x16; Get font
	mov	edi,FONTBASE	; Address to load font at
	push	es		;
	push	DSABS		; In Absolute segment
	pop	es		;
	mov	ecx,FONTENTRIES ; Number of chars in font
lp2:
	mov	edx,ecx		; In edx
	mov	ebx,edi		; output buffer in ebx
	mov	ecx,BYTESPERFONT; Bytes to xfer per font entry
	rep	movsb		; Write the font entry
	mov	edi,ebx		; Index to next output buffer
	add	edi,32		;
	mov	ecx,edx		; Restore chars left to move
	loop	lp2		;
	pop	es		; Restore ES
	call	UnmapFontMem    ; Unmap font memory
	ret
LoadFont	ENDP	
;
; Write the color palette out
;   Only updating first 64 entries
;
WriteColorPalette	PROC	
	mov	dx,PELADDRESSWRITE; Color write reg
	sub	al,al		; Select bottom of color map
	out	dx,al		;
	mov	esi,offset dgroup:palette; Get palette data
	mov	dx,PELDATAREG	; Get data reg
	mov	ecx,PALETTELEN	; Number of items
wcp_lp:
	lodsb			; Red
	out	dx,al
	lodsb			; Green
	out	dx,al
	lodsb			; Blue
	out	dx,al
	loop	wcp_lp		; Continue
	ret
WriteColorPalette	ENDP	
;
; Setting text mode
;
textmode	PROC	
	mov	[theGraphicsMode],0	; TextMode
	mov	esi,offset dgroup:mode3; Using VGA mode 3
	call	setmode		; Set the mode
	call	WriteColorPalette; Write the color palette
	call	LoadFont	; Load the font
	os	VF_CLEARSCREEN	; Clear the screen
	ret
textmode	ENDP	
;
; Clear VGA screen memory
;
ClearVGA	PROC	
	push	es		; Get Video segment
	push	DSABS		;
	pop	es		;
	mov	edi,GRAPHBASE	; Base of graphics
	WRMODE3			; Put us in write mode 3
	SETCOLOR	0	; Set color to black
	PUTBG			; Put background
	sub	al,al		; Foreground = black
	mov	ecx,10000h	; Kill one segment
	rep	stosb		;
	WRMODE0			; Back to write mode 0
	pop	es		; Restore data seg
	ret
ClearVGA	ENDP	
;
; Setting graphics mode 
;
graphmode	PROC	
	mov	[theGraphicsMode],1	; Graphics mode
	mov	esi,offset dgroup:mode12; Using VGA mode 12
	call	setmode		; Set the mode
	call	WriteColorPalette;
	os	VF_CLEARSCREEN	; Clear the screen
	ret
graphmode	ENDP	
;
; Output text char with system font
;
SysTextChar	PROC	
	mov	esi,offset dgroup:f8x16; Get offset in system font table
	movzx	eax,dl		;
	shl	eax,4		;
	add	esi,eax		;
	call	_DrawTextChar   ; Draw char
	ret
SysTextChar	ENDP	
;
; Output text char with user font
;
TextChar	PROC	
	push	ds		; Get user seg in DS
	push	fs		;
	pop	ds		;
	call	_DrawTextChar	; Draw char
	pop	ds		;
	ret
TextChar	ENDP	
;
;Return System Font base in gs:esi
;
SysFontBase	PROC	
	mov	eax,offset dgroup:f8x16
	add	eax,[zero]
	push	DSABS
	pop	gs
	ret
SysFontBase	ENDP	
widetextchar	PROC	
	push	ds
	push	fs
	pop	ds
	call	_DrawWideChar
	pop	ds
	ret
widetextchar	ENDP	
talltextchar	PROC	
	push	ds
	push	fs
	pop	ds
	call	_DrawTallChar
	pop	ds
	ret
talltextchar	ENDP	
horizbar	PROC	
	call	_HorizBar
	ret
horizbar	ENDP	
vertbar	PROC	
	call	_VertBar
	ret
vertbar	ENDP	
fillcorner	PROC	
	call	_FillCorner
	ret
fillcorner	ENDP	
	
;
; Graphics handler
;
Graphics_Handler	PROC	
	push	ds		; Save segs
	push	es		;
	push	fs		;
	push	ds		; FS = user data seg
	pop	fs		;
	push	DS386		; DS = system data seg
	pop	ds		;
	push	ebx		; Save regs
	push	ecx		;
	push	edx		;
	push	edi		;
	push	esi		;

	push	0		; Dispatch function
	call	TableDispatch	;
	dd	11
	dd	textmode
	dd	graphmode
	dd	graphmode
	dd	ClearVGA
	dd	sysfontbase
	dd	systextchar
	dd	textchar
	dd	widetextchar
	dd	talltextchar
	dd	horizbar
	dd	vertbar
	dd	fillcorner

	pop	esi		; Restore regs
	pop	edi		;
	pop	edx		;
	pop	ecx		;
	pop	ebx		;
	pop	fs		; Restore segs
	pop	es		;
	pop	ds		;
	ret
Graphics_Handler	ENDP	
seg386	ENDS	
END
