;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
; Remaps.asm
;
; Function: To provide services for remapping user pointers into the system
;   (PSUEDO_PHYSICAL data space)
;   handle remapping a user pointer to the system
;   handle mapping the system stack in and out of the system data space
;
	;MASM MODE
	.386p

include  segs.asi 
include  tss.asi 
include  page.asi 
include  sys.mac 
include  descript.ase 
include  boot.ase 
include  prints.ase 
include  gdt.asi 

	PUBLIC	remaptosystem, MapStackToSystem, UnmapStack

seg386	SEGMENT	
;
; Remap a user address to the system address space
;
;   AX : Selector
;   EBX: Address
;   EDI: LDT base, segment offset
;   ESI: Page table directory, physical
;
; Returns:
;   EAX: Address
;
remaptosystem	PROC	
	push	ebx			; Save regs
	push	edi			;
	push	esi                     ;
	ZA	esi
	test	ax,TI_LOCAL    		; See if is in LDT
	jnz	short gotable			; Yeah, LDT already in EDI
	mov	edi,offset dgroup:tGDT		; Else get GDT
gotable:
	and	eax, NOT SEL_STATUS	; Mask off selector RPL and TI
	add	edi,eax			; Get descriptor address
	call	GetDescriptorBase	; Pull the base
	add	ebx,edi			; Offset to calling seg
	mov	eax,ebx			; Get upper 10 bits of address
	shr	eax,22			;
	mov	eax,[esi + eax *4 ]	; To index the page dir
	bt	eax,0			; If no page table we have an error
	jnc	short badpage		;
	and	eax,NOT (PG_SIZE -1)	; Otherwise convert to seg offset
	ZA	eax			;
	mov	esi,eax			;
	mov	eax,ebx			; Get middle 10 bits of address
	shr	eax,12			;
	and	eax,03ffh		;
	mov	eax,[esi + eax * 4]	; Index this page table with that
	bt	eax,0			; Error if no page entry
	jnc	short badpage			;
	and	eax,NOT (PG_SIZE -1)	; Get page address
	ZA	eax			; As segment offset
	and	ebx,(PG_SIZE -1)	; Else get lower 12 bits of address
	add	eax,ebx			; Add it in
	pop	esi			;
	pop	edi			; Restore regs
	pop	ebx			;
	ret				;
badpage:
	stc				; Error, set carry
	pop	esi			; Restore regs
	pop	edi			;
	pop	ebx			;
	ret
remaptosystem	ENDP	
;
; Map the private task stack into the system space
;
MapStackToSystem	PROC	
	xchg	[esp],edx		; Save EDX and get ret address
	push	ecx			; Save all regs
	push	ebx			;
	push	eax			;
	push	esi			;
	push	edi			;
	enter	0,0			; Point BP at regs
	push	DWORD PTR [ebp]		; Save original EBP
	sldt	ax			; Load up LDT base address
	call	DescriptorAddress	;
	call	GetDescriptorBase	;
	ZA	edi			;
	mov	eax,ss			; EAX:EBX = stack
	mov	ebx,esp			;
	push	eax                     ; Save stack on stack
	push	ebx			;
	sub	[ebp - 4],esp		; Get offset of original EBP
	sub	ebp,esp			; get EBP offset
	mov	esi,CR3                 ; Get Page directory
	mov	ebx,esp			; Get stack offset to translate
	call	RemapToSystem		; Remap stack
	mov	ebx,ds			; Set new stack in data seg
	mov	ss,ebx			;
	mov	esp,eax			;
	add	ebp,esp			; Offset BP to new stack
	add	[ebp - 4],esp		; Offset original EBP to new stack
	push	ebp			; Save base pointer
	push	edx			; Save return address
	mov	edi,[ebp+4]		; Reload regs
	mov	esi,[ebp + 8]		;
	mov	eax,[ebp + 12]		;
	mov	ebx,[ebp + 16]		;
	mov	ecx,[ebp + 20]		;
	mov	edx,[ebp + 24]		;
	mov	ebp,[ebp-4]		; Reload EBP
	ret
MapStackToSystem	ENDP	
;
; Map back to the private task stack
;
UnmapStack	PROC	
	mov	ebp,[esp + 4]		; Load EBP with stack frame
	mov	[ebp + 24],edx		; Save regs we will wipe
	mov	[ebp + 20],ecx		;
	mov	[ebp + 16],ebx		;
	pop	edx			; EDX = return address
	pop	ecx			; Clear EBP from stack
	pop	ecx			; EBX:ECX = original stack
	pop	ebx			;
	mov	ss,ebx			; Restore stack
	mov	esp,ecx			;
	pop	ebp			; Wipe offsetted base pointer
	pop	ebp			; Restore base pointer pushed by ENTER
	pop	ebx			; Add ESP,12 slower but without
	pop	ebx			; changing flags
	pop	ebx			; This rids unchanged regs from stack
	pop	ebx			; Restore wiped regs
	pop	ecx			;
	xchg	[esp],edx		; And put return address on stack
	ret
UnmapStack	ENDP	
seg386	ENDS	
END
