program ExtPath;

{$X+,D-,L-,Y-}

uses
  Env;

const

  ProgName  = 'ExtPath';
  Version   = '1.00';
  Copyright = '(C) 1995 by Salvatore Besso (mc8505@mclink.it)';

var
  ActEnv,EnvSize,EnvLen,
  Prev,Actual           : Word;
  E                     : PEnvironment;
  Param,Name,Value      : String;
  I,L,Count,Result      : Integer;
  V                     : PEnvVar;

procedure ParseParam (P: String; var Name,Value: String);

var
  I: Byte;

begin
  Name := '';
  Value := '';
  I := Pos ('=',P);
  if I < 2 then Exit;
  Move (P[1],Name[1],I - 1);
  Name[0] := Char (I - 1);
  if I >= Length (P) then Exit;
  Move (P[I + 1],Value[1],Length (P) - I);
  Value[0] := Char (Byte (Length (P) - I))
end;

procedure ResultMessage (Size,Len,PrevPath,ActualPath: Word; Code: Integer);

var
  S    : String;
  N1,N2: String[5];

begin
  if Code = 0 then Exit;
  case Code of
    1: S := 'Variable ' + Name + ' doesn''t exist';
    2: begin
      Str (Size:0,N1);
      Str (Len:0,N2);
      S := 'Environment full, ' + Name + ' variable hasn''t been changed' +
        N1 + ' bytes available, ' + N2 + ' bytes used'
    end;
    3: S := #13#10'No modifications made';
    4: begin
      Str (PrevPath:0,N1);
      Str (ActualPath:0,N2);
      S := 'PATH variable length changed from ' + N1 + ' bytes to ' + N2 +
        ' bytes'
    end;
    5: S := 'Error finding active environment';
    6: S := 'Incorrect parameter syntax'
  end;
  WriteLn (S)
end;

function InKey: Char; near; assembler;

asm
@@1:  MOV     AH,1
      INT     16H
      PUSHF
      MOV     AH,0
      INT     16H
      POPF
      JNE     @@1
end;

procedure Usage;

begin
  WriteLn ('Usage: ExtPath [parameter]'#13#10);
  WriteLn ('       without parameter, ExtPath returns the environment state');
  WriteLn ('       if no PATHBLOCKxx entries are set, otherwise extends the');
  WriteLn ('       PATH= variable (see EXTPATH.DOC for more details)'#13#10);
  WriteLn ('       if parameter is VarName=, VarName is cleared'#13#10);
  WriteLn ('       if parameter is VarName=Value and VarName exists, VarName');
  WriteLn ('       is changed to Value, otherwise VarName is created');
  Halt (99)
end;

begin
  WriteLn (ProgName,' ',Version,' ',Copyright,#13#10);
  if (ParamCount > 0) and (ParamStr (1) = '/?') then Usage;
  Count := 2;
  ActEnv := FindActiveEnv;
  if ActEnv = 0 then Result := 5 else
  begin
    E := New (PEnvironment,Init (ActEnv));
    if ParamCount = 0 then
    begin
      if E^.PathToExpand then
      begin
        Prev := E^.GetPathLen;
        E^.ExpandPath;
        E^.WriteEnv;
        Result := E^.GetEnvError;
        if Result = 0 then
        begin
          Actual := E^.GetPathLen;
          Result := 4
        end
        else begin
          Name := 'PATH';
          EnvSize := E^.GetEnvSize;
          EnvLen := E^.GetEnvLen
        end
      end
      else begin
        Result := 3;
        WriteLn ('Environment size: ',E^.GetEnvSize,' bytes, in use: ',
          E^.GetEnvLen,' bytes');
        WriteLn ('PATH variable length: ',E^.GetPathLen,' bytes'#13#10);
        Inc (Count,3);
        for I := 1 to E^.GetEnvVarCount do
        begin
          V := E^.GetEnvVarByIndex (I);
          if V <> NIL then
          begin
            WriteLn (V^.GetName,'=',V^.GetValue,'<0>');
            L := V^.GetLen + 2;
            Inc (Count,L div 80);
            if L mod 80 > 0 then Inc (Count);
            if (Count >= 22) and (I < E^.GetEnvVarCount) then
            begin
              Count := 0;
              Write (#13#10'Press any key ');
              InKey;
              WriteLn (#13#10)
            end
          end
        end;
        WriteLn ('<0>')
      end
    end
    else begin
      Param := '';
      for I := 1 to ParamCount do
      begin
        if Param <> '' then Param := Param + ' ';
        Param := Param + ParamStr (I)
      end;
      ParseParam (Param,Name,Value);
      if Name <> '' then
      begin
        E^.ChangeEnvVar (Name,Value);
        Result := E^.GetEnvError;
        if Result = 0 then
        begin
          E^.WriteEnv;
          Result := E^.GetEnvError
        end;
        EnvSize := E^.GetEnvSize;
        EnvLen := E^.GetEnvLen
      end
      else Result := 6
    end;
    Dispose (E,Done)
  end;
  ResultMessage (EnvSize,EnvLen,Prev,Actual,Result);
  Halt (Result)
end.
