// ERROUT: REDIRECT STDERR TO STDOUT AND SPAWN A PROCESS
// (useful with programs that put more than one screen on stderr)
// Written in Microsoft Visual C++ 1.52
// Copyright 1999 John Navas
// Use subject to GNU General Public License
//	<http://www.gnu.org/copyleft/gpl.txt>

#include <io.h>
#include <process.h>
#include <stdio.h>

extern unsigned int __cdecl _amblksiz;	// dos memory allocation block size
                                                                 
int                                                                 
main(int argc, char** argv)
{
	int err, sav_stderr;
	
	_amblksiz = 1024;					// allocate memory in small chunks

	// online help	
	if (argc < 2)
	{
		printf("errout - redirect stderr to stdout and spawn a process\n"
			"(useful with programs that put more than one screen on stderr)\n"
			"usage:   process [arg ...]\n"
			"example: errout route | more\n");
		return 0;
	}

	// save stderr
	sav_stderr = _dup(_fileno(stderr));
	if (-1 == sav_stderr)
	{
		perror("stderr");
		return 1;
	}
	// redirect stderr to stdout
	err = _dup2(_fileno(stdout), _fileno(stderr));
	if (-1 == err)
	{
		perror("stderr");
		return 1;
	}

	// spawn child process
	err = _spawnvp(_P_WAIT, argv[1], argv+1);	// _P_WAIT needed for 32-bit
	if (-1 == err)
	{
		_dup2(sav_stderr, _fileno(stderr));	// restore stderr
		perror("errout");
		return 1;
	}

	return 0;
}

// errout.c
