@ECHO OFF
::REM CHKCMOS.BAT -- ensures CMOS not damaged, repairs if it is.

::REM last updated by Roedy Green of Canadian Mind Products 96/09/29
::REM Insert to this in AUTOEXEC.BAT to check CMOS.

REM Configure this line to point to where you installed the CMP utilities.

SET CMPDIR=C:\CMP

if not exist  %CMPDIR%\CDD!.com GOTO Missing

REM Switch to the C:\CMP drive and directory
%CMPDIR%\CDD!.com %CMPDIR%

if not exist  CMOSCHK.COM  GOTO Missing
if not exist  CMOSSAVE.COM GOTO Missing
if not exist  CMOSREST.COM GOTO Missing
if not exist  REBOOT.COM   GOTO Missing
if not exist  NEED.COM     GOTO Missing
if not exist  MD!.COM      GOTO Missing
GoTo KeepGoing

:Missing

Echo. Error ۲
Echo The following files must be installed in %CMPDIR%
Echo They are available on BIX or when you register CMOSSAVE.
Echo CDD!.com MD!.com NEED.com REBOOT.com
Echo CMOSCHK.com CMOSSAVE.com and CMOSREST.com.
Echo.
pause
GoTo Done

:KeepGoing

::REM  Only bother to check CMOS on the AT-style BIOS, not XT
NEED.COM AT > NUL:
IF Errorlevel 1 GOTO DONE

IF NOT EXIST C:\SAFE\CMOS.SAV GoTo MakeIt

CMOSCHK.com C:\SAFE\CMOS.SAV /Q
IF NOT Errorlevel 1 GOTO DONE

::REM CMOS check failed:
::REM could be 2 reasons:

::REM 1. CMOS has been illegitimately tampered with

::REM 2. CMOS has been deliberately changed,
::REM    Clever user will have to abort, and delete C:\SAFE\CMOS.SAV
::REM    or delete before before making changes. 
::REM    A new CMOS.SAV will be automatically
::REM    generated.  It should be copied to the rescue diskette.

::REM Warn consultants confounded by CMOSREST undoing their CMOS changes.

Echo.
Echo.To deliberately change CMOS, before you make your CMOS changes, you
Echo.must delete C:\SAFE\CMOS.SAV.
Echo.See CHKCMOS.BAT or CMOS.TXT for more details.
Echo.
Echo.Abort now with Ctrl-Break Y if you do not wish to restore damaged CMOS.
Echo.Normally you should just hit the SPACE BAR to repair CMOS or put it
Echo.back the way it used to be.
Echo.
Pause

::REM save "corrupted" current contents of CMOS just in case
CMOSSAVE.COM C:\SAFE\CMOS.OLD /Q

::REM try restoring
CMOSREST.COM C:\SAFE\CMOS.SAV /Q
IF NOT Errorlevel 1 GOTO Reboot
Echo CMOS is still corrupted
Echo.
Pause

:Reboot
Reboot.Com

:MakeIt

::REM Build a NEW CMOS.SAV file
Echo Recreating C:\SAFE\CMOS.SAV file.
MD! C:\SAFE
CMOSSAVE.COM C:\SAFE\CMOS.SAV /Q
Echo You might also want to create a new A: Rescue floppy boot disk soon
Echo Use CMOSSAVE A:\CMOS.SAV
Echo.
Pause

:DONE
::REM -30-
