
;
;       CMOS.COM   v0.93   10-12-1996   C. Dye   raster@highfiber.com
;       Freeware.
;
;       This file CMOS.S is a source file for Eric Isaacson's excellent A86
;       assembler.  Assemble by typing:  A86 CMOS.S
;
;       You may distribute unmodified copies of these files by whatever
;       means.  If you wish to distribute a modified version, please remove
;       my name from all files.
;


radix 16                               ; gentlemen prefer hex

jmp begin                              ; skip over variables

doscall macro                          ; call dos int 21 with a one-byte
mov ah,#1                              ; function in .ah
int 21
#em

doscall2 macro                         ; call dos int 21 with a two-byte
mov ax,#1                              ; function in .ax
int 21
#em

dosprint macro                         ; call dos string-print function
mov dx,offset #1
mov ah,09
int 21
#em

fnbuf:                                 ; holds filename
db 41 dup 00

flags:                                 ; bit 7 = valid machine
db 00                                  ; bit 6 = extended cmos (40 - 7F)
                                       ; bit 5 = mca   ** not implemented **
                                       ; bit 4 = eisa  ** not implemented **
                                       ; bits 3-0 = undefined in format 1.0

len:                                   ; length of cmos data, incl. header
dw 0000                                ; always 64 or 128 in this version

endpnt:
dw 0000

csum:                                  ; checksum to verify file integrity
dw 0000

hash:                                  ; hashtotal to verify file integrity
dw 0000

handle:                                ; handle of data file
dw 0000

ver_flag:                              ; flag:  0 = load, nonzero = verify
db 00

reboot_flag:                           ; flag:  0 = reboot after cmos load,
db 00                                  ; nonzero = please don't

misc:                                  ; miscellaneous byte variable
db 00

model_word:                            ; machine model and submodel bytes
dw 0000

begin:
call machine_check

parse_cmd_line:
mov si,0081
parse:
lodsb
call chk_space
je parse
cmp al,'/'
je parse
cmp al,'-'
je parse
call forceuc
mov bx,0000
parse02:
mov ah,b [switches+bx]
cmp ah,00
je parse04
cmp al,ah
je parse06
inc bx
jmp parse02
parse04:
jmp syntax
parse06:
shl bx,01
mov ax,w [switch_routines+bx]
jmp ax

_save:                                 ; /s (save) /b (backup) /w (write)
call getfn                             ; read the filename from command line
call crlf                              ; print a blank line
call read_cmos                         ; read configuration from cmos to dram
dosprint msg_saving                    ; print out the 'saving' message
call print_fn                          ; and the filename
mov w [buffer+0],'M' by 'C'
mov w [buffer+2],'S' by 'O'            ; set up the file header:  'CMOS'
mov b [buffer+4],10                    ; and file version i.d.  (1.0)
mov al,b [flags]
mov b [buffer+5],al                    ; flags byte
mov ax,w [model_word]
mov w [buffer+6],ax                    ; model and submodel
mov ax,w [len]                         ; length of file data
sub ax,000e                            ; (deduct 14 clock registers)
mov w [buffer+8],ax                    ; and save in file header
mov ax,w [csum]
mov bx,w [hash]
mov w [buffer+0a],ax                   ; checksum  of cmos data
mov w [buffer+0c],bx                   ; hashtotal of cmos data

mov cx,0000                            ; file attributes (normal)
mov dx,offset fnbuf                    ; and pointer to filename
doscall 3c                             ; open with overwrite
jnc _save02                            ; no error, continue
jmp file_error                         ;   otherwise, do file error routine
_save02:
mov w [handle],ax                      ; stash file handle for later use
mov bx,ax                              ; and move to bx for next function
mov cx,w [len]                         ; number of bytes to write
mov dx,offset buffer                   ; pointer to data buffer
doscall 40                             ; dos:  write handle
jnc _save03
jmp file_error                         ;   error, complain
_save03:
cmp ax,cx                              ; all bytes written okay?
je _save04                             ; no error, continue
mov ax,000e                            ; otherwise, we're out of disk space:
jmp file_error                         ; pretend this is dos error 14
_save04:
mov bx,w [handle]                      ; get the file handle for
doscall 3e                             ; dos close handle function
jnc _save05
jmp file_error                         ;    error, complain
_save05:
dosprint msg_done                      ; print the 'no errors' message
doscall2 4c00                          ; and exit with errorlevel 0

_xload:                                ; /i  (install:  load w/o reboot)
mov b [ver_flag],00                    ; not verifying
mov b [reboot_flag],40                 ; don't reboot
jmp _load_main
_load:                                 ; /l (load) or /r (restore)
mov b [ver_flag],00                    ; not verifying
mov b [reboot_flag],00                 ; do reboot
jmp _load_main
_ver:                                  ; /v (verify) or /c (compare)
mov b [ver_flag],40                    ; verifying cmos against file
_load_main:
call getfn                             ; read filename from command line
dosprint msg_loading                   ; print 'loading' message
call print_fn                          ; and filename
mov dx,offset fnbuf                    ; pointer to filename
mov al,10                              ; file read, deny all sharing
doscall 3d                             ; open existing file
jnc _load01                            ; no error, continue
jmp file_error                         ;    error, abort program
_load01:
mov w [handle],ax                      ; stash handle for future use
mov bx,ax                              ; and move to bx for next function
mov cx,000e                            ; read 14 bytes (CMOS file header)
mov dx,offset buffer                   ; pointer to file buffer
doscall 3f                             ; dos:  read handle
jnc _load02
jmp file_error                         ;    error, abort
_load02:
cmp ax,000e                            ; check number of bytes read
je _load03                             ; if 14, all is well -- continue
mov ax,0025                            ; hit end of file!
jmp file_error                         ; pretend it's dos error 25
_load03:
cmp w [buffer+0],'M' by 'C'            ; check file header for 'CMOS'
jne _load_bad1                         ; signature -- if it's not there,
cmp w [buffer+2],'S' by 'O'            ; abort with an error message
jne _load_bad1
cmp b [buffer+4],10                    ; check file header version byte
jne _load_bad5                         ; if it's not 10h, abort
mov al,b [buffer+5]                    ; check file header flags byte
test al,80                             ; top bit must be set
je _load_bad2                          ; abort if it isn't
test al,30                             ; bit 5 = mca, bit 4 = eisa
jne _load_bad3                         ; abort if either is set
test al,0f                             ; bits 0-3 are undefined
jne _load_bad2                         ; abort if any are set
mov b [flags],al                       ; flags byte okay:  stash it
mov ax,w [buffer+6]                    ; get model and submodel from header:
cmp ax,0000                            ; pre-0.92 always saved a zero,
je _load04                             ; so consider a zero legal
cmp ax,w [model_word]                  ; otherwise, test against this machine
je _load04                             ; if it matches, continue
jmp _load_bad4                         ; mismatch, bomb out!

_load_bad1:
mov dx,offset msg_lbad1                ; no CMOS header
jmp _load_badc
_load_bad2:
mov dx,offset msg_lbad2                ; bad flags byte
jmp _load_badc
_load_bad3:
mov dx,offset msg_lbad3                ; no EISA/MCA support
jmp _load_badc
_load_bad4:
mov dx,offset msg_lbad4                ; machine model mismatch
jmp _load_badc
_load_bad5:
mov dx,offset msg_lbad5                ; file version not supported
jmp _load_badc
_load_bad6:
mov dx,offset msg_lbad6                ; checksum mismatch
jmp _load_badc
_load_bad7:
mov dx,offset msg_lbad7                ; hashtotal mismatch
_load_badc:
push dx
call crlf
pop dx
mov ah,09                              ; print out error message
int 21
call crlf
doscall2 4c05                          ; and abort (bad file format/chksum)

_load04:                               ; file header looks okay:
mov bx,w [handle]                      ; file handle
mov cx,w [buffer+8]                    ; number of bytes to load
mov dx,offset buffer
add dx,000e                            ; buffer, just past file header
doscall 3f                             ; dos:  read handle
jnc _load05
jmp file_error                         ; probs, abort
_load05:
cmp ax,w [buffer+8]                    ; compare bytes read against header
je _load06
mov ax,0025                            ; read too few bytes:
jmp file_error                         ; pretend this is dos error 25
_load06:
mov ax,w [buffer+8]                    ; bytes read from file
add ax,000e                            ; add length of file header
mov w [len],ax                         ; to get buffer length for checksum
call checksum                          ; calculate checksum
mov ax,w [csum]                        ; compare calculated checksum
cmp ax,w [buffer+0a]                   ; against checksum from file header
jne _load_bad6                         ; mismatch?  bomb out
mov ax,w [hash]                        ; compare calculated hashtotal
cmp ax,w [buffer+0c]                   ; against hashtotal from file header
jne _load_bad7                         ; mismatch?  abort

mov bx,w [handle]                      ; checksums match -- get file handle
doscall 3e                             ; for dos close handle function
cmp b [ver_flag],00                    ; is this a verify operation?
jne _ver01                             ; yes, do that instead
call write_cmos                        ; write data back into cmos memory
dosprint msg_done                      ; print happiness message
call reboot                            ; reboot machine
doscall2 4c00                          ; exit program

_ver01:
dosprint msg_verify
mov w [csum],0000                      ; checksum word holds mismatch count
mov b [misc],00
mov si,000e
mov w [endpnt],0040                    ; assume last cmos byte is 63
test b [flags],40                      ; check flags:  saved extended cmos?
je ver01                               ; no, skip ahead
mov w [endpnt],0080                    ; last cmos byte is really 127
ver01:
cli                                    ; no interrupts please
mov ax,si                              ; copy cmos register number
out 70,al                              ; into cmos address register
call delay                             ; wait a sec
in al,71                               ; get byte from cmos into al
sti                                    ; interrupts okay now
call delay                             ; wait a bit
mov ah,b [buffer+si]                   ; get file byte in ah
cmp al,ah                              ; verify cmos byte against file
je ver04                               ; verify okay, move on to next byte
push ax                                ; save the good and bad values
inc w [csum]
test b [ver_flag],01
jne ver05
dosprint msg_vermis1                   ; print 'cmos/file' message
or b [ver_flag],01
ver05:
dosprint msg_space4
mov cx,si
call clout                             ; print out offending cmos address
dosprint msg_space4
pop cx
push cx
mov cl,ch
call clout                             ; print out byte from file
dosprint msg_space4
pop cx
call clout                             ; print out byte from cmos
dosprint msg_space4
inc b [misc]
cmp b [misc],03
jne ver04
mov b [misc],00
call crlf                              ; terminal line feed
ver04:
inc si                                 ; verify okay -- next cmos address:
cmp si,w [endpnt]                        ; done yet?
jne ver01                              ; no, loop back
cmp w [csum],0000                      ; all done; check mismatch count
jne ver06
dosprint msg_ver_okay                  ; no mismatches:  print 'okay' message
doscall2 4c00                          ; and exit
ver06:                                 ; some mismatches:
cmp b [misc],00
je ver07
call crlf                              ; print crlf if one is needed
ver07:
dosprint msg_vermis2                   ; print 'mismatch count' message
mov ax,w [csum]
call axout                             ; and number of mismatches
call crlf                              ; terminal line feed
doscall2 4c07                          ; exit with file verify error

_dump:                                 ; /d (dump)
call crlf                              ; print a blank line
call read_cmos                         ; read configuration from cmos to dram
dosprint msg_dump_cmos                 ; print 'dump' message
mov cx,w [model_word]
call cxout                             ; print out machine model word
dosprint msg_dump0                     ; print close bracket and newline
mov bx,0010                            ; start at beginning of cmos
dump02:
test bx,000f                           ; start of line?
jne dump03
call crlf                              ; if so, start new line
mov cx,bx
call clout                             ; print out cmos address
dosprint msg_dump1                     ; followed by a colon and a space
dump03:
mov cl,b [buffer+bx]                   ; get a byte from the cmos buffer
call clout                             ; and print it out
mov dl,20
doscall 02                             ; followed by a space
inc bx                                 ; next byte
cmp bx,w [len]                         ; done with cmos dump yet?
jb dump02                              ; if not, loop back for more
call crlf                              ; if so, print a blank line
doscall2 4c00                          ; and exit with no error

getfn:
mov di,offset fnbuf
getfn01:
lodsb
cmp al,0d
je getfn11
call chk_colon
jne getfn01
getfn02:
mov al,b [si]
call chk_colon
jne getfn04
inc si
jmp getfn02
getfn04:
lodsb
call forceuc
call chk_space
je getfn10
cmp al,0d
je getfn10
cmp al,'/'
jne getfn05
mov al,'\'
getfn05:
mov b [di],al
inc di
cmp di,(offset fnbuf + 40)
ja getfn09
jmp getfn04
getfn09:
dosprint msg_too_long
doscall2 4c02
getfn10:
mov b [di],00
cmp di,offset fnbuf
je getfn11
ret
getfn11:
push si
mov si,offset default_fn
getfn12:
lodsb
mov b [di],al
inc di
cmp al,00
jne getfn12
pop si
ret

print_fn:
push si
mov si,offset fnbuf
mov ah,02
print_fn01:
mov dl,b [si]
inc si
cmp dl,00
je print_fn03
int 21
jmp print_fn01
print_fn03:
call crlf
pop si
ret

machine_check:
cli
mov al,0f                              ; read the shutdown byte
out 70,al
call delay
in al,71                               ; from cmos
sti
cmp al,0ff                             ; if it contains 255,
jne mack03
dosprint msg_no_cmos                   ; cmos memory is probably not present:
doscall2 4c04                          ; print an error message and abort
mack03:
mov bx,0000
doscall2 3306                          ; check for dos versions 5.0+
cmp bx,0000
jne mack04                             ; later dos, okay
doscall 30                             ; check for older dosses
cmp al,02
ja mack04                              ; dos 3.0 or higher, okay
dosprint msg_old_dos                   ; dos before 3.0, print error message
doscall2 4c08                          ; exit with errorlevel 8
int 20                                 ; or with no errorlevel if that fails
mack04:
mov cx,sp
sub cx,offset buffer                   ; figure memory available for buffer
cmp cx,2300                            ; 8 3/4 kilobytes or more?
jae mack05                             ; yes, continue
push cx                                ; no, save buffer size
dosprint msg_memsize                   ; print memory message
pop cx
call cxout                             ; and amount of memory available
call crlf
doscall2 4c03                          ; then abort
mack05:
mov b [flags],80                       ; indicate valid machine
mov ah,0c0
int 15                                 ; look for bios description block
jc mack06
mov ax,w [es:bx+0002]                  ; if present, get model from it
mov w [model_word],ax
jmp mack07
mack06:                                ; no bios description block, so
mov es,0f000
mov ax,w [es:0fffe]                    ; get model word by peeking bios
mov w [model_word],ax
mack07:
ret

read_cmos:
mov si,007f                            ; assume 128 valid cmos locations
rdc01:
cli                                    ; disable interrupts and
mov ax,si                              ; move the cmos address
out 70,al                              ; into the cmos address register
call delay                             ; and wait a bit
in al,71                               ; get cmos value
sti                                    ; and re-enable interrupts
call delay                             ; wait a bit
mov b [buffer+si],al                   ; stash value in table
dec si
cmp si,000d                            ; if not done,
jne rdc01                              ; loop back for next byte
dosprint msg_ca1                       ; display area 1 message
or b [flags],40                        ; assume 128 valid cmos bytes
mov w [len],0080
mov si,003f
rdc02:
mov al,b [buffer+si]                   ; compare normal cmos byte
cmp al,b [buffer+40+si]                ; against extended cmos byte
jne rdc03                              ; mismatch, exit
dec si
cmp si,000d                            ; otherwise, try next lower byte
jne rdc02
and b [flags],0bf                      ; all match:  only 64 cmos bytes
mov w [len],0040
rdc03:
test b [flags],40
je rdc04
dosprint msg_ca2                       ; display area 2 message
rdc04:
call checksum
ret

write_cmos:
cli                                    ; no interrupts please
mov si,000e
mov w [endpnt],0040                    ; assume last cmos byte is 63
test b [flags],40                      ; check flags:  saved extended cmos?
je wrc01                               ; no, skip ahead
mov w [endpnt],0080                    ; last cmos byte is really 127
wrc01:
mov ax,si                              ; copy cmos register number
out 70,al                              ; into cmos address register
call delay                             ; wait a sec
mov dh,10                              ; retry counter for cmos write/verify
mov ah,b [buffer+si]                   ; get byte to write into cmos
wrc02:
mov al,ah
out 71,al                              ; write byte to cmos data register
call delay                             ; wait a bit
push ax
mov ax,si                              ; copy cmos register number
out 70,al                              ; into cmos address register
pop ax
call delay                             ; wait a bit
in al,71                               ; get byte from cmos data register
call delay                             ; wait a bit
cmp al,ah                              ; verify byte was written correctly
je wrc04                               ; verify okay, move on to next byte
dec dh                                 ; decrement retry counter
jne wrc02                              ; last try?  if not, loop back
sti
push ax                                ; save the good and bad values
dosprint msg_wrce1                     ; print out unhappy message
mov cx,si
call clout                             ; print out offending cmos address
dosprint msg_wrce2
pop cx
push cx
mov cl,ch
call clout                             ; print out correct (write) value
dosprint msg_wrce3
pop cx
call clout                             ; print out wrong (verify) value
call crlf                              ; terminal line
doscall2 4c06                          ; abort program
wrc04:
inc si                                 ; verify okay -- next cmos address:
cmp si,w [endpnt]                      ; done yet?
jne wrc01                              ; no, loop back
sti
ret

reboot:
cmp b [reboot_flag],00
jne keyb_cmd_x
dosprint msg_reboot1
mov es,0040
mov w [es:0072],0000                   ; set for cold start
doscall 0d                             ; flush dos buffers (and smartdrive)
mov ah,40
call long_pause
mov ah,0fe                             ; keyboard controller 'reset' command
mov cx,0100                            ; loop 256 times
keyb_cmd1:
in al,64                               ; check keyboard command port
call delay
test al,02                             ; ready to receive command?
je keyb_cmd5                           ; yes, proceed
loop keyb_cmd1                         ; no, loop back and try again
dosprint msg_reboot2
ret                                    ; time out
keyb_cmd5:                             ; keyboard controller ready:
mov al,ah
out 64,al                              ; write command byte to port
mov ah,30
call long_pause
dosprint msg_reboot2
keyb_cmd_x:
ret

delay:
push cx
mov cx,0100
delay01:
dec cx
jne delay01
pop cx
ret

long_pause:
mov es,0040
long01:
mov al,b [es:006c]
long02:
cmp al,b [es:006c]
je long02
dec ah
jne long01
ret

checksum:
mov w [csum],0000
mov w [hash],0000
mov si,000e
csum01:
mov al,b [buffer+si]
mov ah,00
add w [csum],ax
inc si
cmp si,w [len]
jne csum01
mov si,000e
csum02:
mov ax,w [buffer+si]
xor w [hash],ax
inc si
inc si
cmp si,w [len]
jb csum02
dosprint msg_csum
mov cx,w [csum]
call cxout
dosprint msg_hash
mov cx,w [hash]
call cxout
call crlf
ret

cxout:                                 ; print value in cx to stdout as hex
mov ah,02
mov dl,ch
shr dl,04
call cxout02
mov dl,ch
and dl,0f
call cxout02
clout:
mov ah,02
mov dl,cl
shr dl,04
call cxout02
mov dl,cl
and dl,0f
call cxout02
ret

cxout02:
cmp dl,09
ja cxout03
add dl,'0'
jmp cxout04
cxout03:
add dl,37
cxout04:
int 21
ret

axout:                                 ; print value in ax to stdout as dec
mov dx,0000
push dx
mov cx,000a
axout01:
mov dx,0000
div cx
mov bx,dx
add bx,'0'
push bx
cmp ax,0000
jne axout01
mov ah,02
axout02:
pop dx
cmp dx,0000
je axout03
int 21
jmp axout02
axout03:
ret

file_error:
push ax
mov bx,w [handle]
cmp bx,0000
je file_error00
doscall 3e
file_error00:
call crlf
pop ax
mov si,0000
file_error01:
mov bx,w [err_code+si]
cmp bx,0000
je file_error05
cmp bx,ax
je file_error02
inc si
inc si
jmp file_error01
file_error02:
mov dx,w [err_text+si]
mov ah,09
int 21
call crlf
doscall2 4c01
file_error05:
push ax
dosprint msg_file_err
pop cx
call cxout
call crlf
doscall2 4c01

crlf:
dosprint msg_crlf
ret

syntax:                                ; syntax error in command-line args:
dosprint msg_syntax                    ; print syntax message
doscall2 4c02                          ; and exit

forceuc:
cmp al,'a'
jb forceuc01
cmp al,'z'
ja forceuc01
and al,0df
forceuc01:
ret

chk_colon:
cmp al,':'
je chk_colon01
cmp al,'='
je chk_colon01
chk_space:
cmp al,20
je chk_colon01
cmp al,09
chk_colon01:
ret

switches:
db 'SBWLRVCID',00

switch_routines:
dw _save,_save,_save,_load,_load,_ver,_ver,_xload,_dump

err_code:
dw 02,03,05,0e,0f,13,15,1d,1e,20,25,00

err_text:
dw doserr02,doserr03,doserr05,doserr0e,doserr0f
dw doserr13,doserr15,doserr1d,doserr1e,doserr20,doserr25

default_fn:
db 'CMOS.SAV',00

msg_crlf:
db 0d,0a,'$'

msg_syntax:
db 0d,0a
db 'CMOS.COM   v0.93   10-12-1996   C. Dye   raster@highfiber.com',0d,0a
db 'Freeware.  Okay to distribute by any means.  No warranty.',0d,0a,0a
db 'Syntax:',0d,0a
db 'CMOS /SAVE filename      Save CMOS RAM to file',0d,0a
db 'CMOS /LOAD filename      Restore CMOS from file',0d,0a
db 'CMOS /VER  filename      Compare CMOS against file',0d,0a
db 'CMOS /DUMP               Hex dump of current CMOS data',0d,0a,0a
db 'If no filename is specified, CMOS.SAV will be used.',0d,0a
db 'Switches may be abbreviated to the first letter.',0d,0a
db '$'

msg_no_cmos:
db 0d,0a
db 'This machine does not appear to have CMOS memory!',0d,0a,'$'

msg_old_dos:
db 0d,0a
db 'Sorry, this program requires DOS v3.00 or higher.',0d,0a,'$'

msg_too_long:
db 0d,0a
db 'Filename is too long -- maximum of 64 characters!',0d,0a
db '$'

msg_memsize:
db 'Insufficient memory:  $'

msg_saving:
db 'Saving CMOS to file $'

msg_loading:
db 0d,0a
db 'Loading CMOS from file $'

msg_verify:
db 0d,0a
db 'Verifying CMOS against file:  $'

msg_dump_cmos:
db 0d,0a
db 'Dump of current CMOS configuration:  [$'

msg_dump0:
db ']',0d,0a,'$'

msg_vermis1:
db 0d,0a,0a,'Address  File  CMOS   Address  File  CMOS   Address  File  CMOS',0d,0a,'$'

msg_vermis2:
db 0d,0a,'Total mismatches:  $'

msg_ver_okay:
db 'No mismatches.',0d,0a,'$'

msg_space4:
db '    $'

msg_ca1:
db 'Standard CMOS (0Eh-3Fh)',0d,0a,'$'

msg_ca2:
db 'Extended CMOS (40h-7Fh)',0d,0a,'$'

; msg_ca3:
; db 'EISA extended CMOS (8K)',0d,0a,'$'

; msg_ca4:
; db 'MCA extended CMOS (2K)',0d,0a,'$'

msg_csum:
db 0d,0a,'Checksum:  $'

msg_hash:
db '   Hashtotal:  $'

msg_file_err:
db 'Dos file I/O error $'

doserr02:
db 'File not found$'

doserr03:
db 'Path not found$'

doserr05:
db 'Access denied$'

doserr0e:
db 'Out of disk space$'

doserr0f:
db 'Invalid drive$'

doserr13:
db 'Disk is write-protected$'

doserr15:
db 'Drive not ready$'

doserr1d:
db 'Write error$'

doserr1e:
db 'Read error$'

doserr20:
db 'Sharing violation$'

doserr25:
db 'File too short$'

msg_lbad1:
db 'Not a CMOS file!$'

msg_lbad2:
db 'Illegal flags byte!$'

msg_lbad3:
db 'Sorry, this version does not support EISA/MCA CMOS!$'

msg_lbad4:
db 'Machine ID word mismatch!$'

msg_lbad5:
db 'Unable to handle that file format!$'

msg_lbad6:
db 'Checksum mismatch!$'

msg_lbad7:
db 'Hashtotal mismatch!$'

msg_wrce1:
db 0d,0a,'Error writing CMOS byte $'

msg_wrce2:
db ':  wrote $'

msg_wrce3:
db ', read back $'

msg_dump1:
db ':  $'

msg_reboot1:
db 0d,0a,'Attempting to reboot machine ... $'

msg_reboot2:
db 'Failed.',0d,0a
db 'You should press Control-Alt-Delete to reboot now.',0d,0a,'$'

msg_done:
db 'No errors encountered.',0d,0a,'$'

buffer:

;
;   Errorlevels:
;
;   0 :  success
;   1 :  dos file error
;   2 :  syntax error, invalid switch or filename too long
;   3 :  not enough memory
;   4 :  no cmos?  hardware problem?
;   5 :  invalid or corrupt file
;   6 :  cmos write-verify mismatch.  hardware problem?
;   7 :  cmos - file data mismatch
;   8 :  bad dos
;
;
;   CMOS file format:
;
;   4 bytes  'CMOS' file type identifier
;   1 byte 10h      file version identifier (1.0)
;   1 byte          flags:  bit 7 = valid, bit 6 = extended cmos present
;   2 bytes         bios model and submodel bytes
;   1 word (n)      length of data (in bytes)
;   1 word          checksum of data  (sum of all bytes)
;   1 word          hashtotal of data (xor of all words)
;   n bytes         cmos data.  so far, n is always 50 or 114 decimal
;
;
;   Versions:
;
;   v0.90   11-09-1994
;           Initial release.
;
;   v0.91   11-23-1994
;           Fixes DELAY code.
;
;   v0.92   07-31-1996
;           Saves machine model/submodel bytes in the previously "reserved"
;           word of the file header.  Adds switches /W (Write, same as Save)
;           and /C (Compare, same as Verify).  Errorlevel for "not enough
;           memory" changed from 4 to 3.  Added errorlevel 8 for "bad dos."
;
;   v0.93   10-12-1996
;           A very trivial update, just because my email address has changed.
;           Adds the semi-useless /DUMP switch, and now indicates the
;           program's freeware status in the syntax message.
;
