program vcpimap;
{ uses vcpi to find physical addresses used by QEMM/Desqview }

uses
  dos,
  opstring;  { From Object Professional; used only for hex conversions. }

const
  vcpi_int = $67;
var
  r : registers;
  rax,rdx : word;
  page : longint;
  physical : longint;
  start,last : longint;
begin
  with r do
  begin
    ax := $de00;
    intr(vcpi_int,r);
    if ah <> 0 then
    begin
      writeln('VCPI not found');
      halt;
    end
    else
      writeln('Running under VCPI version ',bh,'.',bl);

    writeln;
    writeln('    V86               Physical');
    writeln('  Segments           addresses');
    write('0000:0 - ');
    for page:=0 to $FFFFF shr 12 do
    begin
      ax := $de06;
      cx := page;
      intr(vcpi_int,r);
      Inline($66/$89/$16/>physical);{      mov [>physical],edx  }
      move(r.dx,physical,2);        {      get the low word too }
      if hi(r.ax) <> 0 then
      begin
        writeln('Error on page ',hexw(page));
        halt;
      end;
      if page = 0 then
        start := physical
      else
      begin
        if physical <> last + 1 shl 12 then
        begin
          writeln(hexw(page shl 8 - 1),':F  ',hexl(start),' - ',
                                              hexl(last + 1 shl 12 - 1));
          write(hexw(page shl 8),':0 - ');
          start := physical;
        end;
      end;
      last := physical;
    end;
    writeln('FFFF:F  ',hexl(start),' - ',hexl(last + 1 shl 12 - 1));
  end;
end.


