procedure SWAPSURF(I, J: word; var Surfmin, Surfmax: surfaces);

{ Swap the data for surfaces I and J }
var Vert: word;                 { vertex number }
    Vert1, Vert2: word;         { vertices to swap }

begin
{$ifdef BIGMEM}
with ptrg^ do with ptrh^ do with ptri^ do
begin
{$endif}

  { The next several stmts. perform the exchange on I and J }
  swapreal (Surfmax[I], Surfmax[J]);
  swapreal (Surfmin[I], Surfmin[J]);
  swapint  (Matl[I], Matl[J]);
  swapint  (Nvert[I], Nvert[J]);
  { Swap all the vertices }
  Vert1 := (I-1)*Maxvert + 1;
  Vert2 := (J-1)*Maxvert + 1;
  for Vert := 1 to Maxvert do begin
    swapword (Connect[Vert1], Connect[Vert2]);
    Vert1 := Vert1 + 1;
    Vert2 := Vert2 + 1;
  end;
{$ifdef BIGMEM}
end; {with}
{$endif}
end;  { Procedure SWAPSURF }

procedure SHELSURF (var Surfmin, Surfmax: surfaces; Nsurf: word);

{ Shell sort the surface data, using Surfavg as the primary sorting
  criterion and Surfmin as the secondary (tie-breaking) sorting
  criterion. Procedure as published in Tanenbaum, "Structured
  Computer Organization", Prentice-Hall, Englewood Cliffs, NJ, 1976.
}
var Dist: word;                 { sorting distance }
    K, I: word;                 { genl sorting indexes }
    Done: boolean;              { finished inner loop yet? }

begin

{ Determine the initial value of Dist by finding the largest power
  of 2 less than Nsurf, and subtracting 1 from it. The final step in
  this calculation is performed inside the main sorting loop.
}
  Dist := 4;
  while (Dist < Nsurf) do
    Dist := Dist + Dist;
  Dist := Dist - 1;

{ Main sorting loop. The outer loop is executed once per pass. }
  while (Dist > 1) do begin
    Dist := Dist div 2;
    for K := 1 to (Nsurf - Dist) do begin
      I := K;
      Done := FALSE;
      while (not Done) do begin
        { This stmt. is the comparison. It also controls moving values
          upward after an exchange. }
        if (Surfmax[I] > Surfmax[I+Dist]) or ((Surfmax[I] = Surfmax[I+Dist])
            and (Surfmin[I] > Surfmin[I+Dist])) then
          swapsurf(I, I+Dist, Surfmin, Surfmax)
        else
          Done := TRUE;
        { KVC 09/14/91 Added check because negative numbers not possible
          when using words instead of integers.
        }
        if (Dist >= I) then
          Done := TRUE
        else
          I := I - Dist;
      end; { while }
    end; { for K }
  end; { while Dist }

end; { procedure SHELSURF }
