procedure MINMAX (var Surfmin, Surfmax: surfaces; Nsurf: word);
{ Calculate the minimum and maximum Ztran coordinates of each surface }

var Surf: word;                      { surface # }
    Vert: integer;                   { vertex # }
    Zval: real;                      { Z-coord of node }

begin
{$ifdef BIGMEM}
with ptrf^ do with ptrh^ do
begin
{$endif}
  Zmin := 9999.0;
  Zmax := -9999.0;
  for Surf := 1 to Nsurf do begin
    Surfmin[Surf] := 9999.0;
    Surfmax[Surf] := -9999.0;
    for Vert := 1 to Nvert[Surf] do begin
      Zval := Ztran[Konnec (Surf, Vert)];
      if (Zval < Surfmin[Surf]) then
        Surfmin[Surf] := Zval;
      if (Zval > Surfmax[Surf]) then
        Surfmax[Surf] := Zval;
    end;
    { KVC 08/18/91 Establish global limits on Z coordinate }
    if ( Surfmin[Surf] < Zmin ) then
      Zmin := Surfmin[Surf];
    if ( Surfmax[Surf] > Zmax ) then
      Zmax := Surfmax[Surf];
  end;
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure MINMAX }

