procedure CONTINUE;
{ CONTINUE waits for a user keypress before continuing, with the exception
  of the following keys which have special meaning:
    P  -  Pauses until P is pressed again (provides protection against an
          accidental keypress clearing the screen).
    S  -  Calls an internal screen dump routine (not implemented).
    F  -  Dumps the current screen image into a PIC file.
}
var c: char;
    Checkagain: boolean;
    F: file;
    i: integer;
    Filefound: boolean;
    Filename: text80;
    Filenum: string;

begin
  stopstat;               { erase the graphics status line }

  Checkagain := TRUE;
  while (Checkagain) do begin
    if (Save_cmmd <> '') then begin
      { Command was entered on command line }
      c := Save_cmmd[1];
      Checkagain := FALSE;
    end else
      c := readkey;

    c := upcase (c);
    case c of
      'P' : begin  { Pause for another P }
              c := ' ';
              while (c <> 'P') do begin
                c := readkey;
                c := upcase (c);
              end; {while}
            end; {option P}
      'S' : begin end; { insert a call to your screen dump here }
      'F' : begin { Dump to a file }
              Filefound := FALSE;
              i := 1;
              { Name the data file: search for first available number. }
              while (i < 1000) and (not Filefound) do begin
                str (i, Filenum);
                Filename := Filemask + '.' + Filenum;
                assign (F, Filename);
                {$I-}
                reset (F);
                {$I+}
                if (ioresult <> 0) then
                  Filefound := TRUE
                else begin
                  close (F);
                  i := i + 1;
                end;
              end; { while }
              if (not Filefound) then
                write (chr(7))
              else
                if (not savescrn (Filename)) then
                  write (chr(7));
            end;
      else
        Checkagain := FALSE;
    end {case}
  end; { while Checkagain }
end; { procedure CONTINUE }
