/*****************************************************
* Listing 4
* s101meda.c
* Contains functions for the use of stat101, namely
* to compute the median and moments around the mean:
*
* NumComp       Comparison function for qsort()
* SortFVect     Function to sort a float vector
* S101Med       Computes the median
* S101Mom       Computes a moment of given order
*/

#include <stdlib.h>
#include <math.h>


/*************************************************
 * NumComp
 * Sort comparison function
 * for the use of qsort()
 */
int NumComp (const void * X, const void * Y)
   {
   int R;
   float * A, * B;
   A = (float *) X;
   B = (float *) Y;

   if (*A > *B)  R= 1;
   if (*A < *B)  R= -1;
   if (*A == *B) R= 0;

   return R;
   }    /* NumComp ends. */


/*************************************************
 SortFVect
 Sorts a float vector of Size elements.
 Required by S101Med (calculating the median).
*/

void SortFVect(float * Vector, long double Size)
   {
   qsort ((void *) Vector, Size,
	  sizeof(float), NumComp);
   }    /* SortFVect ends. */


/***************************************************
* S101Med
* Computes the median.
* Vector MUST have been sorted beforehand.
*/

long double S101Med(float * Data, long double Size)
   {
   int Items = (int) Size;
   long double Median = 0.0;

   if (Items % 2 )  /* if odd */
      Median = (long double)  Data[(Items)/2];
   else  /* if even return average   */
	 /* of the two central items */
      Median = (long double)
	       ((Data[(Items-1)/2]
	       + Data[(Items/2)]) /2);

   return Median;
   }  /* S101Med ends. */

/**************************************
 * S101Mom
 * Computes a moment of given order
 * around the mean
 */

long double S101Mom(float * Data,
		    long double Size,
		    long double ItemSum,
		    int Order)
   {
   int Items = (int) Size;
   int I = 0;
   long double S = 0;
   long double Average = (ItemSum / Size);

   for (I=0; I< Items; I++)
      S += (long double) pow((Data[I] - Average), Order);

   S /= Size;
   return S;
   }
