/************************************************
 * dsfileu.c - ANSI C English version
 * Used by ds1u.c and ds2u.c
 * 
 * File single pass descriptive stat
 * and array loading pass.
 *
 * Contains the following functions:
 *
 * IsNum    - Checks if the character looks like
 *            part of a number
 * Upcase   - converts a string to uppercase.
 *
 * Openfile - open a file for text read-only and
 *            return file pointer or exit on error.
 * TrimLeft - Removes blank space on the left of
 *            a string  
 * ClearString - Fills a string with 0x00
 *
 * S101Fly  - on the fly stats. Opens file, reads
 *            elements, returns accumulated counters.
 *            Uses OpenFilu.acf.
 * S101Vect - same as previous, but loads a data
 *            vector in case you intend to compute
 *            the median. Uses OpenFilu.acf.
 */

/******* these were moved into the main fuction
 * #include <stdio.h>
 * #include <stdlib.h>
 * #include <float.h>
 ***/

#ifndef __FLOAT_H
#include <float.h>
#endif
#include "openfilu.acf"

/* string utilities */

int IsNum(char C)
   {
   const char * S="+-.0123456789";

   while ((C != *S) && *S) S++;
   if ((C == * S) && *S) return 1;
   else return 0;
   }


char * TrimLeft(char * S)
   {
   while ((*S) && isspace(*S)) S++;
   return S;
   }

char * ClearString(char * S)
   {
   char *P = S;
   while (*P) *P=0x00, P++;
   return S;
   }




/****************************************************
 * S101Fly
 * File single pass
 * Open file, performs single pass, closes file.
 * Counters must have 5 elements.
 */

void S101Fly (long double * Counters, char * FileName)
   {
   int I, Unusable = 1;
   char InString[1024];
   float InItem;
   FILE * In;

   for (I=0; I <3; I++) Counters[I] = 0.0;
   Counters[3] = -1e+40;
   Counters[4] = +1e+40;

   In = OpenFile(FileName, "rt");

   do
     {
     InItem = 0.0; ClearString(InString);
     I = (int) fgets(InString, 1000, In);
     if (! I) break;
     strcpy(InString, TrimLeft(InString) );
     InItem = atof(InString);
     Unusable++;
     }
   while (! IsNum(*InString));
   Unusable--;

   while (! feof(In))
      {
	 Counters[0]++;
	 Counters[1] += (long double) InItem;
	 Counters[2] += (long double) InItem
		     * (long double) InItem;
	 if (InItem > Counters[3])
	    Counters[3] = InItem;
	 if (InItem < Counters[4])
	    Counters[4] = InItem;
	 do
	    {
	    InItem = 0.0; ClearString(InString);
	    I = (int) fgets(InString, 1000, In);
	    if (! I) break;
	    strcpy(InString, TrimLeft(InString) );
	    InItem = atof(InString);
	    Unusable++;
	    }
	 while (! IsNum(*InString));
	 Unusable--;
      }
   fclose(In);

   if (Counters[0] < 3)
      {
      printf("\nS101Fly: less than"
	     " 3 elements in %s.\n",
	      FileName);
      exit(2);
      }

   if (Unusable)
      printf("\nS101Fly: Warning: %d unusable"
	     " items in %s",
	     Unusable, FileName);
   } /* S101Fly ends. */




/****************************************************
 * S101Vect
 * File single pass with array loading.
 * Open file, clear array, perform single pass, loads
 * array, closes file.
 * Counters must have 5 elements.
 */

void S101Vect (long double * Counters,
	       char * FileName,
	       float * Data,
	       int MaxSize)
   {
   int I, Unusable=1;
   char InString[1024];
   float InItem;
   FILE * In;

   for (I=0; I<3; I++) Counters[I] = 0.0;
   Counters[3] = -1e+40;
   Counters[4] = +1e+40;

   for (I=0; I < MaxSize; I++) Data[I] = 0.0;

   In = OpenFile(FileName, "rt");
   do
     {
     InItem = 0.0; ClearString(InString);
     I = (int) fgets(InString, 1000, In);
     if (! I) break;
     strcpy(InString, TrimLeft(InString) );
     InItem = atof(InString);
     Unusable++;
     }
   while (!IsNum(*InString));
   Unusable--;

   while (! feof(In))
      {
	 if (Counters[0] > MaxSize)
	    {
	    printf
	    ("\nS101Vect: more than %d"
	     " elements in %s. Exiting.\n",
	     MaxSize, FileName);
	     fclose(In);
	     exit(1);
	     }

	 Data[Counters[0]] = InItem;
	 Counters[0]++;
	 Counters[1] += (long double) InItem;
	 Counters[2] += (long double) InItem
		     * (long double) InItem;
	 if (InItem > Counters[3])
	    Counters[3] = InItem;
	 if (InItem < Counters[4])
	    Counters[4] = InItem;
      do
	 {
	 InItem = 0.0; ClearString(InString);
	 I = (int) fgets(InString, 1000, In);
	 if (! I) break;
	 strcpy(InString, TrimLeft(InString) );
	 InItem = atof(InString);
	 Unusable++;
	 }
	 while (! IsNum(*InString));
	 Unusable--;
      }
   fclose(In);

   if (Counters[0] < 3)
      {
      printf("\nS101Vect: less than 3"
	     " elements in %s.\n",
	     FileName);
      exit(2);
      }
   if (Unusable)
      printf("\nS101Vect: Warning: %d unusable"
	     " items in %s",
	     Unusable, FileName);

   }  /* S101Vect ends. */
