/************************************************
 * ds1.c - ANSI C English version
 * Descriptive statistics
 * Single-pass file version
 * Joao Magalhaes 1997
 * jcm@mail.EUnet.pt
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <ctype.h>

#define OUTVALUES 12

#include "dsfileu.c"  /* file operations      */
#include "dsmath.c"   /* math operations      */
#include "dsoutu.c"   /* output functions     */

int main (int argc, char ** argv)
   {
   long double Counters[5],
               OutValues[OUTVALUES];
   char * FileName = argv[1];

   if (argc <2)
     {
     puts("\nDS1: kindly indicate a"
          " valid file name.\n");
     puts("\tUse: DS1 InFileName [>OutputFileName]\n");
     puts("Performs descriptive statistics of a file"
          " of reals in "
          "a single pass.");
     puts("Will not compute median, skewness and"
          " kurtosis.");
     printf("Freeware with ANSI C source. Joao Magalhaes 1997. ");
     printf("jcm@mail.EUnet.pt\n");
     printf("Test version compiled %s %s\n", __DATE__, __TIME__);
     exit(1);
     }

   while (*argv[1])
      {
      *argv[1] = toupper(*argv[1]);
      argv[1]++;
      }


   printf("FILE : %s ----------------------------\n",
          FileName);
   S101Fly(Counters, FileName);
   S101Math(OutValues, Counters);
   WOut(OutValues);
   return 0;
   } /* main version 1 ends. */
