//---------------------------------------------------------------------
// 1 Feb 2000
//---------------------------------------------------------------------
#include "settings.h"

int ShowSettingHelp()
{
	Disk oh;
	char *pchar[18];
	pchar[0] = "Help on changing settings";
	pchar[1] = " x To print to a file instead of to the printer change the";
	pchar[2] = "   name from 'LPT1' to the name of the file. The file will be";
	pchar[3] = "   written to the current directory path.";

	pchar[4] = " ";
	pchar[5] = " x When printing a spreadsheet the left margin can be";
	pchar[6] = "   increased or reduced. Sensible values are between 0 and 4.";
	pchar[7] = " ";
	pchar[8] = " x The number of lines per page is normally 58 for A-4 size";
	pchar[9] = "   paper. Don't adjust this beyond 60.";
	pchar[10] = " ";
	pchar[11] = " x Matrix records mouse clicking within a time-frame, the";
	pchar[12] = "   length of which can be changed. If the default setting";
	pchar[13] = "   doesn't suit you try increasing the time-frame slightly to";
	pchar[14] = "   allow for slower double-clicking. Sensible values are";
	pchar[15] = "   between 38 and 46. Normally you should leave this at 44.";

	pchar[1][1] =4;
	pchar[5][1] =4;
	pchar[8][1] =4;
	pchar[11][1] =4;

	oh.CursorOn();
	oh.ShowMouse();

	oh.ShowDialogBox(&pchar[0], 15, 1, 15, 0, 0);



	return 0;
}
//---------------------------------------------------------------------
// Display a message for the user asking him to press a key before
// printing the next page.
int ChangeSettings()
{
	int cursorpos, l, x, y, iii, ii, i, t, cursorfield;
	char numbufs[10][3];
	char buf[50];

	static char *pchar[12] = {"Change Settings",
														 " ",
														 "Print to       [......................]",
														 " ",
														 "Left Margin    [.....]",
														 " ",
														 "Lines Per Page [.....]",
														 " ",
														 "Double click",
														 " Time-frame    [.....]",
														 " "};


	//make a copy of the printerfile name in case the user
	//chooses cancel
	strcpy(buf, printerfile);

	a->CursorOn();
	a->ShowMouse();


//----
	TMousePos MousePos[7];

	MousePos[0].x1 = 36;    //print to [LPT1..................]
	MousePos[0].y1 = 7;
	MousePos[0].x2 = 57;
	MousePos[0].y2 = 7;

	MousePos[1].x1 = 36;    //Left Margin [.....]
	MousePos[1].y1 = 9;
	MousePos[1].x2 = 49;
	MousePos[1].y2 = 9;

	MousePos[2].x1 = 36;     //Lines Per Page [.....]
	MousePos[2].y1 = 11;
	MousePos[2].x2 = 40;
	MousePos[2].y2 = 11;

	MousePos[3].x1 = 36;     //Double click time-frame [.....]
	MousePos[3].y1 = 14;
	MousePos[3].x2 = 40;
	MousePos[3].y2 = 14;

	MousePos[4].x1 = 20;   //ok
	MousePos[4].y1 = 18;
	MousePos[4].x2 = 27;
	MousePos[4].y2 = 18;

	MousePos[5].x1 = 35;     //cancel
	MousePos[5].y1 = 18;
	MousePos[5].x2 = 44;
	MousePos[5].y2 = 18;

	MousePos[6].x1 = 52;     //help
	MousePos[6].y1 = 18;
	MousePos[6].x2 = 59;
	MousePos[6].y2 = 18;

	itoa(lm, &numbufs[0][0], 10);
	itoa(lpp, &numbufs[1][0], 10);
	itoa(double_click, &numbufs[2][0], 10);




	//---
	char tempbuf[81];
	strcpy(tempbuf, "F1=Help  Enter=Execute  Esc=Cancel  Tab=Next Field");
	a->WriteLine(tempbuf, 1, 24, 78, gbc[3]*16+gfc[3]);
	cursorfield =0;
	//---
	//display the settings dialog box and get out fast.
	//leaving it open.
	a->ShowDialogBox(&pchar[0], 10, 7, 10, 0, 1);

	//display the printer's filename in its field
	strcpy(linebuf1, printerfile);
	x = MousePos[0].x1;
	y = MousePos[0].y1;
	a->WriteLine(linebuf1, x, y, 22, LIGHTGRAY*16+BLACK, 1);

	//show the left margin figure in its field
	x = MousePos[1].x1;
	y = MousePos[1].y1;
	a->WriteLine(&numbufs[0][0], x, y, 5, LIGHTGRAY*16+BLACK, 1);

	//show the "lines per page" figure in its field
	x = MousePos[2].x1;
	y = MousePos[2].y1;
	a->WriteLine(&numbufs[1][0], x, y, 5, LIGHTGRAY*16+BLACK, 1);

	//show the"double click time-frame" figure in its field
	x = MousePos[3].x1;
	y = MousePos[3].y1;
	a->WriteLine(&numbufs[2][0], x, y, 5, LIGHTGRAY*16+BLACK, 1);

top:

	switch(cursorfield)  //determine where to show the little cursor
	{
		case 0:      //print to lpt1
a1:		gotoxy(MousePos[0].x1+1, MousePos[0].y1+1);
			a->m_buttonpressed =0;
			a->m_buttonscursorpos =0;
			a->ShowButtons();
			strcpy(inputbuf, printerfile);
			cursorpos = strlen(inputbuf);
			a->CursorOn();
			i = a->Input(&MousePos[0], 7, inputbuf, MousePos[0].x1,
						MousePos[0].y1, 22, 22, &cursorpos, LIGHTGRAY*16+BLACK,
						1+2+4+256, 1);
			a->CursorOn();
			if(i == 1) goto ex;  //esc pressed
			a->RightTrim(inputbuf);
			l = strlen(inputbuf);
			if(!l)
			{
				strcpy(inputbuf, "LPT1");
				strcpy(printerfile, "LPT1");
				goto a1;
			}
			strcpy(printerfile, inputbuf);

			if(i == 0) goto con; //<return> pressed
			if(i == 2 || i == 4)  // tab or down key
			{
				cursorfield = 1;
				goto h1;
			}
			if(i == 3)   //up from top input field to ok button
			{
				cursorfield =4;
				goto top;
			}


			if(i == 257) //clicked outside "LPT!" field?
				goto b1;
			break;

		case 1:       //left margin
h1:
		  gotoxy(MousePos[1].x1+1, MousePos[1].y1+1);
		  a->m_buttonpressed =0;
			a->m_buttonscursorpos =0;
			a->ShowButtons();
//------ go into input routine for left margin
lm1:		strcpy(inputbuf, &numbufs[0][0]);
			cursorpos = strlen(inputbuf);

			a->CursorOn();
			i = a->Input(&MousePos[0], 7, inputbuf, MousePos[1].x1,
						MousePos[1].y1, 4, 4, &cursorpos, LIGHTGRAY*16+BLACK,
						1+2+4+256, 1);
			a->CursorOn();
			if(i == 1) goto ex;  //esc pressed
			a->RightTrim(inputbuf);
			l = strlen(inputbuf);
			if(!l)
			{
				goto lm1;
			}
			strcpy(&numbufs[0][0], inputbuf);
			if(i == 0) goto con; //<return> pressed
			if(i == 2 || i == 4)  // tab or down key
			{
				cursorfield = 2;  //goto lpp field
				goto lpp1;
			}
			if(i ==3) 	//up to LPT1 field
			{
				cursorfield = 0;
				goto a1;
			}

			if(i == 257) //clicked outside "LPT!" field?
				goto b1;
			break;

//-------

		  break;

		case 2:       //lines per page
lpp1:	  gotoxy(MousePos[2].x1+1, MousePos[2].y1+1);
		  a->m_buttonpressed =0;
			a->m_buttonscursorpos =0;
			a->ShowButtons();
//-----goto the lines per page input routine

			strcpy(inputbuf, &numbufs[1][0]);
			cursorpos = strlen(inputbuf);

			a->CursorOn();
			i = a->Input(&MousePos[0], 7, inputbuf, MousePos[2].x1,
						MousePos[2].y1, 4, 4, &cursorpos, LIGHTGRAY*16+BLACK,
						1+2+4+256, 1);
			a->CursorOn();
			if(i == 1) goto ex;  //esc pressed
			a->RightTrim(inputbuf);
			l = strlen(inputbuf);
			if(!l)
			{
				goto lpp1;
			}
			strcpy(&numbufs[1][0], inputbuf);
			if(i == 0) goto con; //<return> pressed
			if(i == 2 || i == 4)  // tab or down key
			{
				cursorfield = 3;  //goto  the double click field
				goto dblclk1;
			}
			if(i ==3) 	//up to left margin field
			{
				cursorfield = 1;
				goto lm1;
			}

			if(i == 257) //clicked outside "LPT!" field?
				goto b1;
			break;

//-------
		case 3:       //double click time frame
dblclk1:
			gotoxy(MousePos[3].x1+1, MousePos[3].y1+1);
			a->m_buttonpressed =0;
			a->m_buttonscursorpos =0;
			a->ShowButtons();
//goto the input routine for the double-click field
			strcpy(inputbuf, &numbufs[2][0]);
			cursorpos = strlen(inputbuf);

			a->CursorOn();
			i = a->Input(&MousePos[0], 7, inputbuf, MousePos[3].x1,
						MousePos[3].y1, 4, 4, &cursorpos, LIGHTGRAY*16+BLACK,
						1+2+4+256, 1);
			a->CursorOn();
			if(i == 1) goto ex;  //esc pressed
			a->RightTrim(inputbuf);
			l = strlen(inputbuf);
			if(!l)
			{
				goto dblclk1;
			}
			strcpy(&numbufs[2][0], inputbuf);
			if(i == 0) goto con; //<return> pressed
			if(i == 2 || i == 4)  // tab or down key to ok button
			{
				cursorfield = 4;  //goto  the ok button
				goto ok;
			}
			if(i ==3) 	//up to lpp field
			{
				cursorfield = 2;
				goto lpp1;
			}

			if(i == 257) //clicked outside "LPT!" field?
				goto b1;
			break;

//-------

		case 4:       //ok
ok:	  gotoxy(MousePos[4].x1+4, MousePos[4].y1+1);
		  a->m_buttonpressed =0;
		  a->m_buttonscursorpos =0;
		  a->ShowButtons();
		  break;

		case 5:       //cancel
		  gotoxy(MousePos[5].x1+3, MousePos[5].y1+1);
		  a->m_buttonpressed =0;
		  a->m_buttonscursorpos =1;
		  a->ShowButtons();
		  break;

		case 6:       //help
		  gotoxy(MousePos[6].x1+3, MousePos[6].y1+1);
		  a->m_buttonpressed =0;
			a->m_buttonscursorpos =2;
			a->ShowButtons();
		  break;

	}



//----





get:
	chr = a->WaitGetMouseOrKey();
	//a->ShowCoordinates();
	if(chr == 27) goto ex;

	switch(chr)
	{

		case 31: //down
			if(cursorfield >= 4 && cursorfield <= 6)  //on ok button
			{
				cursorfield =0;
				goto top;
			}
			break;

	  case 30:	//cursor up from buttons to dblclk field
	  if(cursorfield >=4 && cursorfield <=6)
	  {
		 cursorfield = 3;
		 goto top;
	  }
	  break;

	  case 28: //cursor right
	  case 9:  //tab  have the same usage
		if(cursorfield >=4 && cursorfield <=6)
		{
			cursorfield++;
			if(cursorfield >6) cursorfield =4;
			//if it was a tab key and we are looping back again to the ok
			//button go instead to the 1st input field at the top
			//the LPT1 field
			if(cursorfield ==4 && chr == 9) cursorfield =0;
			goto top;
		}
		break;

		case 29:  //left from buttons loop around to buttons
		if(cursorfield >=4 && cursorfield <=6)
		{
			cursorfield--;
			if(cursorfield <4) cursorfield =6;
			goto top;
		}
		break;

		case 13:
		if(cursorfield >=4 && cursorfield <=6)
		{
			if(cursorfield == 4) goto con;        //<return> over ok button
			if(cursorfield == 5) goto ex;  	//<return> over cancle button
			ShowSettingHelp();            //<return> over help button
			a->ShowMouse();
			goto top;
		}
		break;

		case 257:	//click
b1:	ii = a->WhichFieldIsMouseIn2(&MousePos[0], &mouse, 7);
		if(ii == -1) goto get;
		switch(ii)
		{
			case 0: // clicked in "print to LPT1"
				cursorfield = ii;
				goto top;

			case 1: // clicked in "Left Margin"
				cursorfield = ii;
				goto top;

			case 2: // clicked in "lines per page"
				cursorfield = ii;
				goto top;

			case 3: // clicked in "Double click time-frame"
				cursorfield = ii;
				goto top;

			case 4: // clicked in "ok"
				//-----------
				cursorfield = 4;
				if(mouse.ButtonState)  //button pressed
				{
					a->m_buttonpressed =1;
					a->m_buttonscursorpos =0;
					a->ShowButtons();
					gotoxy(MousePos[4].x1+4, MousePos[4].y1+1);
					a->WaitMouseButtonRelease(-1);
					a->m_buttonpressed =0;
					a->ShowButtons();
					gotoxy(MousePos[4].x1+4, MousePos[4].y1+1);

					iii = a->WhichFieldIsMouseIn2(&MousePos[0], &mouse, 7);
					if(iii != 4)   //not released on button
					{
							cursorfield = 4;
							goto get;
					}
						else
							goto con;  //user chose "ok" button
				}
				//------------
				//released on ok button
				goto top;

			case 5: // clicked in "cancel"
				cursorfield = ii;
				//------------
				if(mouse.ButtonState)  //button pressed
				{
					a->m_buttonpressed =2;
					a->ShowButtons();
					gotoxy(MousePos[5].x1+3, MousePos[5].y1+1);
					a->WaitMouseButtonRelease(-1);
					a->m_buttonpressed =0;
					a->m_buttonscursorpos =1;
					a->ShowButtons();
					gotoxy(MousePos[5].x1+3, MousePos[5].y1+1);

					iii = a->WhichFieldIsMouseIn2(&MousePos[0], &mouse, 7);
					if(iii != 5)   //not released on button
					{
							cursorfield = 5;
							goto top;
					}
					else
						goto ex;  //user chose "cancel" button

			  }
				//a click released on cancel button
				//-----------
				goto top;

			case 6: // clicked in "help"
				cursorfield = ii;
				//------------
				if(mouse.ButtonState)  //button pressed
				{
					a->m_buttonpressed =3;
					a->ShowButtons();
					gotoxy(MousePos[6].x1+3, MousePos[6].y1+1);
					a->WaitMouseButtonRelease(-1);
					a->m_buttonpressed =0;
					a->m_buttonscursorpos =2;
					a->ShowButtons();
					gotoxy(MousePos[6].x1+3, MousePos[6].y1+1);

					iii = a->WhichFieldIsMouseIn2(&MousePos[0], &mouse, 7);
					if(iii != 6)   //not released on button
					{
							cursorfield = 6;
							goto top;
					}
					else
					{
						ShowSettingHelp();  //user chose "help" button
						goto top;
					}
			  }
				//a click released on cancel button
				//-----------
				goto top;


		}



	}
	goto get;

//user chose ok
//accept all the values and convert them into user's values
//their appropriate vars and close the dialog box and exit
con:

	lm = atoi(&numbufs[0][0]);
	lpp = atoi(&numbufs[1][0]);
	double_click = atoi(&numbufs[2][0]);
	if(lm < 0 || lm >5) lm = 2;
	if(lpp <20 || lpp >65) lpp = 58;
	if(double_click <34 || double_click >46) double_click =44;
	goto ex1;

ex:  //goes here if user chose cancel

	strcpy(printerfile, buf);
ex1:
	strupr(printerfile);
	a->CloseBox();
	return i;
}

//-------------------------------------------------------------------
