#ifndef __TDEF_H
#define __TDEF_H

/**********************************************************/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/*
Copyright: 1995 - Borja Etxebarria
*/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/**********************************************************/

/**********************************************************/
/* Definicion de un puntero normal, near y far  */

#define PTR  *        /* normal ptr */


#if __MSDOS__      /* MS-DOS only */

#define PTRN  near *  /* near ptr */
#define PTRF  far *   /* far ptr */
#define PTRH  huge *  /* huge ptr */

#elif 1     /* other OS, assume 32 bits */

#define PTRN  PTR
#define PTRF  PTR
#define PTRH  PTR

#endif

/**********************************************************/
/* New type definition pattern.
Defines type NAME, and a set of pointers to it: normal ptr (pNAME),
and near, far, huge ptrs (pnNAME, pfNAME, phNAME) */

#define __TDEF(TYPE,NAME)  \
	typedef TYPE NAME;  \
	typedef NAME PTR p##NAME;  \
	typedef NAME PTRN pn##NAME;  \
	typedef NAME PTRF pf##NAME;  \
	typedef NAME PTRH ph##NAME

/**********************************************************/

__TDEF(int, INT);          /* define INT, pINT, pnINT, pfINT */
__TDEF(long, LONG);
__TDEF(char, CHAR);
__TDEF(float, FLOAT);
__TDEF(double, DOUBLE);
__TDEF(void, VOID);
__TDEF(int, BOOL);

__TDEF(unsigned int, UINT);
__TDEF(unsigned long, ULONG);
__TDEF(unsigned char, UCHAR);

/**********************************************************/
/* booleans */

#define TRUE  1
#define FALSE  0

/**********************************************************/
/* definitions by fixed number of bits */

#if __MSDOS__

__TDEF(char, INT8);                /* signed ints */
__TDEF(int, INT16);
__TDEF(long, INT32);
__TDEF(unsigned char, UINT8);      /* unsigned ints */
__TDEF(unsigned int, UINT16);
__TDEF(unsigned long, UINT32);
__TDEF(char, CHAR8);               /* char */
__TDEF(unsigned char, UCHAR8);     /* unsigned char */
__TDEF(float, FLOAT32);            /* float types */
__TDEF(double, FLOAT64);
__TDEF(long double, FLOAT80);

#elif 1     /* other OS, assume 32 bit compiler */

__TDEF(char, INT8);
__TDEF(short, INT16);
__TDEF(int, INT32);
__TDEF(unsigned char, UINT8);
__TDEF(unsigned short, UINT16);
__TDEF(unsigned int, UINT32);
__TDEF(char, CHAR8);
__TDEF(unsigned char, UCHAR8);
__TDEF(float, FLOAT32);
__TDEF(double, FLOAT64);
__TDEF(long double, FLOAT80);

#endif


/* other typenames for unsigned types */

__TDEF(UINT8, WORD8 );
__TDEF(UINT16, WORD16);
__TDEF(UINT32, WORD32 );

/**********************************************************/
/* fixed length types, in octets */

__TDEF(INT8, INT1);
__TDEF(INT16, INT2);
__TDEF(INT32, INT4);
__TDEF(WORD8, WORD1);
__TDEF(WORD16, WORD2);
__TDEF(WORD32, WORD4);
__TDEF(UINT8, UINT1);
__TDEF(UINT16, UINT2);
__TDEF(UINT32, UINT4);
__TDEF(CHAR8, CHAR1);
__TDEF(UCHAR8, UCHAR1);
__TDEF(FLOAT32, FLOAT4);
__TDEF(FLOAT64, FLOAT8);
__TDEF(FLOAT80, FLOAT10);

/**********************************************************/
/* scope management */

#define PUBLIC
#define PRIVATE static
#define EXTERN extern
#define STATIC static
#define VOLATILE volatile

/**********************************************************/

#endif

