/***************************************************************************/
/* SndShell.c  -- Routines to display sound files                          */
/* Copyright (c) 1995 John A. Ball                                         */
/*                                                                         */
/* This source is available for your own personal use only! You may make   */
/* any changes you wish but please do not distribute modified source code. */
/* Please notify me of any errors or improvements.                         */
/*                                                                         */
/* must use large or compact model to build                                */
/* i.e.   qcl/AL /c sndshell.c                                             */
/*                                                                         */
/* by John A. Ball   May 3, 1998                                           */
/***************************************************************************/


/***************************************************************************/
#include "sbplay.h"
/***************************************************************************/

extern int error;
extern int multi_error;
extern int default_bits;
extern int play_rate;
extern int lcount;
extern int speak;
extern int dcount;
extern int magnitude;
extern int volume;
extern int ctwav;
extern int ctsnd;
extern int ctsam;
extern int ctvoc;
extern int rip;
extern int file_info;
extern char * msg;
int play_sound(char * file_name);

#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <errno.h>
#include <stdlib.h>
#include <graph.h>
#include <search.h>
#include <string.h>
#include <time.h>
#include <mouse.h>

#define ESC 27
#define ORIGIN x=3,y=6;
#define CR 13
#define BS 8
#define ShTAB 271
#define HOME 327
#define UPAR 328
#define PGUP 329
#define LFAR 331
#define RGAR 333
#define KEND 335
#define DNAR 336
#define PGDN 337
#define TAB 9
#define F1 315
#define F2 316
#define F3 317
#define F4 318
#define F5 319
#define F6 320
#define F7 321
#define F8 322
#define F9 323
#define F10 324
#define BREAK -1

char const TOP[]={218,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,191};
char const BOX[]={179,32,32,32,32,32,32,32,32,32,
		  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
		  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
		  32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
		  32,32,32,32,32,32,32,32,32,179};
char const BOTTOM[]={192,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,196,
		  196,196,196,196,196,196,196,196,196,217};
char const COMMAND1[]={32,17,196,217,32,'t','o',32,'h','e',
		     'a','r',32,32,32,32,32,32,32,32,
		     176,32,70,49,32,67,104,97,110,103,
		     101,32,68,101,102,97,117,108,116,115,
		     176,32,70,50,32,82,101,97,100,32,
		     68,105,114,101,99,116,111,114,121,32,
		     176,32,70,51,32,67,104,97,110,103,
		     101,32,68,114,105,118,101,32,32,32,
		     0};
char const COMMAND2[]={32,70,52,32,'C','o','n','v','e','r',
		     't',32,'t','o',32,'W','A','V',32,32,
		     176,32,70,53,32,'R','i','p',32,32,
		     32,32,32,32,32,32,32,32,32,32,
		     176,32,70,54,32,'S','o','u','n','d',
		     32,'I','n','f','o',32,32,32,32,32,
		     176,32,70,55,32,'F','i','l','e',32,
		     'I','n','f','o',32,32,32,32,32,32,
		     0};
char const COMMAND3[]={32,70,56,32,'C','o','n','v','e','r',
		     't',32,'t','o',32,'V','O','C',32,32,
		     176,32,70,57,32,'D','e','l','e','t',
		     'e',32,32,32,32,32,32,32,32,32,
		     176,32,70,49,48,32,'R','e','n','a',
		     'm','e',32,32,32,32,32,32,32,32,
		     176,32,69,115,99,32,116,111,32,101,
		     120,105,116,32,32,32,32,32,32,
		     0};
char const UA[]={180,174,195,0};
char const DA[]={180,175,195,0};
char const LINE[]={196,196,196,0};

char const HELP1[]="Arrow keys to move \nEscape to quit\nPgUp for previous page\n";
char const HELP5[]="PgDn for next page\nEnter key to select file or\n  change directories\n";
char const HELP6[]="D Delete File\nR Rename File\n";
char const HELP7[]="C Copy File";
char *errors[13]={
	      {"Attempt to write to a write-protected disk"},
	      {"Unknown unit"},
	      {"Drive not ready"},
	      {"Unknown command"},
	      {"Data error"},
	      {"Bad request structure length"},
	      {"Seek error"},
	      {"Unknown media type"},
	      {"Sector not found"},
	      {"Printer out of paper"},
	      {"Write fault"},
	      {"Read fault"},
	      {"General failure"}};

char ulc[]={32,0,218,0,201,0,213,0,214,0};
char vl[]={32,0,179,0,186,0,179,0,186,0};
char urc[]={32,0,191,0,187,0,184,0,183,0};
char hl[]={32,0,196,0,205,0,205,0,196,0};
char llc[]={32,0,192,0,200,0,212,0,211,0};
char lrc[]={32,0,217,0,188,0,190,0,189,0};

int snd_shell(void);
void display_help();
void display_menu(void);
void display_intro(void);
int show_files(char *fnp,int num);
char *get_files(char *fnp);
int find_files(void);
int show_cursor(char *fnp, int cp);
char *play_it(char *fnp);
char *new_dir(char *fnp);
char *update_dir(char *fnp);
int show_file_info(char *fnp);
void clear_display(void);
int *save_screen(int x1, int y1, int x2, int y2);
int restore_screen(int *screen, int x1, int y1, int x2, int y2);
int get_char(int x, int y,int page);
void put_char(int Char, int x, int y,int page);
void draw_box(int type, int x1, int y1, int x2, int y2, int Char);
void set_defaults();
void get_rate(void);
void get_vol(void);
void get_delay(void);
int save_defaults(void);
void _interrupt _cdecl _far brk_handler();
void print_page(void);
void print_q(void);
void print_dv(void);
void print_number(unsigned rate);
unsigned input_number(int row, int col);
int get_key(void);
void _far error_handler(unsigned deverror, unsigned errcode, unsigned _far *devhdr);
void change_drive(void);
int mouse_event(void);
void give_cpu(void);
int delete(char *fnp);
int ren_file(char *fnp);
int copyfile(char *fnp);
char *datestr( unsigned d, char *buf );
int display_exit(void);
int find_dv(void);
char *get_path(void);
int get_defaults(void);
char *get_string(char *string,int start);
void reg_SBPlay(void);

   long fileinfo(struct find_t *find);
   int num=0;
   int pages=1;
   int old_page=1;
   int cur_page=1;
   int cp=1;
   int old_cp=1;
   char *fnp=NULL;
   int remainder=1;
   int display_max=1;
   int error;
   time_t p_time;
   time_t c_time;
   int *screen;
   int num_floppies=0;
   int num_drives=0;
   int old_drive=-1;
   static char path[_MAX_PATH];
   static char default_path[_MAX_PATH];
   int Mouse=0;
   int disk_error=0;
   int disk_errors=0;
   char fmsg[]="Error! ";
   int in_dv=0;
   char *reg_owner;
   char ser_number[10];
   char reg_name[40];
   int fix1=0;
   int fix2=0;

int snd_shell(void)
{
    short blink, oldcur, fgd, oldfgd;
    long bgd,oldbgd;
    int i=0, j=0;
    int key=0;
    struct find_t find;
    char *fn;
    int x=3,y=6;
    int *screen;
    struct rccoord oldpos;

    _dos_setvect(0x23,brk_handler);
    _harderr(error_handler);

    /* Save original foreground, backgroud, and text position. */

    oldcur = _settextcursor(0x2000);
    screen=save_screen(1, 1, 25, 80);
    oldfgd = _gettextcolor();
    oldbgd = _getbkcolor();
    oldpos = _gettextposition();
    
    /* Save original path */

    getcwd(path,_MAX_PATH);

    strcpy(reg_name,"Unregistered");
    strcpy(ser_number,"000000");

    _setbkcolor(1);
    _clearscreen(_GCLEARSCREEN);
    _setbkcolor(9);

    _settextcolor(15);
    _settextposition(1,1);
    _outmem(TOP,80);
    _settextposition(2,1);
    for (j=0;j<20;j++)
    {
     _outmem(BOX,80);
    }
    _settextposition(22,1);
    _outmem(BOTTOM,80);
    _settextposition(22,6);
    _outtext(VERSION);
   time(&p_time);
    display_intro();
    _settextcolor(11);
    _settextposition(23,1);
    _outtext(COMMAND1);
    _outtext(COMMAND2);
    _outtext(COMMAND3);

    Mouse=MouseInit();

    if(Mouse){
      SetPtrPos(2,2);
      SetPtrVis(SHOW);
    }

    in_dv=find_dv();
    get_defaults();
    time(&c_time);
    while((c_time-p_time) < 5){
     time(&c_time);
    };

     fnp=new_dir(fnp);

	while(key!=ESC){
	show_cursor(fnp,cp);
	old_cp=cp;
	disk_errors=0;
	key=get_key();
	switch (key){
	   case CR:
	     fnp=play_it(fnp);
	     break;
	   case 'c':
	   case 'C':
	     disk_error=copyfile(fnp);
	     if(disk_error){
	       time(&p_time);
	       while((c_time-p_time) < 2){
		 time(&c_time);
	       };
	     }
	     fnp=update_dir(fnp);
	     display_menu();
	     break;
	   case 'D':
	   case 'd':
	     disk_error=delete(fnp);
	     fnp=update_dir(fnp);
	     break;
	   case 'R':
	   case 'r':
	     disk_error=ren_file(fnp);
	     fnp=update_dir(fnp);
	     break;
	   case '@':
	     reg_SBPlay();
	     break;
	   case HOME:
	     cp=1;
	     break;
	   case UPAR:
	     if(cp>1)cp-=1;
	     break;
	   case PGUP:
	     if(cur_page>1){
	       cur_page-=1;
	       cp=1;
	       old_cp=1;
	       if(cur_page==pages)display_max=remainder;
	       else display_max=72;
	       show_page(fnp,num);
	     }
	     break;
	   case KEND:
	     cp=display_max;
	     break;
	   case DNAR:
	     cp+=1;
	     if(cp>display_max)cp=display_max;
	     break;
	   case PGDN:
	     if(cur_page < pages){
	       cur_page+=1;
	       cp=1;
	       old_cp=1;
	       if(cur_page==pages)display_max=remainder;
	       else display_max=72;
	       show_page(fnp,num);
	     }
	     break;
	   case TAB:
	   case RGAR:
	     cp+=18;
	     if(cp>display_max)cp-=18;
	     break;
	   case ShTAB:
	   case LFAR:
	     cp-=18;
	     if(cp<1)cp+=18;
	     break;
	   case '?':
	     display_help();
	     break;
	   case F1:
	     set_defaults();
	     fnp=new_dir(fnp);
	     break;
	   case F2:
	     fnp=new_dir(fnp);
	     break;
	   case F3:
	     change_drive();
	     fnp=new_dir(fnp);
	     break;
	   case F4:
	     ctwav=1;
	     fnp=play_it(fnp);
	     ctwav=0;
	     fnp=update_dir(fnp);
	     break;
	   case F5:
	     rip=1;
	     ctsam=1;
	     fnp=play_it(fnp);
	     rip=0;
	     ctsam=0;
	     fnp=update_dir(fnp);
	     break;
	   case F6:
	     file_info=1;
	     fnp=play_it(fnp);
	     file_info=0;
	     break;
	   case F7:
	     show_file_info(fnp);
	     break;
	   case F8:
	     ctvoc=1;
	     fnp=play_it(fnp);
	     ctvoc=0;
	     fnp=update_dir(fnp);
	     break;
	   case F9:
	     disk_error=delete(fnp);
	     fnp=update_dir(fnp);
	     break;
	   case F10:
	     disk_error=ren_file(fnp);
	     fnp=update_dir(fnp);
	     break;
	   case ESC:
	     key=display_exit();
	     break;
	   default:
	     give_cpu();
	     break;
	}}
      if(fnp!=NULL)free(fnp);

    if(Mouse)SetPtrVis(HIDE);
    
    /* Restore original drive and directory */

    if(old_drive>=0)_dos_setdrive(old_drive,&num_drives);
    chdir(path);

    /* Restore original foreground and background. */
    
    _settextcolor(oldfgd);
    _setbkcolor(oldbgd);
    _clearscreen(_GCLEARSCREEN );
    restore_screen(screen, 1, 1, 25, 80);
    _settextwindow(1,1,25,80);
    _settextposition(oldpos.row, oldpos.col);
    _settextcursor(oldcur);
    return(0);

}

int find_files(void)
{
   struct find_t find;
   int i=0;

   if(!_dos_findfirst("*.*", _A_NORMAL | _A_SUBDIR, &find))
   {
    if(strcmp(find.name,"."))
     i++;
     while(!_dos_findnext(&find))
     {
      i++;
     }
     pages=(i-1)/72 + 1;
   }
   return(i);
}

char *get_files(char *fnp)
{
   struct find_t find;
   char *fn;
   int i=0;

   fn=fnp;
   if(!_dos_findfirst("*.*", _A_NORMAL | _A_SUBDIR, &find)){
     if(strcmp(find.name,".")){
       if(!(find.attrib & _A_NORMAL))strcpy(fn,"D");
       if(!(find.attrib & _A_SUBDIR)){
	 strcpy(fn,"N");
	 if(strstr(find.name,".VOC"))strcpy(fn,"F");
	 if(strstr(find.name,".WAV"))strcpy(fn,"F");
	 if(strstr(find.name,".IFF"))strcpy(fn,"F");
	 if(strstr(find.name,".SND"))strcpy(fn,"F");
	 if(strstr(find.name,".AIF"))strcpy(fn,"F");
	 if(strstr(find.name,".AU"))strcpy(fn,"F");
	 if(strstr(find.name,".SAM"))strcpy(fn,"F");
	 if(strstr(find.name,".MOD"))strcpy(fn,"F");
       }
       fn++;
       *fn=' ';
       fn++;
       strcpy(fn,find.name);
       fn+=14;
      }
     while(!_dos_findnext(&find)){
       if(!(find.attrib & _A_NORMAL))strcpy(fn,"D");
       if(!(find.attrib & _A_SUBDIR)){
	 strcpy(fn,"N");
	 if(strstr(find.name,".VOC"))strcpy(fn,"F");
	 if(strstr(find.name,".WAV"))strcpy(fn,"F");
	 if(strstr(find.name,".IFF"))strcpy(fn,"F");
	 if(strstr(find.name,".SND"))strcpy(fn,"F");
	 if(strstr(find.name,".AIF"))strcpy(fn,"F");
	 if(strstr(find.name,".AU"))strcpy(fn,"F");
	 if(strstr(find.name,".SAM"))strcpy(fn,"F");
	 if(strstr(find.name,".MOD"))strcpy(fn,"F");
       }
       fn++;
       *fn=' ';
       fn++;
       strcpy(fn,find.name);
       fn+=14;
     }
   }
   fn=fnp;
   qsort(fn, num, 16, strcmp);
   return(fnp);
}

int show_files(char *fnp,int num)
{
   int j=0;
   int ORIGIN
   char *fn;

   fn=fnp;
   fn+=((cur_page-1)*1152);
   print_page();
   print_q();
   print_dv();
   clear_display();

   ORIGIN
   j=0;

   while((j<72) && (j<display_max)){
     if(x > 20){
       x=3;
       y+=18;
     }
     _settextposition(x,y);
     if(*fn == 'F')_settextcolor(14);
     else if(*fn == 'N')_settextcolor(15);
     else if(*fn == 'D')_settextcolor(11);
     else strcpy(fn,"              ");

     fn+=2;
     _outtext(fn);
     x++;
     j++;
     fn+=14;
   }
   return(0);
}

int show_cursor(char *fnp, int cp)
{
	int ORIGIN
	int i=0;
	int t=0;
	int len=0;
	char *fn;
	char blank[]="            ";
	char name[]="            ";

	if(fnp !=NULL){
	 fn=fnp;
	 fn+=((cur_page-1)*1152);
	 t=old_cp-1;
	 strcpy(name,blank);
	 fn+=(t*16)+2;
	 len=strlen(fn);
	 for(i=0;i<len;i++){
	  name[i]=fn[i];
	 }

	 if(old_cp <= 18){
	   x+=t;
	 }
	 if((18 < old_cp) && (old_cp <= 36)){
	   x+=t-18;
	   y+=18;
	 }
	 if ((36 < old_cp) && (old_cp <= 54)){
	   x+=t-36;
	   y+=36;
	 }
	 if ((54 < old_cp) && (old_cp <= 72)){
	   x+=t-54;
	   y+=54;
	 }
	 if(Mouse)SetPtrVis(HIDE);
	 _settextposition(x,y);
	 _setbkcolor(9);
	 fn-=2;
	 if(*fn == 'F')_settextcolor(14);
	 else if(*fn == 'N')_settextcolor(15);
	 else if(*fn == 'D')_settextcolor(11);
	 else strcpy(name,blank);
	 _outtext(name);

	 ORIGIN
	 fn=fnp;
	 fn+=((cur_page-1)*1152);
	 t=cp-1;
	 strcpy(name,blank);

	 fn+=(t)*16+2;
	 len=strlen(fn);
	 for(i=0;i<len;i++){
	  name[i]=fn[i];
	 }

	 if(cp <= 18){
	   x+=t;
	 }
	 if((18 < cp) && (cp <= 36)){
	   x+=t-18;
	   y+=18;
	 }
	 if ((36 < cp) && (cp <= 54)){
	   x+=t-36;
	   y+=36;
	 }
	 if ((54 < cp) && (cp <= 72)){
	   x+=t-54;
	   y+=54;
	 }
	 if(cp>display_max)strcpy(name,blank);
	 _settextposition(x,y);
	 _setbkcolor(7);
	 _settextcolor(0);
	 _outtext(name);
	 _settextposition(x,y);
	 if(Mouse)SetPtrVis(SHOW);
	 return(0);
	}
	else{
	 _settextposition(x,y);
	 _setbkcolor(7);
	 _settextcolor(0);
	 _outtext(" No files!  ");
	 return(0);
	}
}

char *play_it(char * fnp)
{
	int i=0;
	char file_name[13];
	char *fn;
	int file=1;

	error=0;
	fn=fnp;
	fn+=((cur_page-1)*1152);
	i=cp-1;
	fn+=i*16 + 2;
	strcpy(file_name,fn);
	_settextposition(23,1);
	_settextcolor(12);
	_setbkcolor(9);
	  for(i=0;i<6;i++){
	    _outtext("                                       ");
	  }
	_settextposition(23,1);

	fn-=2;
	if(*fn == 'F')file=1;
	if(*fn == 'N')file=1;
	if(*fn == 'D')file=0;

	if(file) error=play_sound(file_name);

	if(!file){
	  if(strcmp(file_name,".")){
	    cp=1;
	    old_cp=1;
	    cur_page=1;
	    old_page=1;
	    error=chdir(file_name);
	    fnp=new_dir(fnp);
	  }
	}
	if(error>0 || (multi_error)){
	  time(&p_time);
	  time(&c_time);
	  while((c_time-p_time) < 2){
	   time(&c_time);
	  };
	}
	error=0;
	multi_error=0;
	display_menu();
	return(fnp);
}

void display_menu(void)
{
    _setbkcolor(9);
    _settextcolor(11);
    _settextposition(23,1);
    _outtext(COMMAND1);
    _outtext(COMMAND2);
    _outtext(COMMAND3);
}

int show_page(char *fnp,int num)
{
   int j=0;
   int ORIGIN
   int error=0;
   char *fn;
   char blank[]="            ";

   fn=fnp;
   if(Mouse)SetPtrVis(HIDE);

   print_page();

   if(old_page != cur_page){
    fn+=((cur_page-1)*1152);
    print_page();

   while(j<72){
     if(x > 20){
       x=3;
       y+=18;
     }
     _settextposition(x,y);
     _settextcolor(9);
     _setbkcolor(9);
     _outtext(blank);
     x++;
     j++;
   }

   ORIGIN
   j=0;

   while(j<display_max){
     if(x > 20){
       x=3;
       y+=18;
     }
     _settextposition(x,y);
     if(*fn == 'F')_settextcolor(14);
     if(*fn == 'N')_settextcolor(15);
     if(*fn == 'D')_settextcolor(11);
     fn+=2;
     _outtext(fn);
     x++;
     j++;
     fn+=14;
   }
     old_page=cur_page;
   }
   if(Mouse)SetPtrVis(SHOW);
}

char *new_dir(char *fnp)
{
      int error=0;
      char *fn;

      cp=1;
      old_cp=1;
      cur_page=1;
      old_page=1;
      if(fnp!=NULL)free(fnp);

      if(Mouse)SetPtrVis(HIDE);
      clear_display();
      num=find_files();
      if(num>0){
       remainder=num%72;
       if((num-((cur_page)*72))>0)display_max=72;
       else display_max=remainder;
       if(cp>display_max)cp=display_max;
       fnp=malloc(16*num);
       fn=fnp;
       if(fnp){
	fn=get_files(fnp);
	error=show_files(fnp,num);
	if(Mouse)SetPtrVis(SHOW);
	return(fnp);
       }
       else _outtext("Failure to allocate memory for file names!\n");
      }
      return(NULL);
}

char *update_dir(char *fnp)
{
      int error=0;
      char *fn;

      if(fnp!=NULL)free(fnp);

      if(Mouse)SetPtrVis(HIDE);
      clear_display();
      num=find_files();
      if(num>0){
       remainder=num%72;
       if((num-((cur_page)*72))>0)display_max=72;
       else display_max=remainder;
       fnp=malloc(16*num);
       fn=fnp;
       if(fnp){
	fn=get_files(fnp);
	error=show_files(fnp,num);
	if(Mouse)SetPtrVis(SHOW);
	return(fnp);
       }
       else _outtext("Failure to allocate memory for file names!\n");
      }
      return(NULL);
}

void display_intro(void)
{
	_settextposition(3,6);
	_setbkcolor(9);
	_settextcolor(11);
	_outtext(PROGRAM);
	_outtext(PURPOSE);
	_settextposition(5,6);
	_outtext("Plays .WAV, .VOC, .SND, .IFF, .AIF, .SAM, & .MOD Sound Files");
	_settextposition(6,6);
	_outtext("on ");
	_outtext(CARD);
	_outtext(" and the PC speaker.");
	_settextposition(16,9);
	_outtext(OWNER);
	_settextposition(18,25);
	_outtext(SERIAL);
	_settextposition(20,9);
	_outtext(COPYRIGHT);
}

void display_help(void)
{
	int x1=5,x2=15;
	int y1=25,y2=55;
	int i=0;
	int attr=15;
	int box_type=1;
	struct rccoord oldpos;

	oldpos=_gettextposition();
	if(Mouse)SetPtrVis(HIDE);
	screen=save_screen(x1, y1, x2, y2);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_outtext(HELP1);
	_outtext(HELP5);
	_outtext(HELP6);
	_outtext(HELP7);
	while( _bios_keybrd(_KEYBRD_READY ) )
	_bios_keybrd(_KEYBRD_READ);
	i = _bios_keybrd(_KEYBRD_READ );
	restore_screen(screen, x1, y1, x2, y2);
	_settextwindow(1,1,25,80);
	_settextposition(oldpos.row, oldpos.col);
	if(Mouse)SetPtrVis(SHOW);
}

void clear_display(void)
{
   int j=0;
   int ORIGIN
   char blank[]="                  ";

   while(j<72){
     if(x > 20){
       x=3;
       y+=18;
     }
     _settextposition(x,y);
     _settextcolor(9);
     _setbkcolor(9);
     _outtext(blank);
     x++;
     j++;
   }
}

int *save_screen(int x1, int y1, int x2, int y2)
{
	int i=0;
	int j=0;
	int letter;
	int *buffer;
	int *bp;
	int num_words=0;

	num_words=((x2-x1+1)*(y2-y1+1));
	buffer=(int *)malloc(num_words*sizeof(int));
	bp=buffer;
	 for(i=x1;i<=x2;i++){
	  for(j=y1;j<=y2;j++){
	   *bp=get_char(i,j,0);
	   bp++;
	  }
	 }
	return(buffer);
}

int restore_screen(int *screen, int x1, int y1, int x2, int y2)
{
	int i=0;
	int j=0;
	int *buffer;

	buffer=screen;

	for(i=x1;i<=x2;i++){
	  for(j=y1;j<=y2;j++){
	   put_char(*buffer,i,j,0);
	   buffer++;
	  }
	 }
	 free(screen);
}

int get_char(int x, int y,int page)
{
	x--;
	y--;
	_asm{
	    mov ah,2
	    mov dh,x
	    mov dl,y
	    mov bh,page
	    int 10h
	    mov ah,8
	    mov bh,page
	    int 10h
	}
}

void put_char(int Char, int x, int y, int page)
{

	x--;
	y--;
	_asm{
	    mov ah,2
	    mov dh,x
	    mov dl,y
	    mov bh,0
	    int 10h
	    mov ax,Char
	    mov bl,ah
	    mov ah,9
	    mov cx,1
	    int 10h
	}
}

void draw_box(int type, int x1, int y1, int x2, int y2, int attr)
{
	int i=0;
	int j=0;
	type=type*2;

	if(Mouse)SetPtrVis(HIDE);
	_setbkcolor(attr);
	  _settextposition(x1,y1);
	  _outtext(&ulc[type]);
	  for(i=y1+1;i<y2;i++){
	   _outtext(&hl[type]);
	  }
	  _outtext(&urc[type]);
	  for(i=x1+1;i<x2;i++){
	   _settextposition(i,y1);
	   _outtext(&vl[type]);
	   for(j=y1+1;j<y2;j++){
	    _outtext(" ");
	   }
	   _outtext(&vl[type]);
	  }
	  _settextposition(x2,y1);
	  _outtext(&llc[type]);
	  for(i=y1+1;i<y2;i++){
	   _outtext(&hl[type]);
	  }
	  _outtext(&lrc[type]);
	  if(Mouse)SetPtrVis(SHOW);
}

void set_defaults(void)
{
	int x1=3,x2=20;
	int y1=22,y2=52;
	int attr=15;
	int box_type=1;
	int key=0;
	struct rccoord oldpos;

	if(Mouse)SetPtrVis(HIDE);
	oldpos=_gettextposition();
	screen=save_screen(x1, y1, x2, y2);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_settextposition(7,0);
	_outtext(" # signed data\n");
	_outtext(" % unsigned data\n");
	_outtext(" R change playback rate\n");
	_outtext(" ! amplify sound samples\n");
	_outtext(" & silence sound samples\n");
	_outtext(" N normal samples\n");
	_outtext(" V change playback volume\n");
	_outtext(" S save defaults\n");
	_outtext(" D change Timer is ");
	 print_number(lcount);
	_outtext("\n ESC to return");

	while(key!=ESC){
	 _settextposition(0,0);
	 _outtext("Type is ");
	 if(default_bits < 0)_outtext("8 Bit Signed Data  \n");
	 else _outtext("8 Bit Unsigned Data\n");
	 _outtext("Playback rate is ");
	 print_number(play_rate);
	 _outtext(" hz  ");
	 _outtext("\n\n");
	 if(magnitude==1)_outtext("Amplify Samples \n");
	 if(magnitude==0)_outtext("Normal Samples  \n");
	 if(magnitude==-1)_outtext("Decrease Samples\n");
	 _outtext("Sound volume is ");
	 print_number(volume);
	 _outtext("   ");
	 _settextposition(15,20);
	 print_number(lcount);
	 _outtext("      ");

	key=get_key();
	switch (key){
	   case 'R':
	   case 'r':
	     _settextwindow(1,1,25,80);
	     get_rate();
	     _settextwindow(x1+1,y1+1,x2-1,y2-1);
	     break;
	   case '!':
	     magnitude=1;
	     break;
	   case 'N':
	   case 'n':
	     magnitude=0;
	     break;
	   case '&':
	     magnitude=-1;
	     break;
	   case 'V':
	   case 'v':
	     _settextwindow(1,1,25,80);
	     get_vol();
	     _settextwindow(x1+1,y1+1,x2-1,y2-1);
	     break;
	   case '#':
	     default_bits=-8;
	     break;
	   case '%':
	     default_bits=8;
	     break;
	   case 'S':
	   case 's':
	     _settextwindow(1,1,25,80);
	     save_defaults();
	     _settextwindow(x1+1,y1+1,x2-1,y2-1);
	     break;
	   case 'D':
	   case 'd':
	     _settextwindow(1,1,25,80);
	     get_delay();
	     _settextwindow(x1+1,y1+1,x2-1,y2-1);
	     break;
	   }
	}
	restore_screen(screen, x1, y1, x2, y2);
	_settextwindow(1,1,25,80);
	_settextposition(oldpos.row, oldpos.col);
	if(Mouse)SetPtrVis(SHOW);
}

void get_rate(void)
{
	int x1=15,x2=17;
	int y1=25,y2=50;
	int attr=15;
	int box_type=2;
	unsigned rate=0;
	int *screen;
	int ok=0;
	short row1,row2;
	short col1,col2;
	struct rccoord oldpos;

	oldpos=_gettextposition();
	_gettextwindow(&row1,&col1,&row2,&col2);
	screen=save_screen(x1, y1, x2, y2);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_outtext(" Play back Rate? ");
	_settextcursor(0x707);
	rate=input_number(1,18);
	_settextcursor(0x2000);
	if((rate > 4000) && (rate < 45000))play_rate=rate;
	restore_screen(screen, x1, y1, x2, y2);
	_settextwindow(row1,col1,row2,col2);
	_settextposition(oldpos.row, oldpos.col);
}

int save_defaults(void)
{
	int x1=15,x2=17;
	int y1=15,y2=70;
	int attr=15;
	int box_type=2;
	int *screen;
	short row1,row2;
	short col1,col2;
	struct rccoord oldpos;
	int ini_handle=0;
	int length=0;
	char *file_buffer;
	char *owner;
	char *serial;
	char *path;
	char *command;
	char *sound_path;
	char s_path[_MAX_PATH];
	char string[80];

	     strcpy(s_path,".");
	     sound_path=getenv("SOUND");
	     if(sound_path!=NULL){
	       strcpy(s_path,sound_path);
	     }
	     strcat(s_path,"\\SBPLAY.INI");
	     ini_handle = open( s_path, O_TEXT | O_RDWR | O_CREAT | O_TRUNC,
		  S_IREAD | S_IWRITE);
	     if(ini_handle== -1)return(0);
	     else{
	       file_buffer=malloc(2048);
	       if(file_buffer==NULL){
		 printf("Could not allocate buffer for .ini file\n");
		 return(10);
	       }
	       time(&p_time);
	       oldpos=_gettextposition();
	       _gettextwindow(&row1,&col1,&row2,&col2);
	       screen=save_screen(x1, y1, x2, y2);
	       draw_box(box_type, x1, y1, x2, y2, attr);
	       _settextwindow(x1+1,y1+1,x2-1,y2-1);
	       _outtext("Saving ");
	       _outtext(s_path);
	       time(&c_time);
	       while((c_time-p_time) < 3){
		 time(&c_time);
	       };
	restore_screen(screen, x1, y1, x2, y2);
	_settextwindow(row1,col1,row2,col2);
	_settextposition(oldpos.row, oldpos.col);
	       strcpy(file_buffer,";SBPlay initialization file for setting miscellaneous defaults\n");
	       strcat(file_buffer,"OWNER=\"");
	       strcat(file_buffer,reg_name);
	       strcat(file_buffer,"\"\nREG_NO=\"");
	       strcat(file_buffer,ser_number);
	       strcat(file_buffer,"\"\nDEFAULT_PATH=\"");
	       strcat(file_buffer,default_path);
	       strcat(file_buffer,"\"\nTYPE=\"");
	       if(default_bits<0)strcat(file_buffer,"SIGNED");
	       else strcat(file_buffer,"UNSIGNED");
	       strcat(file_buffer,"\"\nRATE=\"");
	       itoa(play_rate,string,10);
	       strcat(file_buffer,string);
	       strcat(file_buffer,"\"\nVOLUME=\"");
	       itoa(volume,string,10);
	       strcat(file_buffer,string);
	       strcat(file_buffer,"\"\nAMPLIFY=\"");
	       if(magnitude==1)strcat(file_buffer,"PLUS");
	       if(magnitude==0)strcat(file_buffer,"NONE");
	       if(magnitude==-1)strcat(file_buffer,"MINUS");
	       strcat(file_buffer,"\"\nTIMER=\"");
	       itoa(lcount,string,10);
	       strcat(file_buffer,string);
	       strcat(file_buffer,"\"\n");
	       if(fix1)strcat(file_buffer,"FIX=T1\n");
	       if(fix2)strcat(file_buffer,"FIX=T2\n");
	       length=strlen(file_buffer);
	       write(ini_handle,file_buffer,length);
	       close(ini_handle);
	     }

}

void _interrupt _cdecl _far brk_handler()
{
	return;
}

void print_page(void)
{
    char page[40];
    char num[8];
    page[0]=0;

    _settextposition(1,6);
    _setbkcolor(9);
    _settextcolor(15);
    strcat(page,"[ Page ");
    itoa(cur_page,num,10);
    strcat(page,num);
    strcat(page," of ");
    itoa(pages,num,10);
    strcat(page,num);
    strcat(page," ]");
    _outtext(page);

       if(cur_page > 1){
	 _settextcolor(11);
	 _settextposition(22,70);
	 _outtext(UA);
       }
       else{
	 _settextcolor(15);
	 _settextposition(22,70);
	 _outtext(LINE);
       }
       if(cur_page < pages){
	 _settextcolor(11);
	 _settextposition(22,74);
	 _outtext(DA);
       }
       else{
	 _settextcolor(15);
	 _settextposition(22,74);
	 _outtext(LINE);
       }

}

void print_q(void)
{
    _setbkcolor(9);
    _settextcolor(15);
    _settextposition(1,60);
    _outtext("[ ? Help ]");
}

void print_dv(void)
{
    if(in_dv){
     _setbkcolor(9);
     _settextcolor(15);
     _settextposition(1,36);
     _outtext("[ DESQview ]");
    }
}

void print_number(unsigned number)
{
	 char num[8];

	 ultoa((long)number,num,10);
	 _outtext(num);
}

unsigned input_number(int row,int col)
{
	char numstring[20];
	int key;
	char c;
	int i=0;
	int number=0;

	while((key=get_key()) != CR && key != ESC && i < 6)
	{
	 if(key >= '0' && key <= '9'){
	   c=(char)(key);
	   numstring[i]=key;
	   _outmem(&c,1);
	   i++;
	 }
	 if(key == LFAR){
	   i--;
	   if(i<0)i=0;
	   _settextposition(row,col+i);
	 }
	 if(key == BS){
	   i--;
	   if(i<0)i=0;
	   _settextposition(row,col+i);
	   _outmem(" ",1);
	   _settextposition(row,col+i);
	 }
	}
	numstring[i]=0;
	number=(unsigned)atol(numstring);
	if(key == ESC)number=0;
	return(number);
}

int get_key(void)
{
	int key=0;
	int me=0;
	int scancode=0;

	while(!(me || key)){
	give_cpu();
	me=mouse_event();
	key=_bios_keybrd(_KEYBRD_READY );
	}
	if(key){
	 key = _bios_keybrd(_KEYBRD_READ );
	 scancode=((key & 0xff00) >> 8);
	 key=(key & 0x00ff);
	 if(key==0)key=scancode+256;
	}
	if(me)return(me);
	else return(key);
}

void _far error_handler(unsigned deverror, unsigned errcode, unsigned _far *devhdr)
{
	int *screen;
	int x1=8,x2=14;
	int y1=25,y2=50;
	int attr=15;
	int box_type=1;
	int key=0;
	long oldbgd;
	short oldfgd;
	short oldx1, oldy1, oldx2, oldy2;
	struct rccoord oldpos;

    disk_errors++;

    if(disk_errors > 3){

	oldpos=_gettextposition();
	oldfgd = _gettextcolor();
	oldbgd = _getbkcolor();
	screen=save_screen(x1, y1, x2, y2);
	_settextcolor(12);
	_setbkcolor(9);
	_gettextwindow(&oldx1,&oldy1,&oldx2,&oldy2);
	_settextwindow(1,1,25,80);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_settextposition(1,2);
	_outtext(errors[errcode]);
	_settextposition(3,1);
	_outtext(" (I)gnore the error\n");
	_outtext(" (R)etry the operation\n");
	_outtext(" (A)bort the program");

	key=get_key();

	restore_screen(screen, x1, y1, x2, y2);
	_settextcolor(oldfgd);
	_setbkcolor(oldbgd);
	_settextwindow(oldx1,oldy1,oldx2,oldy2);
	_settextposition(oldpos.row, oldpos.col);

	switch (key){
	   case 'I':
	   case 'i':
	     _hardresume(_HARDERR_IGNORE);
	     break;
	   case 'R':
	   case 'r':
	     _hardresume(_HARDERR_RETRY);
	     break;
	   case 'A':
	   case 'a':
	     _hardresume(_HARDERR_ABORT);
	     break;
	   default:
	     _hardresume(_HARDERR_RETRY);
	     break;
	   }
    }
    else{
      _hardresume(_HARDERR_RETRY);
    }
}

void change_drive(void)
{
	int *screen;
	int x1=8,x2=12;
	int y1=30,y2=50;
	int attr=15;
	int box_type=1;
	int key=0;
	char d;
	long oldbgd;
	short oldfgd;
	struct rccoord oldpos;
	int num_diskette=0;
	int drives=0;
	int drivenumber=3;
	int i=0;
	int cur_drive=3;
	int num_drives=0;

	if(Mouse)SetPtrVis(HIDE);
	oldpos=_gettextposition();
	oldfgd = _gettextcolor();
	oldbgd = _getbkcolor();
	screen=save_screen(x1, y1, x2, y2);
	_settextcolor(0);
	_setbkcolor(7);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_settextposition(1,2);
	_outtext("Select Drive: \n\n");
	_asm{
	  int 11h
	  test ax,1
	  jz none
	  and ax,0x00c0
	  mov cl,6
	  shr ax,cl
	  inc ax
	  mov num_diskette,ax
	none:
	again:
	 push ds
	 mov ah,1ch
	 mov dl,drivenumber
	 int 21h
	 pop ds
	 cmp al,0ffh
	 je done
	 inc drives
	 inc drivenumber
	 jmp short again
	done:
	}
	if(num_diskette > 0)_outtext(" A ");
	if(num_diskette > 1)_outtext("B ");
	for(i=0;i < drives;i++){
	 d='C'+i;
	 _outmem(&d,1);
	 _outtext(" ");
	}
	_dos_getdrive(&cur_drive);
	if(old_drive<0)old_drive=cur_drive;
	key=get_key();
	if(key >= 'a' && key <= 'z'){
	  cur_drive=key-'a'+1;
	  _dos_setdrive(cur_drive,&num_drives);
	}
	if(key >= 'A' && key <= 'Z'){
	  cur_drive=key-'A'+1;
	  _dos_setdrive(cur_drive,&num_drives);
	}
	restore_screen(screen, x1, y1, x2, y2);
	_settextcolor(oldfgd);
	_setbkcolor(oldbgd);
	_settextwindow(1,1,25,80);
	_settextposition(oldpos.row, oldpos.col);
	if(Mouse)SetPtrVis(SHOW);
}

void get_vol(void)
{
	int x1=15,x2=17;
	int y1=25,y2=45;
	int attr=15;
	int box_type=2;
	unsigned vol=0;
	int *screen;
	int ok=0;
	short row1,row2;
	short col1,col2;
	struct rccoord oldpos;

	oldpos=_gettextposition();
	_gettextwindow(&row1,&col1,&row2,&col2);
	screen=save_screen(x1, y1, x2, y2);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_outtext(" New Volume? ");
	_settextcursor(0x707);
	vol=input_number(1,18);
	_settextcursor(0x2000);
	if((vol >= MINVOLUME) && (vol <= MAXVOLUME))volume=vol;
	restore_screen(screen, x1, y1, x2, y2);
	_settextwindow(row1,col1,row2,col2);
	_settextposition(oldpos.row, oldpos.col);
}

void get_delay(void)
{
	int x1=15,x2=17;
	int y1=25,y2=45;
	int attr=15;
	int box_type=2;
	unsigned delay=0;
	int *screen;
	int ok=0;
	short row1,row2;
	short col1,col2;
	struct rccoord oldpos;

	oldpos=_gettextposition();
	_gettextwindow(&row1,&col1,&row2,&col2);
	screen=save_screen(x1, y1, x2, y2);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_outtext(" New Timer? ");
	_settextcursor(0x707);
	delay=input_number(1,18);
	_settextcursor(0x2000);
	if((delay >= 0) && (delay <= 9999))lcount=delay;
	restore_screen(screen, x1, y1, x2, y2);
	_settextwindow(row1,col1,row2,col2);
	_settextposition(oldpos.row, oldpos.col);
}

int display_exit(void)
{
	int key=0;
	int x1=15,x2=17;
	int y1=25,y2=45;
	int attr=15;
	int box_type=2;
	unsigned vol=0;
	int *screen;
	int ok=0;
	short row1,row2;
	short col1,col2;
	struct rccoord oldpos;

	oldpos=_gettextposition();
	_gettextwindow(&row1,&col1,&row2,&col2);
	screen=save_screen(x1, y1, x2, y2);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_outtext(" Exit (y/N)? ");
	key=get_key();
	if(key == 'y' || key == 'Y')key=ESC;
	else key='N';
	_settextcursor(0x707);
	_settextcursor(0x2000);
	restore_screen(screen, x1, y1, x2, y2);
	_settextwindow(row1,col1,row2,col2);
	_settextposition(oldpos.row, oldpos.col);
	return(key);
}

int mouse_event(void){

	EVENT mevent;
	int key=0;
	int x,y;
	int pre_cp=1;
	int file=0;

	pre_cp=cp;

     if(Mouse){
	while(GetMouseEvent(&mevent)){
	 x=mevent.x;
	 y=mevent.y;
	 if(mevent.fsBtn & LEFT_DOWN){
	   switch(y){
	     case 1:
	       if((x >= 60) && (x <=  69))key=63;
	       break;
	     case 3:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=1;
	       else if((x >= 24) && (x <=  35))cp=19;
	       else if((x >= 42) && (x <=  53))cp=37;
	       else if((x >= 60) && (x <=  71))cp=55;
	       else file=0;
	       break;
	     case 4:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=2;
	       else if((x >= 24) && (x <=  35))cp=20;
	       else if((x >= 42) && (x <=  53))cp=38;
	       else if((x >= 60) && (x <=  71))cp=56;
	       else file=0;
	       break;
	     case 5:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=3;
	       else if((x >= 24) && (x <=  35))cp=21;
	       else if((x >= 42) && (x <=  53))cp=39;
	       else if((x >= 60) && (x <=  71))cp=57;
	       else file=0;
	       break;
	     case 6:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=4;
	       else if((x >= 24) && (x <=  35))cp=22;
	       else if((x >= 42) && (x <=  53))cp=40;
	       else if((x >= 60) && (x <=  71))cp=58;
	       else file=0;
	       break;
	     case 7:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=5;
	       else if((x >= 24) && (x <=  35))cp=23;
	       else if((x >= 42) && (x <=  53))cp=41;
	       else if((x >= 60) && (x <=  71))cp=59;
	       else file=0;
	       break;
	     case 8:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=6;
	       else if((x >= 24) && (x <=  35))cp=24;
	       else if((x >= 42) && (x <=  53))cp=42;
	       else if((x >= 60) && (x <=  71))cp=60;
	       else file=0;
	       break;
	     case 9:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=7;
	       else if((x >= 24) && (x <=  35))cp=25;
	       else if((x >= 42) && (x <=  53))cp=43;
	       else if((x >= 60) && (x <=  71))cp=61;
	       else file=0;
	       break;
	     case 10:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=8;
	       else if((x >= 24) && (x <=  35))cp=26;
	       else if((x >= 42) && (x <=  53))cp=44;
	       else if((x >= 60) && (x <=  71))cp=62;
	       else file=0;
	       break;
	     case 11:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=9;
	       else if((x >= 24) && (x <=  35))cp=27;
	       else if((x >= 42) && (x <=  53))cp=45;
	       else if((x >= 60) && (x <=  71))cp=63;
	       else file=0;
	       break;
	     case 12:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=10;
	       else if((x >= 24) && (x <=  35))cp=28;
	       else if((x >= 42) && (x <=  53))cp=46;
	       else if((x >= 60) && (x <=  71))cp=64;
	       else file=0;
	       break;
	     case 13:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=11;
	       else if((x >= 24) && (x <=  35))cp=29;
	       else if((x >= 42) && (x <=  53))cp=47;
	       else if((x >= 60) && (x <=  71))cp=65;
	       else file=0;
	       break;
	     case 14:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=12;
	       else if((x >= 24) && (x <=  35))cp=30;
	       else if((x >= 42) && (x <=  53))cp=48;
	       else if((x >= 60) && (x <=  71))cp=66;
	       else file=0;
	       break;
	     case 15:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=13;
	       else if((x >= 24) && (x <=  35))cp=31;
	       else if((x >= 42) && (x <=  53))cp=49;
	       else if((x >= 60) && (x <=  71))cp=67;
	       else file=0;
	       break;
	     case 16:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=14;
	       else if((x >= 24) && (x <=  35))cp=32;
	       else if((x >= 42) && (x <=  53))cp=50;
	       else if((x >= 60) && (x <=  71))cp=68;
	       else file=0;
	       break;
	     case 17:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=15;
	       else if((x >= 24) && (x <=  35))cp=33;
	       else if((x >= 42) && (x <=  53))cp=51;
	       else if((x >= 60) && (x <=  71))cp=69;
	       else file=0;
	       break;
	     case 18:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=16;
	       else if((x >= 24) && (x <=  35))cp=34;
	       else if((x >= 42) && (x <=  53))cp=52;
	       else if((x >= 60) && (x <=  71))cp=70;
	       else file=0;
	       break;
	     case 19:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=17;
	       else if((x >= 24) && (x <=  35))cp=35;
	       else if((x >= 42) && (x <=  53))cp=53;
	       else if((x >= 60) && (x <=  71))cp=71;
	       else file=0;
	       break;
	     case 20:
	       file=1;
	       if((x >= 6) && (x <=  17))cp=18;
	       else if((x >= 24) && (x <=  35))cp=36;
	       else if((x >= 42) && (x <=  53))cp=54;
	       else if((x >= 60) && (x <=  71))cp=72;
	       else file=0;
	       break;
	     case 21:
	       break;
	     case 22:
	       if((x >= 74) && (x <=  76))key=PGDN;
	       else if((x >= 70) && (x <=  72))key=PGUP;
	       break;
	     case 23:
	       if((x >= 2) && (x <=  20))key=CR;
	       else if((x >= 23) && (x <=  40))key=F1;
	       else if((x >= 43) && (x <=  60))key=F2;
	       else if((x >= 63) && (x <=  79))key=F3;
	       break;
	     case 24:
	       if((x >= 2) && (x <=  20))key=F4;
	       else if((x >= 23) && (x <=  40))key=F5;
	       else if((x >= 43) && (x <=  60))key=F6;
	       else if((x >= 63) && (x <=  79))key=F7;
	       break;
	     case 25:
	       if((x >= 2) && (x <=  20))key=F8;
	       else if((x >= 23) && (x <=  40))key=F9;
	       else if((x >= 43) && (x <=  60))key=F10;
	       else if((x >= 63) && (x <=  79))key=ESC;
	       break;
	     default:
	       break;
	   }
	   if(cp>display_max){
	     cp-=1;
	     key=0;
	   }
	   else if (file){
	     show_cursor(fnp,cp);
	     old_cp=cp;
	     key=CR;
	   }
	 }
	}
      }
	return(key);
}

void give_cpu(void)
{
	if(in_dv)
	_asm{
	 MOV AX,1000H            ;Give time slice back to DESQview
	 INT 15H
	 }
	else
	_asm{
	 INT 28H                 ;MS-DOS idle handler
	 MOV AX,1680H
	 INT 2FH                 ;MS-DOS idle call
	}
}

int delete(char *fnp)
{
	int i=0;
	char file_name[13];
	char *fn;
	char key;
	int file=1;

	error=0;
	fn=fnp;
	fn+=((cur_page-1)*1152);
	i=cp-1;
	fn+=i*16 + 2;
	strcpy(file_name,fn);
	_settextposition(23,1);
	_settextcolor(14);
	_setbkcolor(9);
	  for(i=0;i<6;i++){
	    _outtext("                                       ");
	  }
	_settextposition(24,1);

	fn-=2;
	if(*fn == 'F')file=1;
	if(*fn == 'N')file=1;
	if(*fn == 'D')file=0;
	if(file){
	  printf( "Do you want to delete %s (N/y)? ",file_name);
	  key = getch();
	  if( (key == 'y') || (key == 'Y') )
	     error=remove(file_name);
	  if(error!=0){
	    _settextposition(23,1);
	    time(&p_time);
	    for(i=0;i<6;i++){
	      _outtext("                                       ");
	    }
	    _settextposition(24,1);
/*            printf("File error %u",errno); */
	    perror(fmsg);
	    time(&c_time);
	    while((c_time-p_time) < 2){
	      time(&c_time);
	    };
	  }
	}
	display_menu();
	if(cp>=display_max){
	  if(cp>=(num-((cur_page-1)*72)))cp-=1;
	  if(cp<1)cp=1;
	}
	return(error);
}

int ren_file(char *fnp)
{
	int i=0;
	char file_name[13];
	char new_file_name[13];
	char *fn;
	char key;
	int file=1;

	error=0;
	fn=fnp;
	fn+=((cur_page-1)*1152);
	i=cp-1;
	fn+=i*16 + 2;
	strcpy(file_name,fn);
	_settextposition(23,1);
	_settextcolor(14);
	_setbkcolor(9);
	  for(i=0;i<6;i++){
	    _outtext("                                       ");
	  }
	_settextposition(24,1);

	fn-=2;
	if(*fn == 'F')file=1;
	if(*fn == 'N')file=1;
	if(*fn == 'D')file=0;
	if(file){
	  printf( "Do you want to rename %s (N/y)? ",file_name);
	  key = getch();
	  _settextposition(23,1);
	  if( (key == 'y') || (key == 'Y') )
	  {
	    for(i=0;i<6;i++){
	      _outtext("                                       ");
	    }
	   _settextposition(23,1);
	   printf("\nPlease enter file name to use: ");
	   gets(new_file_name);
	   if(new_file_name != NULL){
	     strupr(new_file_name);
	     error=rename(file_name,new_file_name);
	   }
	   if(error!=0){
	     time(&p_time);
	     _settextposition(23,1);
	     for(i=0;i<6;i++){
	       _outtext("                                       ");
	     }
	     _settextposition(24,1);
/*             printf("File error %u",errno); */
	     perror(fmsg);
	     time(&c_time);
	     while((c_time-p_time) < 2){
	      time(&c_time);
	     };
	   }
	  }
	 }
	display_menu();
	return(error);
}

int copyfile(char *fnp)
{
	int key=0;
	int i=0;
	char *fn;
	char *file_buffer;
	char src_file[13];
	char dst_path[100];
	char fchar;
	int handle;
	int source_handle;
	long length=0;
	long number_read=0;
	int j,k,m;

	fn=fnp;
	fn+=((cur_page-1)*1152);
	i=cp-1;
	fn+=i*16 + 2;

	strcpy(src_file,fn);

	_settextposition(23,1);
	_settextcolor(14);
	_setbkcolor(9);
	  for(i=0;i<6;i++){
	    _outtext("                                       ");
	  }
	_settextposition(24,1);

	printf("Do you want to copy %s? (N/y)",src_file);
	key=getch();
	_settextposition(24,1);
	_outtext("                                                       ");
	_settextposition(23,1);

	switch(key)
	{
	case 'Y':
	case 'y':
	   strcpy(dst_path,get_path());
	   if(dst_path != NULL){
	     strupr(dst_path);
	     strcpy(default_path,dst_path);
	     strcat(dst_path,src_file);
	     source_handle = open( src_file, O_BINARY | O_RDONLY );
	     if(source_handle>0)length=filelength(source_handle);
	     handle = open(dst_path, O_CREAT | O_WRONLY | O_EXCL | O_BINARY,
				  S_IREAD | S_IWRITE);
	     if(handle == -1){
	     if( errno == EEXIST )
	    {
	     _settextposition(24,1);
	     _outtext("                                                       ");
	     _settextposition(24,1);

	      _outtext("File already exists. Overwrite (N/y)? " );
	      key = getch();
	      if( (key == 'y') || (key == 'Y') )
	      handle = open( dst_path, O_BINARY | O_WRONLY | O_CREAT | O_TRUNC,
				    S_IREAD | S_IWRITE );
	      printf( "\n" );
	    }
	    else{
	     _settextposition(24,1);
	     p_cerror(msg,dst_path);
	     time(&c_time);
	     return(99);
	     }
	    }
	    if( (key == 'y') || (key == 'Y') ){
	     if((file_buffer =(char *)malloc(8192)) == NULL){
	     perror(msg);
	     printf("Malloc could not allocate memory for file buffer.\n");
	     error=1;
	     }

	j=0;
	m=0;
	k=0;
	number_read=0;

	_settextposition(23,1);
	printf("\n                                                      ");

	do
	{
	  if(length - number_read > 8192) k=8192;
	   else k=length - number_read;
	  m = read(source_handle,file_buffer,k);
	  j = write(handle,file_buffer,k);
	  if(m!=j){
	    printf("File write problem.\n");
	    error=1;
	  }
	  number_read=number_read + m;
	} while((number_read < length) && m==k);
	     free(file_buffer);
	     close(handle);
	     close(source_handle);
	   }
	   break;
	}
	return(error);
	}
	return(0);
}

int get_defaults(void)
{
	int ini_handle=0;
	unsigned file_length=0;
	unsigned num_read=0;
	char *file_buffer;
	char *owner;
	char *serial;
	char *path;
	char *command;
	char *sound_path;
	char s_path[_MAX_PATH];

	     strcpy(s_path,".");
	     sound_path=getenv("SOUND");
	     if(sound_path!=NULL){
	       strcpy(s_path,sound_path);
	     }
	     strcat(s_path,"\\SBPLAY.INI");
	     ini_handle = open( s_path, O_TEXT | O_RDONLY );
	     if(ini_handle== -1)return(0);
	     else{
	       file_length=(unsigned)filelength(ini_handle);
	       if(file_length > 16384)file_length=16384;
	       file_buffer=malloc(file_length+1);
	       if(file_buffer==NULL){
		 printf("Could not allocate buffer for .ini file\n");
		 return(10);
	       }
	       num_read=read(ini_handle,file_buffer,file_length);
	       file_buffer[num_read]=0;
	       command=strstr(file_buffer,"FIX=T1");
	       if(command!=NULL){
		 fix1=speak=1;
	       }
	       command=strstr(file_buffer,"FIX=T2");
	       if(command!=NULL){
		 *(&dcount+2)=fix2=1;
	       }
	       command=strstr(file_buffer,"TIMER=\"");
	       if(command!=NULL){
		 command=get_string(command,7);
		 lcount=atoi(command);
	       }
	       command=strstr(file_buffer,"AMPLIFY=\"");
	       if(command!=NULL){
		 command=get_string(command,9);
		 if(strstr(command,"PLUS"))magnitude=1;
		 if(strstr(command,"MINUS"))magnitude=-1;
		 if(strstr(command,"NONE"))magnitude=0;
	       }
	       command=strstr(file_buffer,"VOLUME=\"");
	       if(command!=NULL){
		 command=get_string(command,8);
		 volume=atoi(command);
	       }
	       command=strstr(file_buffer,"RATE=\"");
	       if(command!=NULL){
		 command=get_string(command,6);
		 play_rate=atoi(command);
	       }
	       command=strstr(file_buffer,"TYPE=\"");
	       if(command!=NULL){
		 command=get_string(command,6);
		 if(strstr(command,"SIGNED"))default_bits=-8;
		 if(strstr(command,"UNSIGNED"))default_bits=8;
	       }
	       path=strstr(file_buffer,"DEFAULT_PATH=\"");
	       if(path!=NULL){
		 path=get_string(path,14);
		 strcpy(default_path,path);
	       }
	       serial=strstr(file_buffer,"REG_NO=\"");
	       if(serial!=NULL){
		 serial=get_string(serial,8);
		 _settextposition(18,38);
		 _outtext(serial);
		 strcpy(ser_number,serial);
	       }
	       owner=strstr(file_buffer,"OWNER=\"");
	       if(owner!=NULL){
		 reg_owner=get_string(owner,7);
		 _settextposition(16,46);
		 _outtext(reg_owner);
		 strcpy(reg_name,reg_owner);
	       }
	       free(file_buffer);
	       close(ini_handle);
	     }
}

char *get_string(char *string,int start)
{
	int i=0;
	int found=0;
	char letter;

	i=start;

	do{
	 letter=string[i];
	 if(letter=='"'){
	   found=1;
	   string[i]=0;
	 }
	 i++;
	}while(!found);

	return(string+start);
}

char *get_path(void)
{
	char fchar;
	char dst_path[_MAX_PATH];

	printf("\nPlease enter Drive:\Path to use: ");
	if(strlen(default_path) > 0){
	   printf("%s",default_path);
	   fchar=getch();
	   switch(fchar){

	   case CR:
	      strcpy(dst_path,default_path);
	      break;
	   default:
	     _settextposition(24,1);
	     _outtext("                                                       ");
	     _settextposition(23,1);
	     printf("\nPlease enter Drive:\Path to use: ");
	     gets(dst_path);
	     break;
	   }
	}
	else gets(dst_path);

	return(dst_path);
}

/* Show file information */

int show_file_info(char *fnp)
{
	int file_error=0;
	int i=0;
	char file_name[13];
	char new_file_name[13];
	char datebuf[10];
	char *fn;
	char key;
	int file=1;
	int handle=0;
	long int length=0;
	unsigned fdate,ftime;

	fn=fnp;
	fn+=((cur_page-1)*1152);
	i=cp-1;
	fn+=i*16 + 2;
	strcpy(file_name,fn);
	_settextposition(23,1);
	_settextcolor(14);
	_setbkcolor(9);
	  for(i=0;i<6;i++){
	    _outtext("                                       ");
	  }
	_settextposition(24,1);

	fn-=2;
	if(*fn == 'F')file=1;
	if(*fn == 'N')file=1;
	if(*fn == 'D')file=0;
	if(file){
	  printf( " %s ",file_name);
	  handle=open(file_name,O_RDONLY);
	  if(handle != -1){
	    length=filelength(handle);
	    printf(" %lu",length);
	    _dos_getftime( handle, &fdate, &ftime );
	    datestr( fdate, datebuf );
	    printf(" %s",datebuf);
	    close(handle);
	  }
	  time(&p_time);
	  if(file_error!=0){
	    _settextposition(23,1);
	    for(i=0;i<6;i++){
	      _outtext("                                       ");
	    }
	    _settextposition(24,1);
	    printf("File error %u",errno);
	    perror(fmsg);
	  }
	 time(&c_time);
	 while((c_time-p_time) < 2){
	   time(&c_time);
	 };
	 }
	display_menu();

	return(file_error);
}

/* Takes unsigned date in the format:               fedcba9876543210
 * d=1-31, m=1-12, y=0-119 (1980-2099)              yyyyyyymmmmddddd
 * Changes to a 9-byte string:                      mm/dd/yy
 */
char *datestr( unsigned d, char *buf )
{
    sprintf( buf, "%2.2d/%02.2d/%02.2d",
	     (d >> 5) & 0x0f, d & 0x1f, (d >> 9) + 80 );
    return buf;
}

int find_dv(void)
{
    int dv=0;
    _asm{
      push bx
      push cx
      push dx
      mov cx,04445h
      mov dx,05351h
      mov ax,2b01h
      int 21h
      cmp al,0ffh
      je no_desqview
      mov ax,bx
      jmp dvgv_x
no_desqview:
      sub ax,ax
dvgv_x:
      mov dv,ax
      pop dx
      pop cx
      pop bx
     }
     return(dv);
}

void reg_SBPlay(void)
{
	char key;
	char input[80];
	int x1=15,x2=17;
	int y1=15,y2=50;
	int attr=15;
	int box_type=2;
	int *screen;
	int ok=0;
	long int password=0x20b230aa;
	long int *pw;
	long int pwn;
	char user_pw[5];
	short row1,row2;
	short col1,col2;
	struct rccoord oldpos;

	user_pw[4]=0;
	oldpos=_gettextposition();
	_gettextwindow(&row1,&col1,&row2,&col2);
	screen=save_screen(x1, y1, x2, y2);
	draw_box(box_type, x1, y1, x2, y2, attr);
	_settextwindow(x1+1,y1+1,x2-1,y2-1);
	_settextcursor(0x707);
	_outtext(" Register (y/N)? ");
	key=getche();
	if(key=='Y' | key=='y'){
	   _outtext("\nPassword? ");
	   gets(input);
	   strncpy(user_pw,input,4);
	   pw=(long *)user_pw;
	   pwn=*(pw)/2;
	   if(password==pwn){
	     _outtext("\nName? ");
	     gets(input);
	     if(strlen(input)<40)strcpy(reg_name,input);
	     _outtext("\nRegistration Number? ");
	     gets(input);
	     _outtext("\n");
	     if(strlen(input)<10)strcpy(ser_number,input);
	     save_defaults();
	   }
	   else {
	     _outtext("\nIncorrect Password!");
	     time(&p_time);
	     time(&c_time);
	     while((c_time-p_time) < 2){
	       time(&c_time);
	     };

	   }
	}
	_settextcursor(0x2000);
	restore_screen(screen, x1, y1, x2, y2);
	_settextwindow(row1,col1,row2,col2);
	_settextposition(oldpos.row, oldpos.col);
}


