#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include "allegro.h"
#include "bcd.h"
#include <jgmod.h>
#include <libamp.h>
#include "audlib.h"
#include "main.h"





file_info f_i;



music_handle m_h;


int init_Sound()
{
   reserve_voices (-32, -1);
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, "") != 0) {
      textprintf(screen, font, 10,10,makecol(255,0,0),"Error initialising sound system%s", allegro_error);
      allegro_exit();
      return 1;
   }


   install_mod(2);


   if (bcd_open() == 0) return 1;
   install_amp();

return 0;
};


void destroy_file()
{
   stop_file();
//   if (m_h.s) destroy_sample(m_h.s);
   if (m_h.j) destroy_mod(m_h.j);
   if (m_h.m) destroy_midi(m_h.m);
//   m_h.s = 0;
   m_h.j = 0;
   m_h.m = 0;
   m_h.cd = 0;
   
}

/// only for mp3

int tag_avaiable = 1;         // if a id3 tag is included into the mp3 file
char temp_buffer[129];
char titel[31];
char artist[31];
char album[31];
char year[5];
char comment[30];
char track = 0;
char genre = 0;


const char *GenreStr[]={
"Blues","Classic Rock","Country","Dance","Disco","Funk","Grunge","Hip-Hop", // 0-7
"Jazz","Metal","New Age","Oldies","Other","Pop","R&B","Rap","Reggae","Rock",// 8-17
"Techno","Industrial","Alternative","Ska","Death Metal","Pranks",           // 18-23
"Soundtrack","Euro-Techno","Ambient","Trip-Hop","Vocal","Jazz+Funk",        // 24-29
"Fusion","Trance","Classical","Instrumental","Acid","House","Game",         // 30-36
"Sound Clip","Gospel","Noise","Alt. Rock","Bass","Soul","Punk","Space",     // 37-44
"Meditative","Instrumental Pop","Instrumental Rock","Ethnic","Gothic",      // 45-49
"Darkwave","Techno-Industrial","Electronic","Pop-Folk","Eurodance","Dream", // 50-55
"Southern Rock","Comedy","Cult","Gangsta Rap","Top 40","Christian Rap",     // 56-61
"Pop/Funk","Jungle","Native American","Cabaret","New Wave","Psychedelic",   // 62-67
"Rave","Showtunes","Trailer","Lo-Fi","Tribal","Acid Punk","Acid Jazz",      // 63-74
"Polka","Retro","Musical","Rock & Roll","Hard Rock","Folk","Folk/Rock",     // 75-81
"National Folk","Swing","Fast-Fusion","Bebob","Latin","Revival","Celtic",   // 82-88
"Bluegrass","Avantgarde","Gothic Rock","Progressive Rock",                  // 89-92
"Psychedelic Rock","Symphonic Rock","Slow Rock","Big Band","Chorus",        // 93-97
"Easy Listening","Acoustic","Humour","Speech","Chanson","Opera",            // 98-103
"Chamber Music","Sonata","Symphony","Booty Bass","Primus","Porn Groove",    // 104-109
"Satire","Slow Jam","Club","Tango","Samba","Folklore","Ballad",             // 110-116
"Power Ballad","Rhythmic Soul","Freestyle","Duet","Punk Rock","Drum Solo",  // 117-122
"Acapella","Euro-House","Dance Hall","Goa","Drum & Bass","Club-House",      // 123-128
"Hardcore","Terror","Indie","BritPop","Negerpunk","Polsk punk","Beat",      // 129-135
"Christian Gangsta Rap","Heavy Metal","Black Metal","Crossover",            // 136-139
"Contemporary Christian","Christian Rock",                                   // 140-141
""
};



// id3 tag
void  load_id3_tag()
{
    FILE *id3_file = fopen(m_h.file, "r");
    char tag[4];

    if (! id3_file)
       {
       printf("Cannot read id3 tag\n");
       return;
       }


    fseek(id3_file,-128, SEEK_END);
    fread(temp_buffer, sizeof(char), 128, id3_file);

    strncpy(tag, temp_buffer, 3);
    if (strcmp("TAG", tag))
       {
       tag_avaiable = 0;
       strcpy(titel ,"");
       strcpy(artist ,"");
       strcpy(album ,"");
       strcpy(year ,"");
       strcpy(comment ,"");
       track = 0;
       genre = 0;
       
       
       }
    else
       {
       strncpy(titel, temp_buffer+3, 30);
       strncpy(artist, temp_buffer+33, 30);
       strncpy(album, temp_buffer+63, 30);
       strncpy(year, temp_buffer+93, 4);
       strncpy(comment, temp_buffer+97, 29);
       track = *(temp_buffer + 126);
       genre = *(temp_buffer + 127);
       
       }

    fclose(id3_file);

}

////////////////////////////////////////////////////


int voice_from_wav;
int voice_w;
int voice_from_wav;
   int is_wav_playing = 0;
   PACKFILE *ff;
   char buffer[25];
   int i;
   int length, len;
   int freq = 22050;
   int bits = 8;
   int channels = 1;
   signed short s;
//   SAMPLE *spl = NULL;
   AUDIOSTREAM * audio_s;
   unsigned char *a_s;
   int BUFFER_SIZE = 10000;
   int size_of_buffer;

int stopwav()
{



   if (is_wav_playing == 0) return 0;



   stop_audio_stream(audio_s);
   is_wav_playing = 0;
   pack_fclose(ff);

   return 1;

}


int poll_wav()
{
 int ii = 0;

//       if (spl) {
        if (is_wav_playing == 0) return 0;


        a_s = 0;
        a_s = get_audio_stream_buffer(audio_s);

        if (a_s == 0) return 0;

        for (ii = 0; ii < size_of_buffer; ii++)
        {

        length -= 2;

        if (length < 2)
            {
            stopwav();
            return 0;
            }

                  if (bits == 16)
           {
           s = pack_igetw(ff);
//           ((unsigned short *)a_s)[ii] = s^0x8000;
             ((unsigned char *)a_s)[ii] = (char) ((s^0x8000) & 0xFF);
             ((unsigned char *)a_s)[ii+1] = (char) ((s^0x8000) >> 8);
             ii++;



           }

           else
             {
//             ((unsigned int *)a_s)[ii] = s;
//             ((unsigned char *)a_s)[ii] = (unsigned char) (s & 0xFF);
//             ((unsigned char *)a_s)[ii+1] = (unsigned char) (s >> 8);
//             ii++;

             pack_fread((void *)a_s[ii], (long)1, ff);

             length++;
             }

        }
//          }

      free_audio_stream_buffer(audio_s);

      is_wav_playing = 1;
      return 1;


}


SAMPLE* wavplay(char * filename, int v, int p, int f)
{
   freq = 22050;
   bits = 8;
   channels = 1;

//   int lenge;
   ff = pack_fopen(filename, F_READ);
   if (!ff)
      return NULL;

   pack_fread(buffer, 12, ff);          /* check RIFF header */
   if (memcmp(buffer, "RIFF", 4) || memcmp(buffer+8, "WAVE", 4))
      return 0;

   while (!pack_feof(ff)) {
      if (pack_fread(buffer, 4, ff) != 4)
         break;

      length = pack_igetl(ff);          /* read chunk length */

      if (memcmp(buffer, "fmt ", 4) == 0) {
         i = pack_igetw(ff);            /* should be 1 for PCM data */
         length -= 2;
         if (i != 1)
            return 0;

         channels = pack_igetw(ff);     /* mono or stereo data */
         length -= 2;
         if ((channels != 1) && (channels != 2))
            return 0;

         freq = pack_igetl(ff);         /* sample frequency */
         length -= 4;

         pack_igetl(ff);                /* skip six bytes */
         pack_igetw(ff);
         length -= 6;

         bits = pack_igetw(ff);         /* 8 or 16 bit data? */
         length -= 2;
         if ((bits != 8) && (bits != 16))
            return 0;
      }
      else if (memcmp(buffer, "data", 4) == 0) {


//       len = length;

//       if (bits == 16)
//          len /= 2;
    len = length;   // Fr Information, wie lang die M. ist
    size_of_buffer = BUFFER_SIZE;

    if (channels == 2) size_of_buffer *= 2;
    if (bits == 16) size_of_buffer *= 2;
//       spl = create_sample(bits, ((channels == 2) ? TRUE : FALSE), freq, len);
    audio_s = play_audio_stream(BUFFER_SIZE, bits, ((channels == 2) ? TRUE: FALSE), freq, v, p);
//    lenge = size_of_buffer;

//       if (spl) {
//          if (bits == 8) {
//             pack_fread(spl->data, length, f);
//          }
//          else {

//    while (len > 0 && !keypressed())
//    {

        a_s = 0;
        while (!a_s)
        {
        a_s = get_audio_stream_buffer(audio_s);
        }


             for (i=0; i<size_of_buffer; i++) {


                  if (bits == 16)
           {
                       s = pack_igetw(ff);
//           ((unsigned short *)a_s)[i] = s^0x8000;
             ((unsigned char *)a_s)[i] = (char) ((s^0x8000) & 0xFF);
             ((unsigned char *)a_s)[i+1] = (char) ((s^0x8000) >> 8);
             i++;


           }

        else
           { //8 - Bit
//           ((unsigned int *)a_s)[i] = s;
//             ((unsigned char *)a_s)[i] = (unsigned char) (s & 0xFF);
//             ((unsigned char *)a_s)[i+1] = (unsigned char) (s >> 8);
//             i++;

            pack_fread(a_s[i], (long)1, ff);

            length++;
           }

        length -= 2;
//        lenge--;
//
        }
           is_wav_playing = 1;
           free_audio_stream_buffer(audio_s);
//           lenge = 0;

//      }
//   pack_fclose(ff);
//   exit(1);

           return 0;



         }
      }


   return 0;

}






int init_file(char *file)
{
   destroy_file();

   f_i.pan = 127;
   f_i.vol = 255;
   f_i.freq = 1000;
   m_h.voice_from_wave = 0;

   strcpy(m_h.file, file);
   
   if (!stricmp(get_extension(file),"wav") ) //|| !stricmp(get_extension(file),"voc"))
      {
      m_h.mode = WAV;
      }
   else if (!stricmp(get_extension(file),"mod") || !stricmp(get_extension(file),"s3m") || !stricmp(get_extension(file),"xm") || !stricmp(get_extension(file),"jgm") || !stricmp(get_extension(file),"umx"))
      {
      m_h.j = load_mod(file);
      m_h.mode = MOD;
      if (m_h.j == 0) return 1;
      }
   else if (!stricmp(get_extension(file),"cd"))
      {
      m_h.cd = atoi(get_filename(file));
      m_h.mode = CD;
      
      }
   else if (!stricmp(get_extension(file),"mid"))
      {
      m_h.m = load_midi(file);
      m_h.mode = MIDI_;
      if (m_h.m == 0) return 1;
      }
   else if (!stricmp(get_extension(file),"mp3") || !stricmp(get_extension(file),"mp2"))
      {
      m_h.mode = MP3;
      load_id3_tag();
      }
   else if (!stricmp(get_extension(file),"aud"))
      {
      m_h.mode = AUD;
      }


   else return 1;


return 0;
}

int exit_Sound()
{

   destroy_file();
   bcd_close();
   unload_amp();
return 0;
}

int play_file()
{
    switch (m_h.mode )
    {

    case WAV:
    
            m_h.s = wavplay(m_h.file,f_i.vol,f_i.pan,f_i.freq);
            m_h.voice_from_wave = voice_from_wav;
         break;

    case MOD:
    
         if (m_h.j)
            {
            play_mod(m_h.j, FALSE);
            };
         break;

    case CD:
         if (m_h.cd)
            {
            bcd_play_track(m_h.cd);
            };
         break;

    case MIDI_:
    
         if (m_h.m)
            {
            play_midi(m_h.m,FALSE);
            };
         break;

    case MP3:
    
         if (load_amp(m_h.file,FALSE)== FALSE) return 1;

         break;

    case AUD:

         if (load_aud_stream(m_h.file, FALSE) == FALSE) return 1;
         break;

    default:
         return 1;
         break;

    }
         

return 0;
}

int stop_file()
{
    switch (m_h.mode )
    {
    case WAV:

        stopwav();
        break;

    case MOD:
        if (m_h.j ) {stop_mod();}
        break;

    case CD:
        if (m_h.cd) bcd_stop();

    case MIDI_:
        if (m_h.m ) {stop_midi();}
        break;

    case MP3:
        unload_amp();
        break;

    case AUD:

        unload_aud_stream();
        break;
        
    default:
        break;
    
    };
   return 0;
}


int set_all_volume(int vol)
{
    f_i.vol = vol;
    set_volume(vol,vol);
    if (is_wav_playing) voice_set_volume(audio_s->voice, 255);
    bcd_set_volume(vol);
//    set_aud_volume(vol);
    return 0;
}

int wav_is_playing()
{

    if (is_wav_playing == 1)
    return 1;
    
    return 0;
};


int is_playing_ticker()
{
    switch (m_h.mode )
    {
    case WAV:

        poll_wav();
        if (wav_is_playing()) return 1;
        break;

    case MOD:
        if (m_h.j ) if (is_mod_playing()) return 1;
        break;

    case CD:
        if (m_h.cd) if (bcd_now_playing()) return 1;
        break;

    case MIDI_:
