	page	66,80
	TITLE	SA! 1.4 Set screen attributes
Comment 
	by Roedy Green
	works with MASM 5.0 and Optasm

  USAGE:

Colour examples:
****************

  SA! Bright white on blue background with green border
  SA! Bold Red on Black background
  SA! Blinking Yellow on Green background
  SA! Green Foreground on Red Background with Cyan Border

Choices for intensity
     Bright	Bold	 Blinking

Choices for foreground and background colours
     White     Black	 Red	 Magenta  Gray	Violet
     Blue      Green	 Cyan	 Yellow   Brown

Monochrome examples:
********************

  SA! Reverse

    Choices  for monochrome
    Normal  Reverse  Underline	Inverse
    Black on White
    White on Black

All words may by abbreviated so long as the abbreviations are
not ambiguous.	e.g.

 SA! Bo Blu F On Gre Wi Gra Bac

Ideas for future versions
*************************

Have a CLEAR and NOCLEAR option so SA! will not necessarily
clear the screen.

Allow manual override of the rows and colums for cards that do
not store this info in the BIOS region.  e.g.  SA!  red on white
25 rows by 80 columns.	In the meantime you could just patch the
routine CalcDimensions and reassemble.

Version 1.4 1996 October 25
- embed POB 707 Quathiaski Cove address

Register Conventions
********************

Subroutines may trash all registers except those explicity
documented as input or output.

 ; end of comment

;==============================================================


BIOSDATA    segment AT 40h	; dummy segment in low RAM
		org	4Ah
BIOSNumCols	db	?	; Cols per screen
		org	84h
BIOSLastRow	db	?	; Lines per screen - 1
BIOSDATA	ends

stack	segment stack		; keep MS link happy by providing null stack
stack	ends

CODE	SEGMENT PARA		; start off in code.

;==============================================================

data	segment byte		; provide a separate DATA segment
				; actually all come after the code
;==============================================================
;  V A R I A B L E S

;		indent a little to make 40-col wrap easier to read
BannerMsg	label	byte
	DB	'  SA! 1.4 ۲',13d,10d
	DB	13d,10d
	DB	' Screen Attribute utility',13,10
	DB	' Copyright (c) 1990,1993 Roedy Green Canadian Mind Products',13,10
	DB	'POB 707 Quathiaski Cove, Quadra Island, BC Canada V0P 1N0',13,10
	DB	'Telephone: (250) 285-2954          Internet:roedy@bix.com',13,10
	DB	' May be freely distributed and used for any purpose except military.',13,10,13,10,'$'

ModeError	db ' SA! cannot handle the current video mode',13,10,'$'

ColourUsage	db ' For colour or grayscale screens try:',13,10
		db ' SA! bright White foreground on Cyan background with bold Green border',13,10
		db ' SA! blinking Yellow on Red with blue',13,10
		db ' SA! y on blac',13,10
		db ' You may abbreviate colour choices as shown in caps:',13,10
		db '   BLAck BLUe BROwn Cyan GRAy GREen Red Magenta Violet Yellow WHite',13,10
		db '   BOLd BRIght BLInking Red Foreground',13,10
		db '   ON BLAck BACkground',13,10
		db '   WIth BOLd BRIght GREeen BORder',13,10,'$'

MonoUsage	db ' For monochrome screens try:',13,10
		db ' SA! Normal',13,10
		db ' SA! BLInking',13,10
		db ' SA! Inverse',13,10
		db ' SA! REVerse',13,10
		db ' SA! Underline',13,10
		db ' SA! BLInking REVerse',13,10
		db ' SA! Normal BLInking Inverse REVerse Underline',13,10
		db '     You may abbreviate as shown in caps and/or combine attributes:',13,10,'$'



Next		db	0	; 0 = next colour on command line is foreground
				; 1 = next colour is background
				; 2 = next colour is border

BoldOn		equ	8
BoldOff 	equ	0

BoldBorder	db	BoldOff
BoldBackground	db	BoldOff ; ignored in this version
BoldForeGround	db	BoldOff

BlinkOn 	equ	080h
BlinkOff	equ	0

Blink		db	BlinkOff	; blink applies to foreground only
					; no matter where the word occurs in
					; command line

; The following two apply mainly to monochrome

UnderlineOn	equ	1
UnderlineOff	equ	0

Underline	db	UnderlineOff

ReverseOn	equ	070h
ReverseOff	equ	07h

Reverse 	db	ReverseOff

; intense background colours not avail when blinking is enabled.
; Usually DOS uses blink mode instead of extra background colours mode.
; plain        with intensity
; 0 = black    8 = gray
; 1 = blue     9 = bright blue
; 2 = green   10 = bright green
; 3 = cyan    11 = bright cyan
; 4 = red     12 = bright red
; 5 = violet  13 = bright violet
; 6 = brown   14 = yellow
; 7 = white   15 = bright white

black	equ	0
blue	equ	1
green	equ	2
cyan	equ	3
red	equ	4
violet	equ	5
brown	equ	6
white	equ	7
yellow	equ	14	; has built in bold bit
gray	equ	8	; has built in bold bit
default equ	-1

Foreground	db	default ; bold bit stripped

Background	db	default ; bold bit stripped

Border		db	default

; Codes for what various words on command line do
; Abbreviations allowed on the command line, and routines to handle them

AbbrItemLen	equ	7	; length of one table item
AbbrColour	equ	4	; offset in item of colour code
AbbrRoutine	equ	5	; offset in item of the handling routine

AbbrTab 	Label	Byte
;			0	1	4	5
;			len,	string, colour, address of routine to handle
;			len is number of chars that need to match
;			colour is numeric code for this colour
;			address in addr of routine to call when this word seen

;BACKGROUND
		DB	2,	"BAC",	default 	; noise word
		dw	offset Com:HandleDummy

;BLACK
		DB	3,	"BLA",	black
		dw	offset Com:HandleColour 	; specify a colour

;BLINKING
		DB	3,	"BLI",	default
		dw	offset Com:HandleBlink		; turn on blink

;BLUE
		DB	3,	"BLU",	blue
		dw	offset Com:HandleColour 	; specify a colour

;BOLD
		DB	3,	"BOL",	default
		dw	offset Com:HandleBold		; turn on intensity

;BORDER
		DB	3,	"BOR",	default
		dw	offset Com:HandleBorder 	; next colour is for border

;BRIGHT
		DB	3,	"BRI",	default
		dw	offset Com:HandleBold		; turn on intensity

;BROWN
		DB	3,	"BRO",	brown
		dw	offset Com:HandleColour 	; specify a colour

;CYAN
		DB	1,	"CYA",	cyan
		dw	offset Com:HandleColour 	; specify a colour

;FOREGROUND
		DB	1,	"FOR",	default 	; noise word
		dw	offset Com:HandleDummy

;GRAY
		DB	3,	"GRA",	gray
		dw	offset Com:HandleColour 	; specify a colour

;GREEN
		DB	3,	"GRE",	green
		dw	offset Com:HandleColour 	; specify a colour

;INVERSE
		DB	1,	"INV",	default
		dw	offset Com:HandleReverse	; turn on reverse

;MAGENTA
		DB	1,	"MAG",	violet
		dw	offset Com:HandleColour 	; specify a colour

;NORMAL
		DB	1,	"NOR",	default
		dw	offset Com:HandleNormal 	; turn on normal attributes

;ON
		DB	1,	"ON ",	default
		dw	offset Com:HandleBackGround	; next colour is for background

;RED
		DB	3,	"RED",	red
		dw	offset Com:HandleColour 	; specify a colour

;REVERSE
		DB	3,	"REV",	default
		dw	offset Com:HandleReverse	; turn on reverse

;UNDERLINE
		DB	1,	"UND",	default
		dw	offset Com:HandleUnderline	; turn on underline

;VIOLET
		DB	1,	"VIO",	violet
		dw	offset Com:HandleColour 	; specify a colour

;YELLOW
		DB	1,	"YEL", yellow
		dw	offset Com:HandleColour 	; specify a colour

;WHITE
		DB	2,	"WHI",	white
		dw	offset Com:HandleColour 	; specify a colour

;WITH
		DB	2,	"WIT",	default
		dw	offset Com:HandleBorder 	; next colour is for border

EndAbbrTab	Label	Byte

LastRow 	DB	24	; # of rows in entire screen display less 1

LastCol 	DB	79	; # of columns in entire screen display less 1

data		ends

com	group	code,data	; force data segment to go at the end!

	ASSUME	CS:com,DS:com,ES:com,SS:com
				; seg regs cover everything
	ORG	100H		; in Code segment

;==========================
Start	proc	far
;	M A I N L I N E   R O U T I N E
	Call	Parse		; parse the command line
				; get numeric equivalents of colours needed

	Call	Cleverness	; fix up any unspecified or silly colour requests

	Call	ClearScreen	; clear background/foreground/border to desired colour

	mov	ax,4c00h
	int	21h		;normal termination

;===============================================================

Trouble proc	near
	lea	dx,BannerMsg	; display the banner
	Call	Say
	mov	ah,0fh		; get current video mode
	int	10h
				; al has mode 0,2=gray 1,3=colour 7=mono
	cmp	al,7
	ja	ModeTrouble
	mov	ah,0
	mov	si,ax
	shl	si,1		; convert to offset in bytes
	mov	dx,TroubleTab[si]
SayUsage:
	Call	Say		; display the usage message
abort:
				; error exit
	mov  ax, 4c04h		; ERRORLEVEL = 4
	int	21h		; DIE

ModeTrouble:
	lea	dx,ModeError
	jmp	SayUsage

;	addresses of error messages to use for each mode.
TroubleTab	Label	Word
	dw	offset	com:ColourUsage ; 0 gray treat as per colour
	dw	offset	com:ColourUsage ; 1 colour 40
	dw	offset	com:ColourUsage ; 2 gray treat as per colour
	dw	offset	com:ColourUsage ; 3 colour
	dw	offset	com:ModeError	; 4 illegal
	dw	offset	com:ModeError	; 5 illegal
	dw	offset	com:ModeError	; 6 illegal
	dw	offset	com:MonoUsage	; 7 mono

Trouble endp
;===============================================================

ClearScreen	Proc
;	Clear the screen to blanks with appropriate attribute
	mov	ah,0fh		; get current video mode
	int	10h
				; al has mode 0,2=gray 1,3=colour 7=mono
	cmp	al,7
	ja	IsBad
	mov	ah,0
	mov	si,ax
	shl	si,1		; convert word offset to byte offset
	jmp	Cleartab[si]	; will go to IsColour, IsMono or IsBad

; Where to go depending on mode
ClearTab	Label	Word
	dw	offset	com:IsColour	; 0 gray treat as per colour
	dw	offset	com:IsColour	; 1 colour 40
	dw	offset	com:IsColour	; 2 gray treat as per colour
	dw	offset	com:IsColour	; 3 colour
	dw	offset	com:IsBad	; 4 illegal
	dw	offset	com:IsBad	; 5 illegal
	dw	offset	com:IsBad	; 6 illegal
	dw	offset	com:IsMono	; 7 mono

IsColour:
	Call	SetBorder	; set border to desired colour
	Call	ClearToColour	; clear background/foreground to desired gray colour
	ret
IsMono:
;	Leave border alone
	Call	ClearToMono	; clear mono to desired attribute
	ret
IsBad:
;	no such mode
	jmp	Trouble

ClearScreen	EndP

;===============================================================

SetBorder	Proc	Near
;	set border to defined colour
	mov	bl,border
	or	bl,BoldBorder	; include possible bold bit
	mov	bh,0
	mov	ah,0bh
	int	010h
	ret
SetBorder	EndP

;===============================================================

ClearToColour	Proc	Near
;	erase screen to spaces with desired foreground + background colour

	Call	MollifyColourANSI	; make ANSI.SYS keep our attribs

	mov	bh,background		; background colour
	and	bh,07h			; mask off background intensity/blink bit if any
					; We cannot use the BoldBackground bit
	shl	bh,1			; shift background to high nibble
	shl	bh,1
	shl	bh,1
	shl	bh,1
	or	bh,blink		; turn on possible blink bit
	or	bh,foreground		; foreground + background
	or	bh,BoldForeGround	; turn on possible foreground intensity

	Call	ClearWindow		; bh is the attribute
	Call	CursorToHome
	ret
ClearToColour	EndP

;===============================================================

ClearToMono	Proc	Near

;	Clear monochrome screen

	Call	MollifyMonoANSI 	; make ANSI.SYS keep our attribs
					; after we erase
;	erase screen to spaces with desired attribute
	mov	bh,blink		; turn on possible blink bit
	or	bh,reverse		; build in bits for inverse video
	or	bh,BoldForeGround	; turn on possible foreground intensity
	test	underline,UnderlineOn
	jz	NoUnderline
	or	bh,1		; insert underline bits into attribute
	and	bh,089h
NoUnderline:
;	use BIOS to clear a window comprising the whole screen
	Call	ClearWindow		; bh is the attribute
	Call	CursorToHome
	ret
ClearToMono	EndP

;===============================================================

ClearWindow	proc	near
;	use BIOS to clear a window comprising the whole screen
;	on entry bh contains attribute to use
	Call	CalcDimensions	; calc # rows & cols on screen
	mov	al,0		; whole screen
	mov	cx,0		; upper left = 0,0
	mov	dh,LastRow	; lower right row
	mov	dl,LastCol	; lower right col
	mov	ah,06		; scroll up to clear screen
	int	010h
	ret
ClearWindow	EndP

;===============================================================

MollifyColourANSI	Proc	Near

;	Send command to ANSI.SYS to that it will keep our colours
;	reasonably well when it paints text later.
;	If ANSI.SYS not present, no harm, chars will be erased.

Data		Segment
ANSILead	db	27,'[0','$'	; nothing special, clear earlier attrs.
ANSITrail	db	'm','$' 	; wind up ANSI string
ANSIBold	db	';1','$'
ANSIUnderline	db	';4','$'
ANSIBlink	db	';5','$'
ANSIReverse	db	';7','$'

ANSIColours	DB	';3_;4_m$'	; patched later with fore/back colours

ANSIScheme	DB	'04261537'	; 1-digit codes for ANSI colours
					; black, blue etc

;	IBM colour scheme blue=1 green=2 red=4
;	ANSI scheme	  blue=4 green=2 red=1
;	IBM			 ANSI
;				fg  bk
;	black  000	=>	30  40
;	blue   001	=>	34  44
;	green  010	=>	32  42
;	cyan   011	=>	36  36
;	red    100	=>	31  41
;	violet 101	=>	35  45
;	brown  110	=>	33  43	(yellow)
;	white  111	=>	37  47

Data		EndS

	lea	dx,ANSILead
	Call	Say

	Test	BoldForeGround,BoldOn
	jz	NoANSIColourBold
	lea	dx,ANSIBold
	Call	Say
NoANSIColourBold:

	sub	bh,bh
	mov	bl,ForeGround		; convert colours to ANSI digits
	mov	al,ANSIScheme[bx]	; patch into control string
	mov	ANSIColours+2,al
	mov	bl,BackGround
	mov	al,ANSIScheme[bx]
	mov	ANSIColours+5,al
	lea	dx,ANSIColours
	Call	Say			; also does the Trail string

	ret

MollifyColourANSI	EndP

;===============================================================

MollifyMonoANSI Proc	Near

;	Send command to ANSI.SYS to that it will keep our attributes
;	reasonably well when it paints text later.
;	If ANSI.SYS not present, no harm, chars will be erased.

	lea	dx,ANSILead
	Call	Say

	test	BoldForeGround,BoldOn
	jz	NoANSIBold
	lea	dx,ANSIBold
	Call	Say
NoANSIBold:

	test	Underline,UnderlineOn
	jz	NoANSIUnderline
	lea	dx,ANSIUnderline
	Call	Say
NoANSIUnderline:

	test	Blink,BlinkOn
	jz	NoANSIBlink
	lea	dx,ANSIBlink
	Call	Say
NoANSIBlink:

	test	Reverse,ReverseOn
	jz	NoANSIReverse
	lea	dx,ANSIReverse
	Call	Say
NoANSIReverse:

	lea	dx,ANSITrail
	Call	Say
	ret

MollifyMonoANSI EndP

;===============================================================

CalcDimensions	Proc	Near
;	Calculate the last row & col on the screen
	mov	ax,BIOSDATA
	push	ES
	mov	ES,ax
	assume	ES:BIOSDATA
	mov	al,BIOSLastRow	; usually 24
	cmp	al,019d 	; if < 20 lines, something is wrong
	jb	UseDefaultRow
	mov	LastRow,al
UseDefaultRow:			; leave default 25 rows

	mov	al,BIOSNumCols	; usually 80
	sub	al,1		; convert from cols to last col
	cmp	al,39d		; if < 40 cols, something is wrong
	jb	UseDefaultCol
	mov	LastCol,al
UseDefaultCol:			; leave default 80 cols

	pop	ES
	assume	ES:com
	ret
CalcDimensions	EndP
;===============================================================

CursorToHome	Proc	Near
;	move cursor to upper left corner
	mov	ah,02		; function
	mov	bh,0		; page
	mov	DX,0		; row,col
	int	010h		; video BIOS
	ret
CursorToHome	EndP

;===============================================================

Cleverness	Proc	Near
;	Check out requests for colour, and fix anything silly
;	fill in any defaults

;	handle default for foreground
	cmp	foreground,default
	jne	ForegroundSpecified
	mov	foreground,white	; make white
ForegroundSpecified:

;	handle default for background, same as border or blue
	cmp	background,default
	jne	BackgroundSpecified
	mov	al,Border
	cmp	al,default
	je	DefaultBlueBackground
	mov	background,al		; make same as Border
	jmp	BackgroundSpecified
DefaultBlueBackground:
	mov	background,blue 	; make blue
BackgroundSpecified:

;	handle default for border, same as background
	cmp	border,default
	jne	BorderSpecified
	mov	al,background		; make same as Background
	mov	border,al
BorderSpecified:

;	Disallow intense colours in the background.
;	ok for border and foreground though.  We strip here so
;	when we check for background=foreground we will see matches

	and	background,7		; mask off high bits from background
					; colour, cannot be intense.

;	Check if we have same colour for foreground and background.
;	if so change foreground colour to white or black so becomes visible.
	mov	al,foreground
	cmp	al,background
	jne	CanSee
	cmp	al,white
	je	TryBlackForeground
TryWhiteForeGround:
	mov	foreground,white
	jmp	CanSee
TryBlackForeGround:
	mov	foreground,black
CanSee:
	ret
Cleverness	EndP

;===============================================================

Parse	Proc	Near
;	parse the command line and put parms into internal format.

	call	CommandLine	; get command line, result ES:DI, len CX
	call	LineToUC	; convert to all upper case
	mov	bx,1		; start with the first parameter.

NextWord:			; loop through all words on the command line
	push	bx		; save loop counter
	push	di		; save pointer to command line
	push	cx		; save length of command line
	call	nthParm 	; look at word, result ES:SI, len CX
	jcxz	NoMoreWords
	mov	di,si		; colour or word string now in ES:DI
	call	GuessWord	; what word is it? bright, blue, on etc.
				; result is DS:SI pointer to AbbrTab
	Call	[si+AbbrRoutine]; call routine to handle that word
	pop	cx
	pop	di
	pop	bx
	inc	bx		; handle next word on the command line
	jmp	NextWord

NoMoreWords:
	pop	cx
	pop	di
	pop	bx
	cmp	bx,1		; check if found even 1 param
	jg	ParseOk
	jmp	Trouble 	; no params
ParseOk:			; had at least one command line parameter
	ret
Parse	EndP

;==============================================================

GuessWord	Proc	Near
;	on entry ES:DI points to word to guess. CX is length
;	on exit  DS:SI points to matching entry in AbbrTab
;	if no match, jumps directly to Trouble
	lea	si, AbbrTab		; point to first possibility
	mov	ah,0
CompLoop:
	push	di			; save addr, len word
	push	cx
	push	si			; save pointer to start of pattern
	lodsb				; al = len of pattern
	cmp	cx,ax
	jl	NotThisOne		; if word is too short, this isn't it.
	mov	cx,ax			; just compare the short pattern len
	repe cmpsb			; compare two strings
	je	FoundIt
NotThisOne:				; no match this entry, try next
	pop	si
	pop	cx
	pop	di
	add	si,AbbrItemLen		; point to the next pattern entry
	cmp	si,offset Com:EndAbbrTab
	jb	CompLoop
	jmp	Trouble 		; none matched
FoundIt:
	pop	si			; entry in table that matched
	pop	cx
	pop	di
	ret
GuessWord	Endp

;==============================================================

HandleDummy	Proc	Near
;	dummy routine to handle noise words that are ignored
	ret
HandleDummy	EndP

;==============================================================
HandleColour	Proc	Near
;	just got a colour word. si points to item in abbrtable
	mov	bl,[si+AbbrColour]		; get colour code
	cmp	next,1				; decide what colour refers to
	jl	HandleForegroundColour
	jg	HandleBorderColour

HandleBackgroundColour:
	test	bl,BoldOn
	jz	BackgroundNotBold
	mov	BoldBackground,BoldOn
BackgroundNotBold:
	and	bl,7
	mov	Background,bl			; mark field with appropriate type
	cmp	bl,white			; white background = reverse
	jne	HandleColourDone
	mov	reverse,ReverseOn
	jmp	HandleColourDone

HandleForegroundColour:
	test	bl,BoldOn
	jz	ForegroundNotBold
	mov	BoldForeground,BoldOn
ForegroundNotBold:
	and	bl,7
	mov	Foreground,bl
	cmp	bl,black			; black foreground = reverse
	jne	HandleColourDone
	mov	reverse,ReverseOn
	jmp	HandleColourDone

HandleBorderColour:
	test	bl,BoldOn
	jz	BorderNotBold
	mov	BoldBorder,BoldOn
BorderNotBold:
	and	bl,7
	mov	Border,bl
HandleColourDone:
	ret
HandleColour EndP

;==============================================================

HandleBlink Proc	Near
	mov	Blink,BlinkOn	; set blink bit
	ret
HandleBlink EndP

;==============================================================

HandleBold Proc Near
;	the word BOLD appeared in the command line.
;	record whether it applies to Foreground, background or Border
	cmp	next,1				; decide what Bold refers to
	jl	HandleForegroundBold
	jg	HandleBorderBold
HandleBackgroundBold:
	mov	BoldBackground,BoldOn
	jmp	HandleBoldDone
HandleForegroundBold:
	mov	BoldForeground,BoldOn
	jmp	HandleBoldDone
HandleBorderBold:
	mov	BoldBorder,BoldOn
HandleBoldDone:
	ret
HandleBold EndP

;==============================================================

HandleBorder Proc	Near
	mov	next,2			; next colour coming up is border
	ret
HandleBorder EndP

;==============================================================

HandleNormal Proc	Near
	mov	BoldForeground,BoldOff	; clear bold
	mov	BoldBackground,BoldOff	; clear bold
	mov	BoldBorder,BoldOff	; clear bold
	mov	Underline,UnderlineOff	; clear underline
	mov	reverse,ReverseOff	; clear reverse
	ret
HandleNormal EndP

;==============================================================

HandleBackground Proc	Near
	mov	next,1		; next colour coming up is background
	ret
HandleBackground EndP

;==============================================================

HandleReverse Proc	Near
	mov	reverse,ReverseOn	; set reverse
	mov	foreground,black
	mov	background,white
	ret
HandleReverse EndP

;==============================================================

HandleUnderline Proc	Near
	mov	Underline,UnderlineOn	; set underline bit
	ret
HandleUnderline EndP

;==============================================================

CommandLine Proc	Near
;	Gets command line string into ES:DI
;	Command line does not include the program name.
;	ES already set since we are a COM file
				; counted string at HEX 80
				; contains command line.
				; It has no trailing null.
	MOV	DI,81h
	XOR	CH,CH
	MOV	CL,DS:80h	; CX contains length of command
	RET
CommandLine EndP

;==============================================================

LineToUC	Proc	Near
;	convert command line to all upper case
;	on entry ES:DI points to command line, CX is len
	jcxz	LineDone
	push	di
	push	cx
LineLoop:
	mov	al,ES:[di]
	cmp	al,'a'
	jb	FineAsIs
	cmp	al,'z'
	ja	FineAsIs
	sub	al,20H		; convert a to A
	mov	ES:[di],al
FineAsIs:
	inc	di
	loop	LineLoop
	pop	cx
	pop	di
LineDone:
	ret
LineToUC	EndP

;==============================================================

NthParm Proc	Near
;	Parses string for Nth Parameter delimited by blanks
;	e.g.  "  bright blue" with BX=1 would give string "bright"
;	ES:DI - string to be parsed for parameters
;	CX - length of string
;	BX - which parm wanted 1=parm1 2=parm2 etc.
;	NthParm only finds one parm per call.
;	On exit ES:SI points to string and CX is its length.
;	If there is no parm, the length will be 0.
;	It also handles multiple leading/trailing blanks on parms.
	MOV	AL,20h		; AL = blank  -- the search char
ParmLoop:
;	Remove leading blanks on parm
	JCXZ	NullParm	; jump if null string
	REPE	SCASB		; scan ES:DI forwards till hit non blank
				; DI points just after it
				; CX is one too small, or 0 if none found
	JE	NullParm	; jump if entire string was blank
	INC	CX		; CX is length of remainder of string
	DEC	DI		; DI points to non-blank
	MOV	SI,DI		; remember start of string
;	Search for terminating blank on parm
	JCXZ	NullParm	; jump if null string
	REPNE	SCASB		; scan ES:DI forwards till hit blank
				; DI points just after it
				; CX is one too small, or 0 if none found
	JNE	NoBlank 	; jump if entire string was non blank
	INC	CX		; CX is length of remainder of string
	DEC	DI		; backup DI to point to blank at string end
NoBlank:
				; DI=addr tail end of command string,
				; CX=len tail end of command string
				; SI=addr parm just parsed
;	Major loop for each parm
	DEC	BX
	JNZ	ParmLoop	; loop once for each parm

	MOV	CX,DI
	SUB	CX,SI		; CX is length of parameter.
	RET
NullParm:			; was no nth parameter
	MOV	CX,0
	RET
NthParm EndP

;========================================

Say	Proc
;	on entry DX points to a $-terminated string to display
;	Uses DOS, so goes through ANSI.SYS
	MOV	AH,9
	Int	21h
	ret
Say	EndP


;==============================================================

Start	endp

;==========================
CODE	ends			; end of code segment
	end	Start
