// crystal.cpp
// A program to calculate spacing, angles between planes (hkl)
// and angles between zones [uvw]
// copyright May 1996, by Gordon Vrdoljak
#include <iostream.h>
#include <math.h>

double spacing(double a, double b, double c, double alpha, double beta,
		double gamma, int h, int k, int l, char system);

double planar_angle(double a, double b, double c, double alpha, double beta,
		double gamma, int h1, int k1, int l1, int h2, int k2, int l2,
		char system );
double zonal_angle(double a, double b, double c, double alpha, double beta,
		double gamma, int u1, int v1, int w1, int u2, int v2, int w2,
		char system );

main()
{
// variable declarations:
char system, query;
double a, b, c, alpha, beta, gamma, d, phi, rho;
int choice, h, k, l, h1, k1, l1;
int h2, k2, l2, u1, v1, w1, u2, v2, w2;

cout << "A program to calculate the spacing between the" << endl
		<< "crystallographic (hkl) planes, angle between planes," << endl
		<< "and the angle between zones.\n" << endl;
cout << "Is the material:\n" << "\n\t(1) Cubic\n"
		<< "\t(2) Tetragonal\n" << "\t(3) Orthorhomic\n"
		<< "\t(4) Hexagonal\n" << "\t(5) Rhombohedral\n"
		<< "\t(6) Monoclinic\n" << "\t(7) Triclinic";
cout << "\nInput number (1-7):";
cin >> system;
switch(system)
	{
	case '1':
		cout << "\nInput value for 'a' cell parameter:";
		cin >> a;
		b = a; c = a; alpha = 1.570796; beta = alpha; gamma = alpha;
		break;
	case '2':
		cout << "\nInput value for 'a' cell parameter:";
		cin >> a;
		cout << "\nInput value for 'c' cell parameter:";
		cin >> c;
		b = a; alpha = 1.570796; beta = alpha; gamma = alpha;
		break;
	case '3':
		cout << "\nInput value for 'a' cell parameter:";
		cin >> a;
		cout << "\nInput value for 'b' cell parameter:";
		cin >> b;
		cout << "\nInput value for 'c' cell parameter:";
		cin >> c;
		alpha = 1.570796; beta = alpha; gamma = alpha;
		break;
	case '4':
		cout << "\nInput value for 'a' cell parameter:";
		cin >> a;
		cout << "\nInput value for 'c' cell parameter:";
		cin >> c;
		b = a; alpha = 1.570796; beta = alpha; gamma = 2.094395;
		break;
	case '5':
		cout << "\nInput value for 'a' cell parameter:";
		cin >> a;
		cout << "\nInput value for 'alpha' in degrees:";
		cin >> alpha;
		alpha = alpha * 3.141593 / 180;
		b = a; c = a; beta = alpha; gamma = alpha;
		break;
	case '6':
		cout << "\nInput value for 'a' cell parameter:";
		cin >> a;
		cout << "\nInput value for 'b' cell parameter:";
		cin >> b;
		cout << "\nInput value for 'c' cell parameter:";
		cin >> c;
		cout << "\nInput value for 'beta' in degrees:";
		cin >> beta;
		beta = beta * 3.141593 / 180;
		alpha = 1.570796; gamma = 1.570796;
		break;
	case '7':
		cout << "\nInput value for 'a' cell parameter:";
		cin >> a;
		cout << "\nInput value for 'b' cell parameter:";
		cin >> b;
		cout << "\nInput value for 'c' cell parameter:";
		cin >> c;
		cout << "\nInput value for 'alpha' in degrees:";
		cin >> alpha;
		alpha = alpha * 3.141593 / 180;
		cout << "\nInput value for 'beta' in degrees:";
		cin >> beta;
		beta = beta * 3.141593 / 180;
		cout << "\nInput value for 'gamma' in degrees:";
		cin >> gamma;
		gamma = gamma * 3.141593 / 180;
		break;
		}
cout << "\nDo you want to find:" << "\n\t (1) the inter planar spacing, d"
		<< "\n\t (2) the angle between planes (h1 k1 l1) \n\t\t and (h2 l2 k2), or"
		<< "\n\t (3) the interzonal angle between zones \n\t\t (u1 v1 w1) and"
		<< "(u2 v2 w2)"
		<< "\n\nInput (1, 2, 3): ";
cin >> choice;
switch(choice)
	{
	case 1:
		cout << "\nInput h, k, l of plane." << "\nh:";
		cin >> h; cout << "\nk:"; cin >> k; cout << "\nl:"; cin >> l;
		d = spacing(a, b, c, alpha, beta, gamma, h, k, l, system);
		cout << "\nthe d spacing is: " << d << " Angstroms\n";
		break;
	case 2:
		if (system == '5')
			cout << " Please convert to hexagonal indices and use "
				  << "the hexagonal system\n for this calculation.\n";
		else {
			cout << "\nInput h, k, l of plane 1." << "\nh1:"; cin >> h1;
			cout << "\nk1:"; cin >> k1; cout << "\nl1:"; cin >> l1;
			cout << "\nInput h, k, l of plane 2." << "\nh2:"; cin >> h2;
			cout << "\nk2:"; cin >> k2; cout << "\nl2:"; cin >> l2;
			phi = planar_angle(a, b, c, alpha, beta, gamma, h1, k1, l1, h2, k2, l2,
				system);
			cout << "\nThe angle between " << h1 << k1 << l1 << " and " << h2 << k2
				<< l2 << " is: " << phi << "radians,\n or " << 180 * phi /
				3.141592654	<< " degrees.\n";
			}
		break;
	case 3:
		if (system == '5')
			cout << " Please convert to hexagonal indices and use "
				  << "the hexagonal system\n for this calculation.\n";
		else {
			cout << "\nInput u, v, w of zone 1." << "\nu1:"; cin >> u1;
			cout << "\nv1:"; cin >> v1; cout << "\nw1:"; cin >> w1;
			cout << "\nInput u, v, w of plane 2." << "\nu2:"; cin >> u2;
			cout << "\nv2:"; cin >> v2; cout << "\nw2:"; cin >> w2;
			rho = zonal_angle(a, b, c, alpha, beta, gamma, u1, v1, w1, u2, v2, w2,
				system);
			cout << "\nThe angle between " << u1 << v1 << w1 << " and " << u2 << v2
				<< w2 << " is: " << rho << "radians,\n or " << 180 * rho / 3.141592654
				<< " degrees.\n";
		}
		break;
	}
cout << "a = " << a << ", b = " << b << ", c = " << c;
cout << "\nalpha = " << alpha << ", beta = " << beta
		<< ", gamma = " << gamma;
return 0;
}

// Function to calculate d spacing
double spacing(double a, double b, double c, double alpha, double beta,
		double gamma, int h, int k, int l, char system)
{
	double d, q;
	switch(system)
		{
		case '1':
			d = sqrt( pow (a,  2) / (h * h + k * k + l * l));
			return d;
		case '2':
			q = (h * h + k * k) / (a * a) + l * l / (c * c);
			d = sqrt( 1 / q);
			return d;
		case '3':
			q = h * h / a * a + k * k / b * b + l * l / c * c;
			d = sqrt( 1 / q);
			return d;
		case '4':
			q = 4 * (h * h + h * k + k * k) / 3 * a * a + l * l / c * c;
			d = sqrt( 1 / q);
			return d;
		case '5':
			q = (1 / a * a)*((1 + cos(alpha)) * ((h * h + k * k + l * l) -
				(1 - pow(tan (0.5 * alpha),2) ) * (h * k + k * l + l * h)) / (1 +
				cos (alpha) - 2 * pow(cos (alpha), 2)));
			d = sqrt( 1 / q);
			return d;
		case '6':
			q = (1 / a * a) * h * h / (pow(sin(beta),2)) + k * k / (b * b) +
				l * l / (c * c * pow(sin(beta), 2)) - 2 * h * l * cos (beta) /
				(a * c * pow(sin(beta), 2));
			d = sqrt( 1 / q);
			return d;
		case '7':
			q = (1 / (a * a * b * b * c * c * (1 - pow(cos(alpha), 2) -
				pow(cos(beta), 2) - pow(cos(gamma), 2) + 2 * cos(alpha) * cos(beta)
				 * cos(gamma)))) * (b * b * c * c * pow(sin(alpha), 2) * h * h
				 + a * a * c * c * pow(sin(beta), 2) * k * k + a * a * b * b *
				 pow(sin(gamma), 2) * l * l + 2 * a * b * c * c * (cos(alpha) *
				 cos(beta) - cos(gamma)) * h * k + 2 * a * a * b * c * (cos(beta)
				 * cos(gamma) - cos(alpha)) * k * l + 2 * a * b * b * c *
				 (cos(gamma) * cos(alpha) - cos(beta)) * l * h);
			d = sqrt( 1 / q);
			return d;
		}
}

// Function to calculate interplanar angles
double planar_angle(double a, double b, double c, double alpha, double beta,
	double gamma, int h1, int k1, int l1, int h2, int k2, int l2, char system )
{
double phi;
	switch(system)
		{
		case '1':
			phi = acos((h1 * h2 + k1 * k2 + l1 * l2) / sqrt((h1 * h1 + k1 * k1 +
						l1 * l1) * (h2 * h2 + k2 * k2 + l2 * l2)));
			return phi;
		case '2':

			phi = acos(((h1 * h2 + k1 * k2) / (a * a) + l1 * l2 / (c * c)) /
						sqrt((h1 * h1 + k1 * k1) / (a * a) + l1 * l1 / (c * c)) * ((
						h2 * h2 + k2 * k2) / (a * a) + l2 * l2 / (c * c)));
			return phi;
		case '3':
//			double phi;
			phi = acos((h1 * h2 / (a * a) + k1 * k2 / (b * b) + l1 * l2 / (c * c))
						/ sqrt((h1 * h1 / (a * a) + k1 * k1 / (b * b) + l1 * l1 /
						(c * c)) * (h2 * h2 / (a * a) + k2 * k2 / (b * b) + l2 * l2 /
						(c * c))));
			return phi;
		case '4':
//			double phi;
			phi = acos((h1 * h2 + k1 * k2 + 0.5 * (h1 * k2 + k1 * h2) + 0.75 * a
						* a * l1 * l2 / (c * c)) / sqrt((h1 * h1 + k1 * k1 + h1 * k1
						+ 0.75 * a * a * l1 * l1 / (c * c)) * (h2 * h2 + k2 * k2 + h2
						* k2 + 0.75 * a * a * l2 * l2 / (c * c))));
			return phi;
		case '5':
//			double phi;
			phi = 999;
			return phi;
		case '6':
//			double phi;
			phi = acos((h1 * h2 / (a * a) + k1 * k2 / (b * b) * pow(sin(beta), 2)
						+ l1 * l2 / (c * c) - (l1 * h2 + l2 * h1) * cos(beta)) / sqrt(
						(h1 * h1 / (a * a) + k1 * k1 / (b * b) * pow(sin(beta), 2) +
						l1 * l1 / (c * c) - 2 * h1 *l1 * cos(beta) / (a * c)) * (h2 *
						h2 / (a * a) + k2 * k2 / (b * b) * pow(sin(beta), 2) + l2 *
						l2 / (c * c) - 2 * h2 * l2 / (a * c) * cos(beta))));
			return phi;
		case '7':
//			double phi;
			phi = acos((h1 * h2 * b * b * c * c * pow(sin(alpha), 2) + k1 * k2 * a
						* a * c * c * pow(sin(beta), 2) + l1 * l2 * a * a * b * b *
						pow(sin(gamma), 2) +  a * b * c * c * (cos(alpha) * cos(beta)
						- cos(gamma)) * (k1 * h2 + h1 * k2) + a * b * b * c * (
						cos(gamma) * cos(alpha) - cos(beta)) * (h1 * l2 + l1 * h2) +
						a * a * b * c * (cos(beta) * cos(gamma) - cos(alpha)) * (k1 *
						l2 + l1 * k2)) / (
						sqrt(h1 * h1 * b * b * c * c * pow(sin(alpha), 2) + k1 * k1 *
						a * a * c * c * pow(sin(beta), 2) + l1 * l1 * a * a * b * b *
						pow(sin(gamma), 2) + 2 * h1 * k1 * a * b * c * c * (cos(alpha)
						* cos(beta) - cos(gamma)) + 2 * h1 * l1 * a * b * b * c * (
						cos(gamma) * cos(alpha) - cos(beta)) + 2 * k1 * l1 * a * a *
						b * c * (cos(beta) * cos(gamma) - cos(alpha))) *
						sqrt(h2 * h2 * b * b * c * c * pow(sin(alpha), 2) + k2 * k2 *
						a * a * c * c * pow(sin(beta), 2) + l2 * l2 * a * a * b * b *
						pow(sin(gamma), 2) + 2 * h2 * k2 * a * b * c * c * (cos(alpha)
						* cos(beta) - cos(gamma)) + 2 * h2 * l2 * a * b * b * c * (
						cos(gamma) * cos(alpha) - cos(beta)) + 2 * k2 * l2 * a * a *
						b * c * (cos(beta) * cos(gamma) - cos(alpha)))
						));
			return phi;
		}
}


//	  float zonal_angle(float a, float b, float c, float alpha, float beta, float gamma,
//		int u1, int v1, int w1, int u2, int v2, int w2, char system );
// Function to calculate interzonal angles
double zonal_angle(double a, double b, double c, double alpha, double beta,
		double gamma, int u1, int v1, int w1, int u2, int v2, int w2,
		char system )
{
double rho;
	switch(system)
		{
		case '1':
			rho = acos((u1 * u2 + v1 * v2 + w1 *w2) /
					sqrt((u1 * u1 + v1 * v1 + w1 * w1) * (u2 * u2 + v2 * v2 + w2 *
					w2)));
			return rho;
		case '2':
			rho = acos((a * a * (u1 * u2 + v1 * v2) + c * c * w1 * w2) /
					sqrt((a * a * (u1 * u1 + v1 * v1) + c * c * w1 * w1) *
					(a * a * (u2 * u2 + v2 * v2) + c * c * w2 * w2)));
			return rho;
		case '3':
			rho = acos((a * a * u1 * u2 + b * b * v1 * v2 + c * c * w1 * w2) /
					sqrt((a * a * u1 * u1 + b * b * v1 * v1 + c * c * w1 * w1) *
					(a * a * u2 * u2 + b * b * v2 * v2 + c * c * w2 * w2)));
			return rho;
		case '4':
			rho = acos((u1 * u2 + v1 * v2 - 0.5 * (u1 * v2 + v1 * u2) + c * c / (
					a * a) * w1 * w2) /
					sqrt((u1 * u1 + v1 * v1 - u1 * v1 + c * c / ( a * a) * w1 * w1) *
					(u2 * u2 + v2 * v2 - u2 * v2 + c * c / (a * a) * w2 * w2)));
			return rho;
		case '5':
			rho = 999;
			return rho;
		case '6':
			rho = acos((a * a * u1 * u2 + b * b * v1 * v2 + c * c * w1 * w2 + a *
					c * (w1 * u2 + u1 * w2) * cos(beta)) /
					sqrt((a * a * u1 * u1 + b * b * v1 * v1 + c * c * w1 * w1 + 2 * a
					* c * u1 * w1 * cos(beta)) *
					(a * a * u2 * u2 + b * b * v2 * v2 + c * c * w2 * w2 + 2 * a * c
					* u2 * w2 * cos(beta))));
			return rho;
		case '7':
			rho = acos((a * a * u1 * u2 + b * b * v1 * v2 + c * c * w1 * w2 + b *
					c * (v1 * w2 + w1 * v2) * cos(alpha) + a * c * (w1 * u2 + u1 *
					w2) * cos(beta) + a * b * (u1 * v2 + v1 * u2) * cos(gamma)) /
					(sqrt(a * a * u1 * u1 + b * b * v1 * v1 + c * c * w1 * w1 + 2 *
					b * c * v1 * w1 * cos(alpha) + 2 * c * a * w1 * u1 * cos(beta) +
					2 * a * b * u1 * v1 * cos(gamma)) *
					sqrt(a * a * u2 * u2 + b * b * v2 * v2 + c * c * w2 * w2 + 2 *
					b * c * v2 * w2 * cos(alpha) + 2 * c * a * w2 * u2 * cos(beta) +
					2 * a * b * u2 * v2 * cos(gamma))));
		return rho;
		}
}
