/* 			editor.h-- Workhorse Functions Required by Editor */

#ifndef __EDITOR_H
#define __EDITOR_H

#ifndef ETYP            /* If no user definition, it's void */
#define ETYP void
#endif
                /* These are the functions that are required
                 * by the editor to manipulate the screen.
                 */

void e_attention(ETYP *const p, int horiz);  /* Misc. functions. */
int  e_error    (ETYP *const p);
int  e_close    (ETYP *const p);
int  e_open     (ETYP *const p);

int  e_vncols   (ETYP *const p);        /* Viewport functions   */
int  e_vnrows   (ETYP *const p);
int  e_vcol     (ETYP *const p);
int  e_vrow     (ETYP *const p);
int  e_draw     (ETYP *const p);

int  e_cur      (ETYP *const this);     /* Line-examination     */
int  e_find_c   (ETYP *const this, int c, int forward, int incl);
int  e_first    (ETYP *const this);
int  e_isword   (ETYP *const this, int c);
int  e_last     (ETYP *const this);

int  e_closeline(ETYP *const this);     /* Window functions     */
void e_cleartoeol(ETYP *const this );
int  e_col      (ETYP *const this);
void e_del      (ETYP *const this);
int  e_gotorc   (ETYP *const this, int r, int c );
void e_ins      (ETYP *const this, int c);
int  e_maxcol   (ETYP *const this);
int  e_maxrow   (ETYP *const this);
int  e_openline (ETYP *const this, int below );
int  e_row      (ETYP *const this);
void e_replace  (ETYP *const this, int c);
int  e_update   (ETYP *const this, int enable );
int  e_vscroll  (ETYP *const this, int up, int import);

                        /* Special row arguments to e_gotorc()    */

#define E_HOME 0x8001   /* home   row (row 0 of viewport), col. 0 */
#define E_MID  0x8002   /* middle row (of viewport), column 0     */
#define E_LAST 0x8003   /* last   row (of viewport), column 0     */

#define E_LINEMAX 256   /* Maximum line length.                   */


#define E_MARKMAX ((26+1)-1)    /* Largest index into mark array */
#define E_DEFMARK    0          /* Default mark, must be zero    */
#define E_MARKNUM(c) (isalpha(c) ? tolower(c)-'a'+1 : E_DEFMARK)

#define E_BUFMAX     ((26+10)-1) /* letters + numbers + default */
#define E_BUFNUM(c)  (  isdigit(c) ? ( (c)-'0'           ):   \
                        isalpha(c) ? ( tolower(c)-'a'+10 ): 0 \
                     )

/*---------------------------------------------------------------*/
/* The editor structure, used by an editor to keep track of      */
/* local variables.                                              */
/* In a C++ class, this would be an editor class of which all    */
/* the workhorse functions would be protected virtual functions. */
/* The engine() itself would be a public staticly-bound          */
/* functions, and all other functions in engine.c would be       */
/* private member functions. engine_open() and engine_close()    */
/* are the constructor and destructor.                           */

typedef struct editor
{
}
editor;


/* These are the interface functions to the engine */

extern int      engine           (void *const p, int c);
extern int      engine_open      (void *const p);
extern int      engine_close     (void *const p);
#endif /* __EDITOR_H */
