	title	send datagram
	include	asm.inc
	include	netbios.inc

	public	main

	.stack

	.const
add_name_text	db	'Send Datagram',0

broadcast_text	db	'Broadcast '
datagram_text	db	'Datagram sent.',0

help_text	label  byte
  db  'datagram <target> <text>',13,10
  db  'Sends <text> in NetBIOS datagram to <target>.',13,10
  db  'Use * to broadcast datagram.',13,10
  db  'e.g.: datagram TEST This is a datagram to remote name TEST.',13,10
  db  'e.g.: datagram * This is a broadcast datagram.',0

driver_ertx	db	'No NetBIOS driver found',0
add_name_ertx	db	'Add Name failed',0


	.data?
	extrn	argc:word,argv:dword

add_name	db	?


	.code
	extn	startup,puts,exit_program,netbios_check,netbios_add_name
	extn	strskp_white,read_command_line,netbios_send_datagram
	extn	netbios_send_broadcast,netbios_delete_name


;;	help
;
;	entry	DS	DGROUP
;
help	proc
	lea	si,help_text
	call	puts
	jmp	exit_program
help	endp


;;	main
;
main	proc
	cmp	argc[bp],2
	jb	help			;  if no arguments

	call	netbios_check
	jc	mai5			;  if no netbios driver

	lea	si,add_name_text	; *Send Datagram*
	call	netbios_add_name
	jc	mai6			;  if add name failed
	mov	add_name[bp],al

	call	read_command_line	; find <text> in command line
	call	strskp_white
mai1:	lodsb				;  skip <target>
	cmp	al,' '
	ja	mai1

	dec	si			;  skip space between <target>&<text>
	call	strskp_white

	mov	di,si			;  ES:DI points to <text>
	mov	ax,ds
	mov	es,ax

	mov	cx,-1			; compute length of <text>
mai2:	inc	cx
	lodsb
	cmp	al,' '			;  (any control char is delimiter)
	jae	mai2			;  if delimiter

	mov	al,add_name[bp]

	lds	si,argv[bp]
	mov	si,[si+2]
	cmp	word ptr [si],'*'
	je	mai3			;  if broadcast datagram

	call	netbios_send_datagram	;  else send normal datagram
	lea	si,datagram_text
	jmp	mai4

mai3:	call	netbios_send_broadcast
	lea	si,broadcast_text

mai4:	mov	ax,@data
	mov	ds,ax
	call	puts
	lea	si,add_name_text
	call	netbios_delete_name
	jmp	exit_program

mai5:	lea	si,driver_ertx		; *No NetBIOS driver found*
	call	puts
	jmp	exit_program

mai6:	lea	si,add_name_ertx	; *Add Name failed*
	call	puts
	jmp	exit_program
main	endp

	end
