-- An ADA program to test the use of the pragma interface for
-- interfacing with Microsoft C programs

with Text_IO;   use Text_IO;

    package FIO is new Text_IO.Float_IO(Float);
    package IIO is new Text_IO.Float_IO(Float);

procedure MSCTEST is       -- MSC = Microsoft C

    i, j: integer;         -- compatible with Microsoft_C
    a, b: float;           -- Meridian is 64 bits; be careful

procedure msc_start;   -- procedure specification
    pragma INTERFACE(microsoft_C, msc_start);
                           -- This pragma takes the place of the
                           -- body for msc_start. No other code is
                           -- permitted for msc_start once it is
                           -- implemented via a pragma interface

procedure msc_end;
    pragma INTERFACE(microsoft_C, msc_end);

function cinttst1(x: integer) return integer;
    pragma INTERFACE(microsoft_C, cinttst1);

    procedure cinttst2(x, y: integer; z: out integer);
        pragma INTERFACE(microsoft_C, cinttst2);

    procedure cflttst(x: in out float; y: in out float);
        pragma INTERFACE(microsoft_C, cflttst);

    begin -- MSCTEST

       Text_IO.Put_Line("Beginning of AdaVantage/Microsoft-C ");
       Text_IO.Put_Line("Interface Example.");
       Text_IO.NEW_LINE;

       TEXT_IO.Put_Line("Calling msc_start.");
       MSC_START;

       TEXT_IO.Put_Line("Calling cinttst1 ...");

       I := cinttst1(4);

       TEXT_IO.New_Line;
       TEXT_IO.Put_Line("... result returned from cinttst1:");
       TEXT_IO.Put("  i (16) = ");
       Iio.put(I);
       TEXT_IO.New_Line(2);

       TEXT_IO.Put_Line("Calling cinttst2 ...");
       TEXT_IO.New_Line;

       I := 5;
       cinttst2(I, 11, J);

       TEXT_IO.New_Line;
       TEXT_IO.Put_Line("... result returned from cinttst2:");
       TEXT_IO.Put("  J (55) = ");
       Iio.Put(j);
       TEXT_IO.New_Line(2);

       TEXT_IO.Put_Line("Calling cflttst ...");
       TEXT_IO.New_Line;

       A := 1.23456;
       B := 9.87654;

       cflttst(A,B);

       Text_IO.New_Line;
       Text_IO.Put_Line("... results returned from cflttst:");
       Text_IO.Put("  a (8.76543) = ");
       FIO.Put(A, aft => 5, exp => 0);
       Text_IO.New_Line;
       Text_IO.Put("  b (2.34567) = ");
       FIO.Put(b, aft => 5, exp => 0);
       Text_IO.New_Line(2);

       Text_IO.Put_Line("Calling msc_end.");
       MSC_END;

       Text_IO.New_Line;
       Text_IO.Put_Line("End of Ada-C Interface Example.");

     end MSCTEST;

