#
# ORDER.AWK -- "Order is a program that renumbers the local
#               labels in assembly language procedures."
# After John Otken, "Manipulating Large Data"
#   in Programmer's Journal, March/April 1990.
#
# Bill Huber, 7/18/90: Written as a filter.  Diagnostics go to errlog
#
BEGIN {
	MARKER = "\0377"		# An ASCII string not appearing in any PROC
	errlog = "ORDER.ERR"	# Diagnostics file
}
#----------------------------------------------------------------------#

$2 ~   /^(P|p)(R|r)(O|o)(C|c)$/ &&
$1 !~  /^;/ {
	print
	print NR ":\t" $1 > errlog
	altered_proc += process_procedure($1)
	}
#----------------------------------------------------------------------#

	{
	print
	}
#----------------------------------------------------------------------#

END {
	if (altered_proc == 0) altered_proc = "No"
	if (altered_proc != 1) plural = "s"

	print > errlog
	print altered_proc " procedure" plural " resequenced.">errlog
	}
#----------------------------------------------------------------------#

function process_procedure(proc_name, local_line, resequenced) {

	#	Returns 0 if nothing is changed, 1 otherwise.
	#
	local_line  = 0
	resequenced = 0

	#
	#	Read the procedure into memory (lines[]).
	#	Create a list of three-letter labels (labels[]).
	#
	while (getline > 0 &&
		!($2 ~ /^(E|e)(N|n)(D|d)(P|p)$/ && $1 !~ /^;/ {

		lines[local_line++] = $0

		if ($1 ~ /^[A-Za-z][A-Za-z][A-Za-z][0-9][0-9]*:$/) {
			label  = substr($1, 1, index($1, ":")-1)
			prefix = substr(label, 1, 3)

			if (label in labels) {
				print NR ":\t*** Repeated local label " \
					label > errlog
			}	else {
				indexes[prefix]++
				if (indexes[prefix] != substr(label, 4))
					resequenced = 1
			}

			labels[label] = prefix indexes[prefix]
			print NR ":\t\t" label " --> " labels[label] > errlog
		}
	}

	if ($1 != procname)
		print NR ":\t\t*** EOF or ENDP before end of procedure " \
			procname > errlog
	else
		print NR ":\t\tENDP" > errlog

	#
	#	Resequence local labels from labels[] as the procedure is
	#	copied to output.  This can be speeded up considerably
	#	with some optimization.
	#	MARKER is a kludge to make the code simple.
	#
	for (i=0; i<local_line; i++) {
		for (label in labels) {
			if (match(lines[i], label)) {
				sub(label ":", MARKER labels[label] ":", lines[i])
				gsub(" " label, " " MARKER labels[label], lines[i])
				gsub("," label, "," MARKER labels[label], lines[i])
				gsub(MARKER, "", lines[i])	# Remove MARKERs
			}
		}
		print lines[i]
	}

	delete lines
	delete labels
	delete indexes

	return resequenced
} # process_procedure()
# end of ORDER.AWK #
