{ WindTest application in Turbo Pascal 4.0/5.0 by Tom Swan }

PROGRAM WindTest;


USES  Crt, WindGlob;


PROCEDURE WriteAt( x, y : Word; ch : Char );

{ Display character ch at text display location (x,y) }

BEGIN
   GotoXY( x, y );
   Write( ch )
END; { WriteAt }


PROCEDURE DrawBox( left, top, right, bottom : Word );

{ Outline a box on the text display }

VAR   i : Integer;      { FOR-loop control variable }

BEGIN
   WriteAt( left, top, #213 );
   WriteAt( right, top, #184 );
   WriteAt( left, bottom, #192 );
   WriteAt( right, bottom, #217 );
   FOR i := left+1 TO right-1 DO
   BEGIN
      WriteAt( i, top, #205 );
      WriteAt( i, bottom, #196 )
   END; { for }
   FOR i := top+1 TO bottom-1 DO
   BEGIN
      WriteAt( left, i, #179 );
      WriteAt( right, i, #179 )
   END { for }
END; { DrawBox }


PROCEDURE CenterTitle( s : String; left, top, right : Word );

{ Center string s at row = top between left and right }

VAR   k : Integer;   { Spaces to offset title from left }

BEGIN
   k := ( ( ( right - left ) + 1 ) - Length( s ) ) DIV 2;
   GotoXY( left + k, top );
   Write( s )
END; { CenterTitle }


PROCEDURE OpenWindow( left, top, right, bottom : Word; title : String );

{ Display blank window, restricting subsequent text output to within
the window's borders. }

BEGIN
   TextColor( WBForeColor );
   TextBackground( WBBackColor );
   DrawBox( left, top, right, bottom );
   CenterTitle( title, left, top, right );
   Window( left+1, top+1, right-1, bottom-1 )
END; { OpenWindow }


BEGIN
   ClrScr;
   OpenWindow( 10, 3, 50, 12, WTitle );
   TextColor( WTForeColor );
   TextBackground( WTBackColor );
   ClrScr;
   WHILE NOT Keypressed DO
   BEGIN
      Delay( 15 );  { "Slow down, you move too fast..." }
      Write( Chr( 32 + Random(144) ) )
   END; { while }
   Window( 1, 1, 80, 25 );
   GotoXY( 1, 25 )
END.
