;		arp.inc
;========================================================================

; Copyright (C) 1991-95 by Jan.Engvald@ldc.lu.se, see file COPYING.

Descriptor	struc
dLink		LinkStruc	<>		; next & prev links
; dIOCB 	iocb	<>			; pkt drvr hi perf struc
dPtrPhys	dw	0			; ptr to physical hdr
dPtrIp		dw	0			; ptr to IP hdr
dPtrUdp 	dw	0			; ptr to UDP hdr
dPktLen 	dw	0			; packet length (bytes)
dPktEnd 	dw	0			; end of packet
dTimOut2Msg	equ	dPktEnd 		; Timeout msg for findsends
dSqDelay	dw	0			; source quench delay (ms)
dWaitEvent	dw	0			; event to wait for
dPtrFrag	equ	dWaitEvent		; ptr to defargment listhead
dTimOutMsg	dw	0			; to be displayed at timeout
dTickResend	dw	1*18			; resend start interval (ticks)
dTickTimeout	dw	4*18			; timeout ticks (in 1/18 s)
dTick2Timeout	dw	14*18			; second timeout
dIdxHwDst	equ	dSqDelay		; arp table index for hw dst
dIdxIpDst	equ	dTick2Timeout		; arp table index for IP dst
dAdjust 	equ	(4-(($-dLink) and 3)) and 3
if	dAdjust
		db	dAdjust dup (0)
endif
dGwys2Chk	db	0			; # of untried gateways

D_SNAP		equ	1			; 802.3 snaps used
D_SHORT_ARP	equ	2			; use 3 s ARP timeout
dSnap		db	0
dFlags		equ	dSnap			; 

dPtrDes 	dw	0			; ptr to start of descriptor
dHwDst		equ	$-dLink 		; (part of pd packet)
Descriptor	ends
DESCRLEN	equ	SIZE Descriptor

HwStruc 	struc
hEthDst 	db	6 dup (0)		; Ethernet destination address
hEthSrc 	db	6 dup (0)		; my Ether addr
hProtType	dw	0008			; 0800 = IP
HwStruc 	ends
HWHDRLEN	equ	SIZE HwStruc

SnapStruc	struc
sDSAP		db	170
sSSAP		db	170
sContr		db	3
sOrgCode	db	0,0,0
sProt		db	08, 00
SnapStruc	ends
SNAPLEN 	equ	SIZE SnapStruc

ArpStruc	struc
iArpHtype	dw	0			; 0001 = Ether
iArpProt	dw	0008h			; 0800 = IP
iArpHlen	db	0			; Hw addr length
iArpPlen	db	4			; IP addr length
iArpOp		dw	0100h			; 0001 = request
iArpMyHwAd	db	2*MAX_ADDR_LEN+2*4 dup (0)
ArpBodyLen	=	$-iArpHtype
ArpStruc	ends

DriverClass	label	byte
Class2Htype	db	0
		db	1			; 1 Ethernet
		db	4			; 2 Pronet-10
		db	6			; 3 802.5 TR
		db	0			; 4 Omninet
		db	11			; 5 LocalTalk
		db	0			; 6 Slip
if 0
		db	1			; 7 StarLan
		db	7			; 8 Arcnet
		db	3			; 9 AX.25
endif

InSendAndW	db	0

ifndef		ARPSLOTS
ARPSLOTS	equ	12
endif

; The arp table contains information on hosts on this net.
; Slot 0, 1 and 2 (index 0, 2 and 4) are static and contain:
; this net broadcast, this subnet broadcast and my address, respectively.
;
; If we don't RECEIVE packets for more than a minute from a host or gateway,
; its slot is cleared. If we then DO receive a packet, the slot is restored
; by VerifyIpHdr without sending an ARP. On the other hand, if WE want to
; send the next packet, we will do an ARP and can thus detect dead hosts
; or gateways.
		even
ArpTabIp2	dw	2 dup (0ffffh)		; IP # (last part)
		dw	ARPSLOTS-2 dup (0)
ArpTabIp1	dw	2 dup (0ffffh)		; IP # (first part)
		dw	ARPSLOTS-2 dup (0)
ArpTabTr	dw	ARPSLOTS dup (0)	; timer
ArpTabFlags	dw	ARPSLOTS dup (0)	; flags
ArpTabTrSq	dw	ARPSLOTS dup (0)	; source quench timer
ArpTabSqDelay	dw	ARPSLOTS dup (0)	; source quench delay
ArpTabHwAdr	db	ARPSLOTS*HWLENMAX dup (0ffh) ; hardware addr (max 16 bytes)
ArpTabHwEnd	equ	$
USE_SNAP	equ	1			; bit in ArpTabFlags
SQ_UPDATED	equ	2			; bit in ArptabFlags/RouteTabFl

ARPMYIDX	equ	4
ArpPutSlot	dw	ARPMYIDX

ArpType 	dw	0608h
ArpBuf		ArpStruc	<>

ArpFixedLen	equ	$-ArpType
aArpOffsSrcIp	equ	iArpMyHwAd+2-iArpHtype
MyHwAd		equ	ArpBuf.iArpMyHwAd
IpType		equ	ArpBuf.iArpProt
ArpFixedPart	equ	ArpType

		even
DONT_WAIT	equ	1
GOT_BOOTP	equ	2
GOT_ARPREPLY	equ	4
GOT_TIMEREPLY	equ	8
GOT_ARPREQ	equ	16
GOT_ICMPMSG	equ	32
GOT_NSREPLY	equ	64
Events		dw	1			; =1 so DONT_WAIT always true

;USE_SNAP	equ	1			; also used in ARP tab
ARGZONE 	equ	2
ARGZONESPEC	equ	4
DSTNOW		equ	8
IS_A_386	equ	16
TBL_READY	equ	32
UDP_ECHO	equ	64
DBGSTOP		equ	0080h
ECHO_DISPL      equ     0100h
GOT_DSP_ROW	equ	0200h
CONT_ON_ERR	equ	0400h			; = xor STOP_ON_ERR
NO_ERR_YET	equ	0800h
NO_DROP_YET	equ	1000h
PING_DELAY	equ	2000h
PROBE_REPLY	equ	4000h
DBGINTERR	equ	8000h
GenFlags	dw	NO_DROP_YET

HOP_CHK		equ	1
UPPD_LINE	equ	2
UPPD_HSCR	equ	4
NO_AUTOSCROLL	equ	8
READING_FILE	equ	16
PING_STOPPED	equ	32
LOOP_BACK	equ	64
GOT_HOP_REPLY	equ	128
MoreFlags	dw	UPPD_HSCR+PING_STOPPED

SnapHdr 	SnapStruc	<>

ArpHandle	dw	0
MySegm		dw	0
Hlen		dw	0
H2Len		dw	0
LongerTimOut	dw	0
SavedTicksHi	dw	0
SavedTicks	dw	0
SavedTickCntr	dw	0
SavedTicksAdj	dw	0

if DEBUG
DbgIntCnt	db	1
endif ; DEBUG

TimerResolution equ	1193			; hw ticks per millisecond

;========================================================================
;		endinclude
