
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMS Interface for Borland C/C++, Version 1.1			*/
/*	Developed by Tanescu A. Horatiu					*/
/*	April 1997							*/
/*									*/
/* ---------------------------------------------------------------------*/
/*	C sources							*/
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMSXM.C								*/
/*									*/
/*	eXtended Memory Management Functions				*/
/*	(xmfreespace, xmcontig, xmalloc, xmfree, xmlock, xmunlock,	*/
/*	 xmhandleinfo, xmrealloc)					*/
/*	eXtended Memory Transfer Functions				*/
/*	(xmemcpy, _xmemcpy)						*/
/*									*/
/* ---------------------------------------------------------------------*/

#include <dos.h>
#include "xms.h"

#pragma inline

/* xmfreespace - get the amount of free extended memory
 */

unsigned int xmfreespace(void)
{
  asm	xor	bl, bl
  asm	mov	ah, 0x08
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_DX);
}

/* xmcontig - get the size of the largest free extended memory block
 */

unsigned int xmcontig(void)
{
  asm	xor	bl, bl
  asm	mov	ah, 0x08
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* xmalloc - allocate extended memory block
 */

xmhandle xmalloc(unsigned int size)
{
  asm	mov	dx, size
  asm	xor	bl, bl
  asm	mov	ah, 0x09
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  asm	or	ax, ax
  asm	je	AllocFailed
  return (_DX);
AllocFailed:
  return (_AX);
}

/* xmfree - free extended memory block
 */

int xmfree(xmhandle hxmem)
{
  asm	mov	dx, hxmem
  asm	xor	bl, bl
  asm	mov	ah, 0x0A
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

#define MAKELONG(low, high) ((unsigned long)(((unsigned int)(low)) | (((unsigned long)((unsigned int)(high))) << 16)))

/* xmlock - lock extended memory block
 */

unsigned long xmlock(xmhandle hxmem)
{
  asm	mov	dx, hxmem
  asm	xor	bl, bl
  asm	mov	ah, 0x0C
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  asm	or	ax, ax
  asm	je      LockFailed
  return (MAKELONG(_BX, _DX));
LockFailed:
  return (_AX);
}

/* xmunlock - unlock extended memory block
 */

int xmunlock(xmhandle hxmem)
{
  asm	mov	dx, hxmem
  asm	xor	bl, bl
  asm	mov	ah, 0x0D
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* xmhandleinfo - get EMB handle information
 */

int xmhandleinfo(xmhandle hxmem, unsigned int* size, unsigned char* lockcount, unsigned char* freehandles)
{
  asm	mov	dx, hxmem
  asm	xor	bl, bl
  asm	mov	ah, 0x0E
  asm	call	dword ptr [xmscontrol]
  asm	or	ax, ax
  asm	je      FlagsQueryFailed
  *lockcount = _BH;
  *freehandles = _BL;
  *size = _DX;
  asm	mov	xmserrno, 0
  return (_AX);
FlagsQueryFailed:
  asm	mov	xmserrno, bl
  return (_AX);
}

/* xmrealloc - reallocate extended memory block
 */

int xmrealloc(xmhandle hxmem, unsigned int newsize)
{
  asm	mov	bx, newsize
  asm	mov	dx, hxmem
  asm	xor	bl, bl
  asm	mov	ah, 0x0F
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* xmemcpy - copy extended memory block (generic function)
 */

int xmemcpy(xmemcpy_t *x)
{
  asm	push	es
  _SI = FP_OFF(x);
  asm	mov	ax, ds
  asm	mov	es, ax
  asm	push	ax
  _DS = FP_SEG(x);
  asm	xor	bl, bl
  asm	mov	ah, 0x0B
  asm	call	dword ptr es:[xmscontrol]
  asm	pop	ds
  asm	mov	xmserrno, bl
  asm	pop	es
  return (_AX);
}

/* _xmemcpy - copy extended memory block (generic function)
 */

int _xmemcpy(unsigned long n, xmhandle srchandle, unsigned long srcoff,
	     xmhandle desthandle, unsigned long destoff)
{
  xmemcpy_t x;
  x.xmc_count      = n;
  x.xmc_srchandle  = srchandle;
  x.xmc_srcoff     = srcoff;
  x.xmc_desthandle = desthandle;
  x.xmc_destoff    = destoff;
  asm	push	es
  _SI = FP_OFF(&x);
  asm	mov	ax, ds
  asm	mov	es, ax
  asm	push	ax
  _DS = FP_SEG(&x);
  asm	xor	bl, bl
  asm	mov	ah, 0x0B
  asm	call	dword ptr es:[xmscontrol]
  asm	pop	ds
  asm	mov	xmserrno, bl
  asm	pop	es
  return (_AX);
}