//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW IDE                       |
// |  File:        TPROJECT.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Tproject class implementation        |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdio
#define uses_string

#define uses_app
#define uses_check
#define uses_desk
#define uses_ht
#define uses_input
#define uses_stddlg
#define uses_system
#define uses_table
#define uses_txt

#include "PVUSES.H"
#include "W.H"
#include "COMPILE.H"

#define _DECLARE_TPROJECT_H
  #include "TPROJECT.H"
#undef  _DECLARE_TPROJECT_H


/*
STATIC DATA
*/
  static char prj_signature[] = "\r\nPower View IDE project file.\r\n\032";


static void free_project_entry( void *p )
{
  DELETE( ((Tproject_entry *)p)->depends );
  FREE( ( (Tproject_entry *) p)->command_line );
  FREE( ( (Tproject_entry *) p)->compiler );
}

static boolean break_make( void )
{
  Tevent ev;
  for(;;)
  {
    get_event( ev );
    if( ev.code==evNOTHING ) return 0;
    if( ev.code!=evCOMMAND )
    {
      if( ev.code==evKEY_DOWN && ev.SCAN_CODE==scESC )
      {
        while( ev.code!=evKEY_UP || ev.SCAN_CODE!=scESC ) get_event( ev );
        return 1;
      }
      continue;
    }
    modal_item->handle_event( ev );
  }
}


/*
public
*/
  Tproject::Tproject( char *_filename, int _xl, int _yl, boolean show_error ):
    Thide_on_close( _xl, _yl )
  {
    char tmp_signature[ sizeof( prj_signature ) ];
    Tproject_entry pe;
    char cmd[128];
    char comp[21];
    char buf[_MAX_PATH];
    FILE *f;
    uint i, j;
    boolean success;

    scroll_ahead = 1;
    memset( &prj_compiler_options, 0, sizeof(prj_compiler_options) );
    memset( &prj_linker_options,   0, sizeof(prj_linker_options  ) );
    data_size = TPROJECT_ENTRY_SIZE;
    lb_item_killer = free_project_entry;
    *filename = 0;
    if( *_filename == 0 ) return;
    fexpand( strcpy( filename, _filename ) );
    f = fopen( filename, "rb" );
    if( f == NULL )
    {
      if( show_error )
      {
        _terror();
        ok( "Unable to open project file \"%s\".", filename );
        goto not_valid;
      }
      return;
    }
    memset( tmp_signature, 0, sizeof( tmp_signature ) );
    fread( tmp_signature, sizeof( tmp_signature ), 1, f );
    if( memcmp( tmp_signature, prj_signature, sizeof( tmp_signature ) ) )
    {
      _terror();
      ok( "\"%s\" is not a Power View IDE project file.", filename );
      set_state( isVALID, 0 );
      fclose( f );
      return;
    }
    success = ( fread( &i, sizeof( i ), 1, f ) == 1 );
    i++;
    while( success && --i )
    {
      success = (
        ( fread( &pe,  sizeof( pe ),   1, f ) == 1 ) &&
        ( fread( cmd,  sizeof( cmd ),  1, f ) == 1 ) &&
        ( fread( comp, sizeof( comp ), 1, f ) == 1 ) &&
        ( fread( &j,   sizeof( uint ), 1, f ) == 1 )
      );
      if( !success ) break;
      pe.depends = NEW( Tlb_list );
      pe.command_line = STRDUP( cmd );
      pe.compiler = STRDUP( comp );
      j++;
      while( success && --j )
        if( success = ( fread( buf, sizeof( buf ), 1, f ) == 1 ) )
          pe.depends->add( buf );
      if( success ) add( &pe );
    }
    success = success && fread( &prj_compiler_options, sizeof(prj_compiler_options), 1, f )==1
                      && fread( &prj_linker_options,   sizeof(prj_linker_options  ), 1, f )==1;
    Tlb_list::top();
    fclose( f );
    if( !success || ferror( f ) )
    {
      _terror();
      ok( "Error reading project file \"%s\".", filename );
    not_valid:
      set_state( isVALID, 0 );
    }
  }

  void Tproject::fetch( char *buffer, uint row, uint column, uint width )
  {
    Tproject_entry *pe;

    if( row == vcurrent ) text_attr = selected_attr;
    pe = (Tproject_entry *) getptr( row );
    switch( column )
    {
      case 0:
        strcpy( buffer, pe->filename );
        min_path( buffer );
        short_path( buffer, width );
        break;
      case 1:
        target_file( buffer, pe->target );
        min_path( buffer );
        short_path( buffer, width );
        break;
    }
  }

  void Tproject::set_title( void )
  {
    if( *filename )
      Thide_on_close::set_title( filename );
    else
      Thide_on_close::set_title( "[untitled]" );
  }

  boolean Tproject::save( void )
  {
    if( *filename == 0 ) return save_as();
    return save_project();
  }

  boolean Tproject::save_as( void )
  {
    static char dir_svd[_MAX_PATH] = "";
    static uint filt_svd = 0;
    _get_file_svd( dir_svd, filt_svd );
    _new_file();
    _filters( "Project files (*.wpj)" );
    if( get_file( "Save project as", filename ) != cmOK ) return 0;
    return save_project();
  }

  boolean Tproject::save_project( void )
  {
    FILE *f;
    uint i, j;
    Tproject_entry pe;
    char cmd[128], comp[21];
    char buf[_MAX_PATH];
    boolean result;

    redraw();
    f = fopen( filename, "wb" );
    if( f == NULL ) return 0;
    result = ( fwrite( prj_signature, sizeof( prj_signature ), 1, f ) == 1 ) &&
             ( fwrite( &vcount,       sizeof( vcount ),        1, f ) == 1 );
    for( i = 0; result && ( i < vcount ); i++ )
    {
      get( i, &pe );
      pe.options &= ~peBUILD;
      strcpy( cmd, pe.command_line );
      strcpy( comp, pe.compiler );
      if( ( fwrite( &pe, sizeof( pe ), 1, f ) != 1 ) ||
          ( fwrite( cmd, sizeof( cmd ), 1, f ) != 1 ) ||
          ( fwrite( comp, sizeof( comp ), 1, f ) != 1 ) ||
          ( fwrite( &pe.depends->vcount, sizeof( uint ), 1, f ) != 1 ) ) result = 0;
      for( j = 0; result && ( j < pe.depends->vcount ); j++ )
      {
        pe.depends->gettxt( j, buf );
        if( fwrite( buf, sizeof( buf ), 1, f ) != 1 ) result = 0;
      }
    }
    if( fwrite( &prj_compiler_options, sizeof(prj_compiler_options), 1, f )!=1 ||
        fwrite( &prj_linker_options,   sizeof(prj_linker_options  ), 1, f )!=1 ) result = 0;
    return ( fclose( f ) == 0 ) && result;
  }

  void Tproject::new_project_entry( uint i, char *_filename )
  {
    char fname[_MAX_FNAME];
    Tproject_entry pe;

    fexpand( strcpy( pe.filename, _filename ) );
    _splitpath( pe.filename, NULL, NULL, fname, NULL );
    min_path( pe.filename );
    strcpy( pe.target, fname );
    strcat( pe.target, ".OBJ" );
    pe.depends = NEW( Tlb_list );
    pe.command_line = STRDUP( "" );
    pe.compiler = STRDUP( "" );
    pe.options = peAUTO_DEPENDENCY;
    ins( i, &pe );
  }

  void Tproject::add_entry( void )
  {
    ins_entry( vcount );
  }

  void Tproject::ins_entry( uint i )
  {
    char f[_MAX_PATH];
    static char dir_svd[_MAX_PATH] = "";
    static uint filt_svd = 0;
    uint gf;
    _multi_files();
    _get_file_svd( dir_svd, filt_svd );
    _filters( "C++ files (*.cpp)|C files (*.c)|Assembler files (*.asm)" );
    while( gf=get_file("Add/Insert project entry",f) )
    {
      new_project_entry( i++, f );
      if( gf==cmOK ) break;
    }
    save();
  }

  void Tproject::edit_file( uint i )
  {
    char filename[_MAX_PATH];

    message( this, cmDONE );
    _help( htW_EDITOR );
    strcpy( filename, ( (Tproject_entry *) getptr( i ) )->filename );
    ::edit_file( fexpand( filename ) );
  }

  void Tproject::del_entry( uint i )
  {
    _palert();
    if( !yn( "Delete project item?" ) ) return;
    del( i );
    save();
  }

    static Tlist_box *dep_list;
    static boolean dependency_validator( uint command )
    {
      char f[_MAX_PATH];
      static char dir_svd[_MAX_PATH] = "";
      static uint filt_svd = 0;

      switch( command )
      {
        case cmUSER00:
          _get_file_svd( dir_svd, filt_svd );
          if( get_file( "Add/Insert dependency file", f ) == cmOK )
            dep_list->add( f );
          break;
        case cmUSER01:
          _get_file_svd( dir_svd, filt_svd );
          if( get_file( "Add/Insert dependency file", f ) == cmOK )
            dep_list->ins( dep_list->vcurrent, f );
          break;
        case cmUSER02:
          dep_list->del( dep_list->vcurrent );
          break;
        default:
          return 1;
      }
      cstate( cmUSER02, dep_list->vcount );
      return 0;
    }

  void Tproject::dependency( uint i )
  {
    Tproject_entry *pe;
    char buf[_MAX_PATH];
    uint n;

    pe = (Tproject_entry *) getptr( i );
    _help( htD_DEPENDENCY );
    dialog( "Dependency list" ); validator( dependency_validator );
    n = 0;
    dep_list = list_box( "|~Dependency files", n, 30, 12 );
      dep_list->set_flags( ifSTAY, 1 );
      for( i = 0; i < pe->depends->vcount; i++ )
      {
        pe->depends->gettxt( i, buf );
        dep_list->add( buf );
      }
      dep_list->top();
    nc();
    hspace();
    kbutton( "  OK  " );
     button( " |~Add  ", cmUSER00 )->cstate( cmUSER02, dep_list->vcount );
     button( "|~Insert", cmUSER01 )->shortcut = kINS;
     button( "|~Delete", cmUSER02 )->shortcut = kDEL;
    cbutton( "Cancel" );
    hbutton( " Help " );
    if( ::run() == cmOK )
    {
      pe->depends->clear();
      for( i = 0; i < dep_list->vcount; i++ )
      {
        dep_list->gettxt( i, buf );
        pe->depends->add( buf );
      }
      save();
    }
    DELETE( dep_list );
  }

    static Tinput *export_input;
    static boolean export_validator( uint command )
    {
      if( command==cmOK )
      {
        char path[_MAX_PATH];
        export_input->get_txt( path );
        fexpand( path );
        switch( test_file_exist(path) )
        {
          case cmCANCEL:
            *path = 0;
          case cmYES:
            export_input->set_txt( path );
            return 1;
          case cmNO:
            export_input->set_txt( path );
            focus( export_input );
            return 0;
        }
      }
      return 1;
    }

  void Tproject::export( void )
  {
    char fn[_MAX_PATH] = "MAKEFILE";
    _help( htD_EXPORT_MAKEFILE ); dialog( "Export make file" );
    validator( export_validator );
    export_input = input( "File name", fn, _MAX_PATH-1, 20 );
    if( !bkch() || !*fn ) return;
    char *buffer = (char *)MALLOC( MAX_FILE_PARAMS );
    FILE *f=fopen( fn, "wt" );
    fprintf( f, "# Power View IDE makefile export\n\n# Project: %s", filename );
    fprintf( f, "\n\ncode_size = %s", compiler_options.code_size==cs32BITS? "386" : "" );
    watcom_command_line( buffer, "" );
    fprintf( f, "\n\ncompiler_options = %s", buffer );
    watcom_link_command_line( buffer );
    fprintf( f, "\n\nlinker_options =" );
    for( char *c=buffer; *c; c++ )
      if( *c!='\r' )
        fputc( *c, f );
      else
        fputs( " &\n  ", f ), c++;
    fprintf( f, "\n\nobject_files =" );
    for( uint i=0; i<vcount; i++ )
    {
      Tproject_entry *pe = (Tproject_entry *)getptr( i );
      if( pe->options&peDONT_LINK ) continue;
      fprintf( f, " &\n  %s", pe->target );
    }
    exe_file( buffer, filename );
    fprintf( f, "\n\n%s : $(object_files)\n  *wlink $(linker_options) name %s file {$(object_files)}", buffer, buffer );
    for( i=0; i<vcount; i++ )
    {
      Tproject_entry *pe = (Tproject_entry *)getptr( i );
      target_file( buffer, pe->target );
      fprintf( f, "\n\n%s : %s", buffer, pe->filename );
      if( pe->options&peAUTO_DEPENDENCY )
        fprintf( f, " .AUTODEPEND" );
      else
      {
        char buf[_MAX_PATH];
        for( uint j=0; j<pe->depends->vcount; j++ )
        {
          pe->depends->gettxt( j, buf );
          fprintf( f, " %s", buf );
        }
      }
      if( *pe->compiler==0 )
      {
        char ext[_MAX_EXT];
        _splitpath( pe->filename, NULL, NULL, NULL, ext );
        char *wph = (compiler_options.options&opPRECOMPILE)?
          "-fh=$^:$^&.PCH" : "";
        fprintf( f, "\n  %s$(code_size) %s%s%s",
          stricmp(ext,".cpp")==0? "*wpp" : "wcc",
          (pe->options&peEXCLUSIVE)? "" : "$(compiler_options) $[* ",
          (pe->options&peEXCLUSIVE)? "" : wph,
          pe->command_line );
      }
      else
      {
        for( uint j=0; j<ot_tools->vcount; j++ )
        {
          Ttools_entry *te = (Ttools_entry *) ot_tools->getptr( j );
          if( stricmp( pe->compiler, te->title )==0 )
          {
            expand_command_line( te->command_line, pe->filename, buffer );
            fprintf( f, "\n  %s %s", te->path, buffer );
            break;
          }
        }
        if( j>=ot_tools->vcount )
        {
          _terror();
          ok( "Unknown project entry translator: \"%s\".", pe->compiler );
        }
      }
    }
    FREE( buffer );
    if( ferror(f) )
    {
      _terror();
      ok( "Error writting make file %s", fn );
    }
    fclose( f );
  }

  void Tproject::local_options( uint i )
  {
    Tproject_entry *pe;
    Ttools_entry *te;
    Tcombo_box *compilers;
    char cmd[128];
    char cm[21];
    char fn[_MAX_FNAME+_MAX_EXT];
    char ext[_MAX_EXT];
    uint j, k, compiler;

    _help( htD_LOCAL_OPTIONS );
    dialog( "Local compiler options" );
    pe = (Tproject_entry *) getptr( i );
    _splitpath( pe->filename, NULL, NULL, fn, ext ); strcat( fn, ext );
    _tselected(); _tacenter();
    stext( "Project entry: \"%s\"", 37, fn );
    vspace();
    *cmd = 0;
    strcpy( cmd, pe->command_line );
    _focused();
    compiler = k = 0;
    compilers = combo_box( "|~Compiler    ", compiler, 20 );
      compilers->set_flags( ifSTAY, 1 );
      compilers->add( "Watcom C/C++" );
      for( j = 0; j < ot_tools->vcount; j++ )
      {
        te = (Ttools_entry *) ot_tools->getptr( j );
        if( te->options & teCOMPILER )
        {
          compilers->add( te->title );
          k++;
          if( stricmp( pe->compiler, te->title ) == 0 ) compiler = k;
        }
      }
      compilers->set_data( compiler );
    input( "Command |~line", cmd, 127, 21 );
    vspaces( -1 );
    ::check( "Excl|~usive", pe->options, peEXCLUSIVE );
    vspace();
    input( "|~Target file ", pe->target, _MAX_PATH-1, 21 );
    ::check( "E|~xclude from link",     pe->options, peDONT_LINK       );
    ::check( "|~Auto dependency check", pe->options, peAUTO_DEPENDENCY );
    if( bkch() )
    {
      FREE( pe->command_line );
      FREE( pe->compiler );
      pe->command_line = STRDUP( cmd );
      *cm = 0;
      if( compiler > 0 ) compilers->gettxt( compiler, cm );
      pe->compiler = STRDUP( cm );
      save();
    }
    DELETE( compilers );
  }

  boolean Tproject::entry_valid( uint i )
  {
    Tproject_entry *pe;
    char target_filespec[_MAX_PATH];
    char source_filespec[_MAX_PATH];
    uint j;
    boolean result;

    pe = (Tproject_entry *) getptr( i );
    if( pe->options & peBUILD ) return 0;
    target_file( target_filespec, pe->target );
    if( pe->options & peAUTO_DEPENDENCY )
    {
      make_status( pe->filename, target_filespec, "Auto dependency check..." );
      result = !need_make( target_filespec );
    }
    else
    {
      make_status( pe->filename, target_filespec, "Dependency check..." );
      result = target_valid( target_filespec, pe->filename );
      for( j = 0; result && ( j < pe->depends->vcount ); j++ )
      {
        pe->depends->gettxt( j, source_filespec );
        result = target_valid( target_filespec, source_filespec );
      }
    }
    return result;
  }

  boolean Tproject::exe_valid( boolean general )
  {
    uint i;
    Tproject_entry *pe;
    char exe[_MAX_PATH];
    char target_filespec[_MAX_PATH];
    boolean result;

    exe_file( exe, filename );
    result = 1;
    if( general )
      for( i = 0; result && ( i < vcount ); i++ )
        result = entry_valid( i );
    for( i = 0; result && ( i < vcount ); i++ )
    {
      pe = (Tproject_entry *) getptr( i );
      target_file( target_filespec, pe->target );
      result = target_valid( exe, target_filespec );
    }
    return result;
  }

  boolean Tproject::build_entry( uint i )
  {
    Tproject_entry *pe;
    Ttools_entry *te;
    char target_filespec[_MAX_PATH];
    char path[_MAX_PATH];
    char buf[_MAX_PATH];
    uint j;
    boolean result;

    pe = (Tproject_entry *) getptr( i );
    pe->options &= ~peBUILD;
    target_file( target_filespec, pe->target );
    if( *pe->compiler == 0 )
      result = ( exec_watcom( pe->filename ) == 0 );
    else
    {
      for( j=0; j<ot_tools->vcount; j++ )
      {
        te = (Ttools_entry *) ot_tools->getptr( j );
        if( stricmp( pe->compiler, te->title ) == 0 )
        {
          expand_command_line( te->command_line, pe->filename, path );
          sprintf( buf, "Executing %s...", te->path );
          make_status( pe->filename, target_filespec, buf );
          result = ( ::exec( te->options, te->path, path, te->trap_file ) == 0 );
          break;
        }
      }
      if( j>=ot_tools->vcount )
      {
        result = 0;
        _terror();
        ok( "Unknown project entry translator: \"%s\".", pe->compiler );
      }
    }
    return result && entry_valid( i );
  }

  boolean Tproject::make_entry( uint i )
  {
    if( !entry_valid( i ) ) return build_entry( i );
    return 1;
  }

  boolean Tproject::make( void )
  {
    uint i;
    boolean fl;

    if( memcmp(&prj_compiler_options,&compiler_options,sizeof(Tcompiler_options))!=0 )
    {
      switch( ync( "%s.\n\nDo you wish to rebuild project?",
        FIRST_MAKE?
          "It is first make" :
          "Compiler options has been changed since last make" ) )
      {
        case cmCANCEL:
          return 0;
        case cmYES:
          for( i=0; i<vcount; i++ )
            ((Tproject_entry *)getptr(i))->options |= peBUILD;
      }
      prj_compiler_options = compiler_options;
      save_project();
    }
    broadcast( cmSAVE_ALL );
    fl = 1;
    for( i=0; i<vcount && (fl=make_entry(i)); i++ )
      if( break_make() )
      {
        fl = 0;
        break;
      }
    if( fl ) fl = link( 0 );
    return fl;
  }

  boolean Tproject::build( void )
  {
    uint i;

    for( i = 0; i < vcount; i++ )
      ( (Tproject_entry *) getptr( i ) )->options |= peBUILD;
    if( memcmp(&prj_compiler_options,&compiler_options,sizeof(Tcompiler_options))!=0 )
    {
      prj_compiler_options = compiler_options;
      save_project();
    }
    return make();
  }

  boolean Tproject::link( boolean general )
  {
    boolean fl, link_fl;

    fl = 1;
    link_fl = !exe_valid( general );
    if( !link_fl && memcmp(&prj_linker_options,&linker_options,sizeof(Tlinker_options))!=0 )
    {
      switch( ync( "%s.\n\nDo you wish to relink project?",
        FIRST_LINK?
          "It is first link" :
          "Linker options has been changed since last make" ) )
      {
        case cmCANCEL:
          return 0;
        case cmYES:
          link_fl = 1;
      }
      prj_linker_options = linker_options;
      save_project();
    }
    if( link_fl ) fl = ( exec_linker(NULL)==0 );
    return fl;
  }


/*
protected
*/
  void Tproject::event_handler( Tevent &ev )
  {
    Thide_on_close::event_handler( ev );
    if( ev.code==evCOMMAND )
    {
      switch( ev.CMD_CODE )
      {
        case cmPRJ_ADD:
          add_entry();
          break;
        case cmPRJ_INS:
          ins_entry( v_current );
          break;
        case cmPRJ_DEL:
          del_entry( v_current );
          break;
        case cmPRJ_OPTIONS:
          local_options( v_current );
          break;
        case cmPRJ_DEPENDS:
          dependency( v_current );
          break;
        case cmPRJ_EDIT_FILE:
          if( state(isFOCUSED) )
          {
            edit_file( v_current );
            break;
          }
        default:
          return;
      }
      update_commands();
      handled( ev );
    }
  }

  void Tproject::update_commands( void )
  {
    cenable( cmPRJ_ADD );
    cstate( cmPRJ_INS,       v_count );
    cstate( cmPRJ_EDIT_FILE, v_count );
    cstate( cmPRJ_DEL,       v_count );
    cstate( cmPRJ_DEPENDS,   v_count );
    cstate( cmPRJ_OPTIONS,   v_count );
  }


/*
INTERFACE
*/
  void open_project( char *filename, boolean show_error )
  {
    Tproject *prj;
    Ttable *tbl;

    _help( htW_PROJECT );
    construct_table( "Project", prj = NEW( Tproject( filename, desktop_xl, desktop_yl / 3, show_error ) ) );
              tdata( "Source", 12, _MAX_PATH );
              tdata( "Target",  5, _MAX_PATH );
    _context( cxPROJECT );
    tbl = endt();
    ( (Twindow *) tbl->owner )->palette = wpTOOL;
    local_key( tbl->owner, cmOK, kENTER );
    tbl->owner->set_flags( ifTILEABLE, 0 );
    if( prj->state( isVALID ) )
    {
      project_close();
      project = prj;
    }
    insert_window( tbl->owner, 0, desktop_yl - tbl->owner->yl );
  }

  void win_project( void )
  {
    if( project != NULL )
    {
      project->set_state( isHIDDEN, 0 );
      project->owner->owner->set_state( isICONIZED, 0 );
      project->focus();
    }
  }

  void project_open( void )
  {
    char f[_MAX_PATH];
    static char dir_svd[_MAX_PATH] = "";
    static uint filt_svd = 0;
    _get_file_svd( dir_svd, filt_svd );
    _filters( "Project files (*.WPJ)" );
    if( get_file( "Open project", f ) == cmOK )
      open_project( f, 0 );
  }

  boolean project_build( void )
  //build current file/project
  {
    boolean result;
    start_of_make( "Build" );
    if( project != NULL )
      result = project->build();
    else
      result = project_compile() || link();
    end_of_make( 1 );
    return result;
  }

  boolean project_make( void )
  //make current file/project
  {
    boolean result;
    start_of_make( "Make" );
    if( project != NULL )
      result = project->make();
    else
    {
      if( current_editor == NULL ) return 1;
      if( current_editor->booleans & ebMODIFIED )
        message( (Titem *) current_editor->editor, cmSAVE );
      result = ( compile() && link() );
    }
    end_of_make( 1 );
    return result;
  }

  void project_run( void )
  //run current file/project
  {
    char buf[_MAX_PATH];
    char *fn;

    start_of_make( "Run" );
    if( project_make() )
    {
      if( editor_options.flags & efSAVE_STATUS )
      {
        if( options_changed ) options_save();
        save_status();
      }
      if( project != NULL )
      {
        if( project->exe_valid( 0 ) )
        {
          exe_file( buf, project->filename );
        exec_return:
          end_of_make( 0 );
          exec( 0, buf, program_params, "" );
          return;
        }
      }
      else
        if( current_editor != NULL )
        {
          fn = ((Tfile_editor *) current_editor->editor)->text_editor->file_name;
          exe_file( buf, fn );
          if( target_valid( buf, fn ) ) goto exec_return;
        }
    }
    end_of_make( 1 );
  }

  void project_params( void )
  //specify current file/project command line
  {
    _help( htD_PARAMS );
    dialog( "Program parameters" );
    _history( program_params );
    input( "|~Parameters", program_params, 125, 25 );
    bkch();
  }

  void project_export( void )
  {
    if( project!=NULL ) project->export();
  }

  void project_close( void )
  {
    if( project != NULL ) DELETE( project->owner->owner );
    project = NULL;
  }

  boolean project_compile( void )
  //compile current file
  {
    char *fn;
    char path[_MAX_PATH];

    if( current_editor == NULL ) return 1;
    if( current_editor->booleans & ebMODIFIED )
      message( (Titem *) current_editor->editor, cmSAVE );
    fn = ((Tfile_editor *) current_editor->editor)->text_editor->file_name;
    start_of_make( "Compile" );
    if( project!=NULL )
      for( uint i=0; i<project->vcount; i++ )
      {
        Tproject_entry *pe = (Tproject_entry *) project->getptr( i );
        strcpy( path, pe->filename );
        if( strcmp( fexpand( path ), fn )==0 )
        {
          boolean result = project->build_entry( i );
          end_of_make( 1 );
          return result;
        }
      }
    exec_watcom( fn );
    end_of_make( 1 );
    obj_file( path, fn );
    return !need_make( path );
  }

  boolean project_link( void )
  //link current file/project
  {
    char path[_MAX_PATH];
    char *fn;
    boolean result;
    start_of_make( "Link" );
    if( project != NULL )
      result = (exec_linker( NULL ) == 0);
    else
    {
      if( current_editor == NULL ) return 1;
      fn = ((Tfile_editor *) current_editor->editor)->text_editor->file_name;
      result = (exec_linker( obj_file( path, fn ) ) == 0);
    }
    end_of_make( 1 );
    return result;
  }
