
/*
   MCGALIB
   (c) 1993/94 D.G. Sureau

   These functions are for VGA 19,
   320 x 200, 256 colors screen
*/

/* Macros */

#define GETSPADR(num)  (char *) SPVECTOR[num]

  /* Return absolute address of a sprite in memory */

/* Graphic window variables */

extern int XL;           /* Default = 0   */
extern int XR;           /* Default = 319 */
extern int YB;           /* Default = 0   */
extern int YT;           /* Default = 199 */

extern unsigned char COLOR256;  /* Color for pixels */

extern unsigned char TEXTCOLOR;     /* Color for text display */
extern unsigned char BACKCOLOR;     /* Color for text background */

/*  long *SPVECTOR;   Pointer on sprites adr. must been defined */
extern char *SPCODE;                /* Pointer on sprites code */
extern unsigned int VGASCREEN;      /* Segment of VGA graphic screen */

extern char PLANE;                  /* Color plane assignment */

void selectscreen(int mode);
     /* Change screen resolution
	Mode = 19   MCGA
	Mode = 3    Text
     */

void window19(int xl,int yb,int xr,int yt); /* Define graphic window */
void cls19(int col);                        /* Clear the whole screen  */
void DOSwrite(int x,int y,char *txt);
   /* Displays text at x,y  with TEXTCOLOR color # */

char *getspadr(int number);     /* Gets absolute adr of sprite in table */

unsigned int setvirtual(unsigned long buffer);
/*
  Calculate the segment for a 0 offset.
  Input:  an allocated 64016 byte buffer address.
  Output: segment.
  Calcule le segment pour un deplacement reduit a 0.
  Entree: adresse d'un tampon de 64016 octets.
  Retour: le segment.
*/

void setplane(unsigned char plane);
 /* Set the plane number 0..15 or 255 to ignore */

void sprite256( int x,int y,char *spriteadr);
 /* Puts spr. over background, inside a window */

void csprite256(int x,int y,char *spriteadr);
 /* Puts spr. erases background, without clipping */

void csprite256c(int x,int y,char *spriteadr);
 /* Puts spr. erases background, inside a  window */

void xsprite256(int x,int y,char *spriteadr);
  /* Display a sprite in XOR mode */

void ixsprite256(int x, int y, char *spriteadr);
 /* Display reversed a sprite in XOR mode */

/* Function for saving and restoring block of screen */

void putblock(int x,int y,char *ptr);
void getblock(int lft,int bottom,int rght,int hight,char *ptr);


void icon19(int x,int y,char *ptr);  /* Put a 16 color icon on screen */

void readRGB(char *paladr);    /* Store the palette into paladr */
void writeRGB(char *paladr);   /* Set the palette from an array */
void writecolor(char creg,char r,char g,char b);
   /* Set color register for a color number */

void setpix256(int x,int y, char color);
  /* Put a pixel */
int  getpix256(int x,int y);
  /* Get color of pixel at x, y */
void line256(int x,int y,int x2,int y2, char color);
  /* Draw a line from x, y to x2, y2 */
void rectangle256(int l,int b,int r,int t, char color);
  /* Draw a rectangle */
void fillblock(int l,int b,int r,int h,char color);
  /* Fill a rectangle with a color among 256 */

void synchro();
  /* Wait for a screen refresh */
void appear(char *palette);
  /* Make the screen slowly appearing */
void disappear(char *palette);
  /* Make the screen slowly disappearing */
void MCGAscroll(char decal);
  /* Full screen scolling, call BIOS */
void scroll(int dir,int step);
 /* Scrolling of the user-defined window
    Step is the number of pixels to move
    Dir is the direction:
    1 = up
    2 = right
    3 = down
    4 = left
 */

void copyblock(int l,int b,int r,int u,unsigned src,unsigned dst);
 /* Copy a part of screen, Scr and dst are segments of real or virtual
screen. */

void copyscreen(unsigned int src,unsigned int dst);
 /* Copy a whole screen,  Src and dst are segments of screen addresses.*/

