#include <stdlib.h>;
#include <stdio.h>;
#include <alloc.h>;
#include <fcntl.h>;
#include <io.h>;
#include "animlib.h";

/*
   Librairie ANIMLIB

   Cette librairie permet d'utiliser les sries de sprites.
   Elle est inutile avec les fichiers de sprite sans series crs
   par Artist of Virtyality ou ISD en configuration par dfaut.
*/


long *SPVECTOR;
char *SPCODE;

char FRAMESIZE;



/* No de squence  laquelle appartient un sprite no 2D */

int get_series(int sprite)
{
 int i;

 i = FRAMESIZE;
 if(!i) i = 1;
 return((sprite - 1) / i);
}

/* no de frame */

int get_anim_frame(int sprite)
{
 int i;

 i = FRAMESIZE;
 if(!i) i = 1;
 return(sprite - (i * get_series(sprite)));
}


/* premier sprite d'une srie */

int get_first(int series)
{
 return(1 + series * FRAMESIZE);
}


/* nombre de frames rel dans une srie */

int get_frame_number(int series)
{
 int spr;
 int nbr;

 nbr = 0;
 spr = series * FRAMESIZE;

loop:
 spr++;                           /* Next sprite / Sprite suivant */
 if((spr == 1) || SPVECTOR[spr])  /* Slot used / Case utilise */
  {
   if(++nbr < FRAMESIZE) goto loop;
  }

 return(nbr);
}


int sprite_code(int sprite)
{
 char *adr;

 adr = (char *) SPVECTOR[sprite];
 return(adr[4]);
}

/* Exemple d'animation MCGA */

void MCGAanimate(int series, int x, int y, int xmove, int ymove)
{
 int number;
 int sprite;

 number = get_frame_number(series);
 sprite = get_first(series);

 while(number)
 {
  sprite256(x, y, (char *) SPVECTOR[sprite++]);
  x += xmove;
  y += ymove;
  delay(20);
  number--;
 }
}


/* ADD PTR OFF
   Add an offset to a pointer
   Ajoute un dplacement a un pointeur d'adresse

   Formats Ptr:  0xSSSSOOOO
	   Seg:  0xSSSS
	   Off:  0xOOOO
	   Long: Seg * 16 + Off
 */

char *AdjustPointer(void *adr, unsigned val)
{
 unsigned int  seg;
 unsigned int  dep;
 unsigned long temp;

 seg  = (unsigned) ((unsigned long )(adr) >> 16);
 dep  = (unsigned) adr;
 temp =  ((unsigned long) seg) << 4;
 temp += (unsigned long) dep;
 temp += (unsigned long) val;
 seg  = (unsigned int) (temp >> 4);
 dep  = (unsigned int) temp & 15;
 return(MK_FP(seg, dep));
}


/* Test if file exists / Existence d'un fichier */

int FileExist(char *fname)
{
 FILE *SPRFILE;
 if((SPRFILE = fopen(fname, "rb")) == 0L) return(0);
 fclose(SPRFILE);
 return(1);
}

/* Size of a file / Taille d'un fichier */

long File_Length(char *fname)
{
 int fh;
 long FILELEN;

 fh = open(fname, O_RDONLY | O_BINARY);
 if(fh >= 0)  FILELEN = filelength(fh);
	 else FILELEN = 0L;
 close(fh);
 return(FILELEN);
}


/*
   SPRITES LOAD
   Charge un fichier de sprites et
   convertit les adresses relatives en adresses absolues

   Entre: Nom du fichier
	   Taille de mmoire alloue aux sprites
	   SPVECTOR allou aux adresses
*/

int sprites_load(char *filename, long codesize)
{
 char huge *adr;
 int i;
 int arrsize;
 FILE *SPRFILE;
 int SPRMAX;
 char *SPVECTORchar;
 int  *SPVECTORint;

 if((SPRFILE = fopen(filename, "rb")) == 0L) return(0);

 SPVECTORchar = (char *) SPVECTOR;
 SPVECTORint  = (int *) SPVECTOR;

 /* Reading the header */

 fread(SPVECTORchar, 4, 1, SPRFILE);
 SPRMAX = SPVECTORint[0];
 FRAMESIZE = SPVECTORchar[2];
 if(FRAMESIZE > 1) arrsize = (MAXSPRITES + 5) * 4;
	    else { arrsize = SPRMAX * 4 + 4; FRAMESIZE = 1; }

 fread(SPVECTORchar + 4, arrsize, 1, SPRFILE);

 SPCODE = AdjustPointer(SPVECTORchar, (unsigned) ((MAXSPRITES + 5) * 4));
 adr = SPCODE;

/* Loading code of sprites, by block of 32 k */

 do {
  i = fread((char *) adr, (unsigned) min(32768L, codesize), 1, SPRFILE);
  adr = (char huge *) AdjustPointer((char *) adr, 32768U);
  codesize -= 32768L;
 } while(i && (codesize > 0L));

 fclose(SPRFILE);

 for(i = 1; i <= MAXSPRITES; i++)
  {
   if(SPVECTOR[i] || (i == 1))
    SPVECTOR[i] += (unsigned long) SPCODE;
  }

 return(SPRMAX);
}

/*
  SPRITE ALLOC
  Allocate memory for sprite file loading
  Allouer la mmoire pour charger le fichier de sprites
*/

int sprite_alloc()
{
 SPVECTOR = (long *) malloc(65512U);
 return(FP_SEG(SPVECTOR));
}
