/*-------------------------------------
   EMF8.C -- Enhanced Metafile Demo #8
             (c) Charles Petzold, 1994
  -------------------------------------*/

#include <windows.h>
#include <string.h>

char szClass [] = "EMF8" ;
char szTitle [] = "EMF8: Enhanced Metafile Demo #8" ;

void CreateRoutine (HWND hwnd)
     {
     HDC          hdcEMF ;
     HENHMETAFILE hemf ;

     hdcEMF = CreateEnhMetaFile (NULL, "emf8.emf", NULL,
                                 "EMF8\0EMF Demo #8\0") ;

     Rectangle (hdcEMF, 100, 100, 201, 201) ;

     MoveToEx  (hdcEMF, 100, 100, NULL) ;
     LineTo    (hdcEMF, 200, 200) ;

     MoveToEx  (hdcEMF, 200, 100, NULL) ;
     LineTo    (hdcEMF, 100, 200) ;

     hemf = CloseEnhMetaFile (hdcEMF) ;

     DeleteEnhMetaFile (hemf) ;
     }

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     HENHMETAFILE hemf ;
     RECT         rect ;

     rect.left   =     cxArea / 4 ;
     rect.right  = 3 * cxArea / 4 ;
     rect.top    =     cyArea / 4 ;
     rect.bottom = 3 * cyArea / 4 ;

     hemf = GetEnhMetaFile ("emf8.emf") ;

     PlayEnhMetaFile (hdc, hemf, &rect) ;

     DeleteEnhMetaFile (hemf) ;
     }
