// winapp.cpp 1/13/91 rev.12/16/91

//#include<string.h>
#include"winapp.h"

HANDLE WinApplication::ApphInstance;
HANDLE WinApplication::hPrevInstance;
LPSTR WinApplication::lpszCmdLine;
int WinApplication::nCmdShow;

static char *szclassname = "WinApp";
static char *szwinname = "WinApp::Window";
char *szMDIClient = "MDIClient";

int WinApplication::Run(void)    // default message loop processing
    {
    MSG msg;

    while(GetMessage(&msg, NULL, 0, 0))
        {
        if(!UserMessageProcessing(&msg))
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }
    return msg.wParam;
    }

WinClass::WinClass(void)
    {
    style = NOSTYLE;
    lpfnWndProc = DefWindowProc;
    cbClsExtra = NOEXTRABYTES;
    cbWndExtra = NOEXTRABYTES;
    hInstance = NULL;
    hIcon = LoadIcon(NULL, IDI_APPLICATION);
    hCursor = LoadCursor(NULL, IDC_ARROW);
    hbrBackground = GetStockObject(WHITE_BRUSH);
    lpszMenuName = NULL;
    lpszClassName = NULL;
    class_registered = FALSE;
    }

void WinClass::ClassRegister(void)
    {
        // since 'this' is derived from WNDCLASS, it's passed as one
    RegisterClass(this);
    class_registered = TRUE;
    }

BOOL WinClass::ClassRegistered(void)   
    { 
    if(class_registered)
        return TRUE;
    if(!lpszClassName || !hInstance)
        return FALSE;

    WNDCLASS wndclass;
    
    if(GetClassInfo(hInstance,lpszClassName,&wndclass))
        {
        LPSTR menuName = lpszMenuName;
        HANDLE hInst = hInstance;
        LPSTR className = lpszClassName;
        WNDCLASS *wc = this;
        *wc = wndclass;         // structure assignment
        lpszClassName = className;
        lpszMenuName = menuName;
        hInstance = hInst;
        return class_registered = TRUE;
        }
    return FALSE;
    }


WinHandle::WinHandle(void)
    {
    hWnd = NULL;
    classname = (LPSTR)szclassname;
    windowname = (LPSTR)szwinname;
    winstyle = 0;
    upper_left_x = upper_left_y = winwidth = winheight = 0;
    winParent = NULL;
    menu = NULL;
    hInstance = 0;
    lpParam = NULL;
    }

BOOL WinHandle::Create(void)
    {
    if(hWnd)    // if window's already created, return TRUE
        return TRUE;

    hWnd = CreateWindow(classname,windowname,winstyle,upper_left_x,
        upper_left_y,winwidth,winheight,winParent,menu,hInstance,
        lpParam);

    return (hWnd ? TRUE : FALSE);
    }

Window::Window(char *winname)
    {
    SetClassInstance();         // insert instance handle
    SetWinInstance(GetInstance());
    SetClassName(winname);
    SetWinName(winname);
    DefaultDisplay();
    previously_visible = FALSE;
    hWnd = 0;
    SetClassWinXbytes(WINAPP_RESERVED);
    lpfnWndProc = WinAppWndProc;
    };

    // displays window and creates if not already created
BOOL Window::Display(void)
    {
    Register();
    if(!Create())
        return FALSE;
    Show();
    Update();
    return TRUE;
    }

BOOL Window::Display(int display_style)
    {
    current_display = display_style;
    return Display();
    }

BOOL Window::ClassRegistered(void)
    {
    if(WinClass::ClassRegistered())
        return TRUE;
    return FALSE;
    }
    // should call SetClassInstance and SetClassName if not called

void Window::Register(void)
    {
    if(!ClassRegistered())         // if class not registered
        {
        if(!GetClassName())         // if class name not set
            SetClassName(classname);
        ClassRegister();           // register the class
        }
    }

BOOL Window::Create(void)
    {
    Register();
    WHdl.hInstance = GetInstance();
    WHdl.classname = lpszClassName;
    WHdl.lpParam = (LPSTR)this;
    return WHdl.Create();
    }

void Window::Paint(void)     // paints window
    {
    PAINTSTRUCT ps;

    BeginPaint(hWnd, &ps);
    EndPaint(hWnd, &ps);
    }

void Window::SetClassIcon(LPSTR iconname)
    {
    if(hInstance)
        hIcon = LoadIcon(hInstance,iconname);
    }


void Window::DefWinProc(WinAppMsg& m)
    {
    m.msgRetVal = DefWindowProc(hWnd,m.msg,m.wParam,m.lParam);
    }

void Window::WMUSER(WinAppMsg& m)         
    {    
    DefWinProc(m); 
    m.userMsgUsed = TRUE;
    }

long far pascal WinAppWndProc(HWND hWnd, WORD msg, WORD wParam, LONG lParam)
    {
    Window *w = (Window *)GetWindowPointer(hWnd);

    if(msg == WM_NCCREATE)
        {
        w = (Window *)((LPCREATESTRUCT)lParam)->lpCreateParams;
        SetWindowPointer(hWnd, w);
        w->SethWnd(hWnd);
        }

    if(!w)
        return DefWindowProc(hWnd, msg, wParam, lParam);

    WinAppMsg m;
    m.msg = msg;
    m.wParam = wParam;
    m.lParam = lParam;
    m.msgRetVal = 0L;
    StdWndProc(w,m);
    return m.msgRetVal;
    }

void PASCAL StdWndProc(Window *w, WinAppMsg& m)
    {
    if(m.msg < WM_USER)
        switch(m.msg)
            {
#if defined(_WM_NULL)            
            case WM_NULL:               w->WMNULL(m);               break;
#endif
#if defined(_WM_CREATE)
            case WM_CREATE:             w->WMCREATE(m);             break;
#endif
#if defined(_WM_DESTROY)
            case WM_DESTROY:            w->WMDESTROY(m);            break;
#endif
#if defined(_WM_MOVE)
            case WM_MOVE:               w->WMMOVE(m);               break;
#endif
#if defined(_WM_SIZE)
            case WM_SIZE:               w->WMSIZE(m);               break;
#endif
#if defined(_WM_ACTIVATE)
            case WM_ACTIVATE:           w->WMACTIVATE(m);           break;
#endif
#if defined(_WM_SETFOCUS)
            case WM_SETFOCUS:           w->WMSETFOCUS(m);           break;
#endif
#if defined(_WM_KILLFOCUS)
            case WM_KILLFOCUS:          w->WMKILLFOCUS(m);          break;
#endif
#if defined(_WM_ENABLE)
            case WM_ENABLE:             w->WMENABLE(m);             break;
#endif
#if defined(_WM_SETREDRAW)
            case WM_SETREDRAW:          w->WMSETREDRAW(m);          break;
#endif
#if defined(_WM_SETTEXT)
            case WM_SETTEXT:            w->WMSETTEXT(m);            break;
#endif
#if defined(_WM_GETTEXT)
            case WM_GETTEXT:            w->WMGETTEXT(m);            break;
#endif
#if defined(_WM_GETTEXTLENGTH)
            case WM_GETTEXTLENGTH:      w->WMGETTEXTLENGTH(m);      break;
#endif
#if defined(_WM_PAINT)
            case WM_PAINT:              w->WMPAINT(m);              break;
#endif
#if defined(_WM_CLOSE)
            case WM_CLOSE:              w->WMCLOSE(m);              break;
#endif
#if defined(_WM_QUERYENDSESSION)
            case WM_QUERYENDSESSION:    w->WMQUERYENDSESSION(m);    break;
#endif
#if defined(_WM_QUIT)
            case WM_QUIT:               w->WMQUIT(m);               break;
#endif
#if defined(_WM_QUERYOPEN)
            case WM_QUERYOPEN:          w->WMQUERYOPEN(m);          break;
#endif
#if defined(_WM_ERASEBKGND)
            case WM_ERASEBKGND:         w->WMERASEBKGND(m);         break;
#endif
#if defined(_WM_SYSCOLORCHANGE)
            case WM_SYSCOLORCHANGE:     w->WMSYSCOLORCHANGE(m);     break;
#endif
#if defined(_WM_ENDSESSION)
            case WM_ENDSESSION:         w->WMENDSESSION(m);         break;
#endif
#if defined(_WM_SHOWWINDOW)
            case WM_SHOWWINDOW:         w->WMSHOWWINDOW(m);         break;
#endif
#if defined(_WM_CTLCOLOR)
            case WM_CTLCOLOR:           w->WMCTLCOLOR(m);           break;
#endif
#if defined(_WM_WININICHANGE)
            case WM_WININICHANGE:       w->WMWININICHANGE(m);       break;
#endif
#if defined(_WM_DEVMODECHANGE)
            case WM_DEVMODECHANGE:      w->WMDEVMODECHANGE(m);      break;
#endif
#if defined(_WM_ACTIVATEAPP)
            case WM_ACTIVATEAPP:        w->WMACTIVATEAPP(m);        break;
#endif
#if defined(_WM_FONTCHANGE)
            case WM_FONTCHANGE:         w->WMFONTCHANGE(m);         break;
#endif
#if defined(_WM_TIMECHANGE)
            case WM_TIMECHANGE:         w->WMTIMECHANGE(m);         break;
#endif
#if defined(_WM_CANCELMODE)
            case WM_CANCELMODE:         w->WMCANCELMODE(m);         break;
#endif
#if defined(_WM_SETCURSOR)
            case WM_SETCURSOR:          w->WMSETCURSOR(m);          break;
#endif
#if defined(_WM_MOUSEACTIVATE)
            case WM_MOUSEACTIVATE:      w->WMMOUSEACTIVATE(m);      break;
#endif
#if defined(_WM_CHILDACTIVATE)
            case WM_CHILDACTIVATE:      w->WMCHILDACTIVATE(m);      break;
#endif
#if defined(_WM_QUEUESYNC)
            case WM_QUEUESYNC:          w->WMQUEUESYNC(m);          break;
#endif
#if defined(_WM_GETMINMAXINFO)
            case WM_GETMINMAXINFO:      w->WMGETMINMAXINFO(m);      break;
#endif
#if defined(_WM_PAINTICON)
            case WM_PAINTICON:          w->WMPAINTICON(m);          break;
#endif
#if defined(_WM_ICONERASEBKGND)
            case WM_ICONERASEBKGND:     w->WMICONERASEBKGND(m);     break;
#endif
#if defined(_WM_NEXTDLGCTL)
            case WM_NEXTDLGCTL:         w->WMNEXTDLGCTL(m);         break;
#endif
#if defined(_WM_SPOOLERSTATUS)
            case WM_SPOOLERSTATUS:      w->WMSPOOLERSTATUS(m);      break;
#endif
#if defined(_WM_DRAWITEM)
            case WM_DRAWITEM:           w->WMDRAWITEM(m);           break;
#endif
#if defined(_WM_MEASUREITEM)
            case WM_MEASUREITEM:        w->WMMEASUREITEM(m);        break;
#endif
#if defined(_WM_DELETEITEM)
            case WM_DELETEITEM:         w->WMDELETEITEM(m);         break;
#endif
#if defined(_WM_VKEYTOITEM)
            case WM_VKEYTOITEM:         w->WMVKEYTOITEM(m);         break;
#endif
#if defined(_WM_CHARTOITEM)
            case WM_CHARTOITEM:         w->WMCHARTOITEM(m);         break;
#endif
#if defined(_WM_SETFONT)
            case WM_SETFONT:            w->WMSETFONT(m);            break;
#endif
#if defined(_WM_GETFONT)
            case WM_GETFONT:            w->WMGETFONT(m);            break;
#endif
#if defined(_WM_QUERYDRAGICON)
            case WM_QUERYDRAGICON:      w->WMQUERYDRAGICON(m);      break;
#endif
#if defined(_WM_COMPAREITEM)
            case WM_COMPAREITEM:        w->WMCOMPAREITEM(m);        break;
#endif
#if defined(_WM_COMPACTING)
            case WM_COMPACTING:         w->WMCOMPACTING(m);         break;
#endif
#if defined(_WM_NCCREATE)
            case WM_NCCREATE:           w->WMNCCREATE(m);           break;
#endif
#if defined(_WM_NCDESTROY)
            case WM_NCDESTROY:          w->WMNCDESTROY(m);          break;
#endif
#if defined(_WM_NCCALCSIZE)
            case WM_NCCALCSIZE:         w->WMNCCALCSIZE(m);         break;
#endif
#if defined(_WM_NCHITTEST)
            case WM_NCHITTEST:          w->WMNCHITTEST(m);          break;
#endif
#if defined(_WM_NCPAINT)
            case WM_NCPAINT:            w->WMNCPAINT(m);            break;
#endif
#if defined(_WM_NCACTIVATE)
            case WM_NCACTIVATE:         w->WMNCACTIVATE(m);         break;
#endif
#if defined(_WM_GETDLGCODE)
            case WM_GETDLGCODE:         w->WMGETDLGCODE(m);         break;
#endif
#if defined(_WM_NCMOUSEMOVE)
            case WM_NCMOUSEMOVE:        w->WMNCMOUSEMOVE(m);        break;
#endif
#if defined(_WM_NCLBUTTONDOWN)
            case WM_NCLBUTTONDOWN:      w->WMNCLBUTTONDOWN(m);      break;
#endif
#if defined(_WM_NCLBUTTONUP)
            case WM_NCLBUTTONUP:        w->WMNCLBUTTONUP(m);        break;
#endif
#if defined(_WM_NCLBUTTONDBLCLK)
            case WM_NCLBUTTONDBLCLK:    w->WMNCLBUTTONDBLCLK(m);    break;
#endif
#if defined(_WM_NCRBUTTONDOWN)
            case WM_NCRBUTTONDOWN:      w->WMNCRBUTTONDOWN(m);      break;
#endif
#if defined(_WM_NCRBUTTONUP)
            case WM_NCRBUTTONUP:        w->WMNCRBUTTONUP(m);        break;
#endif
#if defined(_WM_NCRBUTTONDBLCLK)
            case WM_NCRBUTTONDBLCLK:    w->WMNCRBUTTONDBLCLK(m);    break;
#endif
#if defined(_WM_NCMBUTTONDOWN)
            case WM_NCMBUTTONDOWN:      w->WMNCMBUTTONDOWN(m);      break;
#endif
#if defined(_WM_NCMBUTTONUP)
            case WM_NCMBUTTONUP:        w->WMNCMBUTTONUP(m);        break;
#endif
#if defined(_WM_NCMBUTTONDBLCLK)
            case WM_NCMBUTTONDBLCLK:    w->WMNCMBUTTONDBLCLK(m);    break;
#endif
#if defined(_WM_KEYDOWN)
            case WM_KEYDOWN:            w->WMKEYDOWN(m);            break;
#endif
#if defined(_WM_KEYUP)
            case WM_KEYUP:              w->WMKEYUP(m);              break;
#endif
#if defined(_WM_CHAR)
            case WM_CHAR:               w->WMCHAR(m);               break;
#endif
#if defined(_WM_DEADCHAR)
            case WM_DEADCHAR:           w->WMDEADCHAR(m);           break;
#endif
#if defined(_WM_SYSKEYDOWN)
            case WM_SYSKEYDOWN:         w->WMSYSKEYDOWN(m);         break;
#endif
#if defined(_WM_SYSKEYUP)
            case WM_SYSKEYUP:           w->WMSYSKEYUP(m);           break;
#endif
#if defined(_WM_SYSCHAR)
            case WM_SYSCHAR:            w->WMSYSCHAR(m);            break;
#endif
#if defined(_WM_SYSDEADCHAR)
            case WM_SYSDEADCHAR:        w->WMSYSDEADCHAR(m);        break;
#endif
#if defined(_WM_KEYLAST)
            case WM_KEYLAST:            w->WMKEYLAST(m);            break;
#endif
#if defined(_WM_INITDIALOG)
            case WM_INITDIALOG:         w->WMINITDIALOG(m);         break;
#endif
#if defined(_WM_COMMAND)
            case WM_COMMAND:            w->WMCOMMAND(m);            break;
#endif
#if defined(_WM_SYSCOMMAND)
            case WM_SYSCOMMAND:         w->WMSYSCOMMAND(m);         break;
#endif
#if defined(_WM_TIMER)
            case WM_TIMER:              w->WMTIMER(m);              break;
#endif
#if defined(_WM_HSCROLL)
            case WM_HSCROLL:            w->WMHSCROLL(m);            break;
#endif
#if defined(_WM_VSCROLL)
            case WM_VSCROLL:            w->WMVSCROLL(m);            break;
#endif
#if defined(_WM_INITMENU)
            case WM_INITMENU:           w->WMINITMENU(m);           break;
#endif
#if defined(_WM_INITMENUPOPUP)
            case WM_INITMENUPOPUP:      w->WMINITMENUPOPUP(m);      break;
#endif
#if defined(_WM_MENUSELECT)
            case WM_MENUSELECT:         w->WMMENUSELECT(m);         break;
#endif
#if defined(_WM_MENUCHAR)
            case WM_MENUCHAR:           w->WMMENUCHAR(m);           break;
#endif
#if defined(_WM_ENTERIDLE)
            case WM_ENTERIDLE:          w->WMENTERIDLE(m);          break;
#endif
#if defined(_WM_MOUSEFIRST)
            case WM_MOUSEFIRST:         w->WMMOUSEMOVE(m);          break;
#endif
#if defined(_WM_LBUTTONDOWN)
            case WM_LBUTTONDOWN:        w->WMLBUTTONDOWN(m);        break;
#endif
#if defined(_WM_LBUTTONUP)
            case WM_LBUTTONUP:          w->WMLBUTTONUP(m);          break;
#endif
#if defined(_WM_LBUTTONDBLCLK)
            case WM_LBUTTONDBLCLK:      w->WMLBUTTONDBLCLK(m);      break;
#endif
#if defined(_WM_RBUTTONDOWN)
            case WM_RBUTTONDOWN:        w->WMRBUTTONDOWN(m);        break;
#endif
#if defined(_WM_RBUTTONUP)
            case WM_RBUTTONUP:          w->WMRBUTTONUP(m);          break;
#endif
#if defined(_WM_RBUTTONDBLCLK)
            case WM_RBUTTONDBLCLK:      w->WMRBUTTONDBLCLK(m);      break;
#endif
#if defined(_WM_MBUTTONDOWN)
            case WM_MBUTTONDOWN:        w->WMMBUTTONDOWN(m);        break;
#endif
#if defined(_WM_MBUTTONUP)
            case WM_MBUTTONUP:          w->WMMBUTTONUP(m);          break;
#endif
#if defined(_WM_MBUTTONDBLCLK)
            case WM_MBUTTONDBLCLK:      w->WMMOUSELAST(m);          break;
#endif
#if defined(_WM_PARENTNOTIFY)
            case WM_PARENTNOTIFY:       w->WMPARENTNOTIFY(m);       break;
#endif
#if defined(_WM_MDICREATE)
            case WM_MDICREATE:          w->WMMDICREATE(m);          break;
#endif
#if defined(_WM_MDIDESTROY)
            case WM_MDIDESTROY:         w->WMMDIDESTROY(m);         break;
#endif
#if defined(_WM_MDIACTIVATE)
            case WM_MDIACTIVATE:        w->WMMDIACTIVATE(m);        break;
#endif
#if defined(_WM_MDIRESTORE)
            case WM_MDIRESTORE:         w->WMMDIRESTORE(m);         break;
#endif
#if defined(_WM_MDINEXT)
            case WM_MDINEXT:            w->WMMDINEXT(m);            break;
#endif
#if defined(_WM_MDIMAXIMIZE)
            case WM_MDIMAXIMIZE:        w->WMMDIMAXIMIZE(m);        break;
#endif
#if defined(_WM_MDITILE)
            case WM_MDITILE:            w->WMMDITILE(m);            break;
#endif
#if defined(_WM_MDICASCADE)
            case WM_MDICASCADE:         w->WMMDICASCADE(m);         break;
#endif
#if defined(_WM_MDIICONARRANGE)
            case WM_MDIICONARRANGE:     w->WMMDIICONARRANGE(m);     break;
#endif
#if defined(_WM_MDIGETACTIVE)
            case WM_MDIGETACTIVE:       w->WMMDIGETACTIVE(m);       break;
#endif
#if defined(_WM_MDISETMENU)
            case WM_MDISETMENU:         w->WMMDISETMENU(m);         break;
#endif
#if defined(_WM_CUT)
            case WM_CUT:                w->WMCUT(m);                break;
#endif
#if defined(_WM_COPY)
            case WM_COPY:               w->WMCOPY(m);               break;
#endif
#if defined(_WM_PASTE)
            case WM_PASTE:              w->WMPASTE(m);              break;
#endif
#if defined(_WM_CLEAR)
            case WM_CLEAR:              w->WMCLEAR(m);              break;
#endif
#if defined(_WM_UNDO)
            case WM_UNDO:               w->WMUNDO(m);               break;
#endif
#if defined(_WM_RENDERFORMAT)
            case WM_RENDERFORMAT:       w->WMRENDERFORMAT(m);       break;
#endif
#if defined(_WM_RENDERALLFORMATS)
            case WM_RENDERALLFORMATS:   w->WMRENDERALLFORMATS(m);   break;
#endif
#if defined(_WM_DESTROYCLIPBOARD)
            case WM_DESTROYCLIPBOARD:   w->WMDESTROYCLIPBOARD(m);   break;
#endif
#if defined(_WM_DRAWCLIPBOARD)
            case WM_DRAWCLIPBOARD:      w->WMDRAWCLIPBOARD(m);      break;
#endif
#if defined(_WM_PAINTCLIPBOARD)
            case WM_PAINTCLIPBOARD:     w->WMPAINTCLIPBOARD(m);     break;
#endif
#if defined(_WM_VSCROLLCLIPBOARD)
            case WM_VSCROLLCLIPBOARD:   w->WMVSCROLLCLIPBOARD(m);   break;
#endif
#if defined(_WM_SIZECLIPBOARD)
            case WM_SIZECLIPBOARD:      w->WMSIZECLIPBOARD(m);      break;
#endif
#if defined(_WM_ASKCBFORMATNAME)
            case WM_ASKCBFORMATNAME:    w->WMASKCBFORMATNAME(m);    break;
#endif
#if defined(_WM_CHANGECBCHAIN)
            case WM_CHANGECBCHAIN:      w->WMCHANGECBCHAIN(m);      break;
#endif
#if defined(_WM_HSCROLLCLIPBOARD)
            case WM_HSCROLLCLIPBOARD:   w->WMHSCROLLCLIPBOARD(m);   break;
#endif
#if defined(_WM_QUERYNEWPALETTE)
            case WM_QUERYNEWPALETTE:    w->WMQUERYNEWPALETTE(m);    break;
#endif
#if defined(_WM_PALETTEISCHANGING)
            case WM_PALETTEISCHANGING:  w->WMPALETTEISCHANGING(m);  break;
#endif
#if defined(_WM_PALETTECHANGED)
            case WM_PALETTECHANGED:     w->WMPALETTECHANGED(m);     break;
#endif
            default:                    w->DefWinProc(m);           break;            
            }
    else
        {
        m.userMsgUsed = FALSE;
        w->WMUSER(m);
        if(!m.userMsgUsed)
            w->DefWinProc(m);
        }
    }


