// dow.c
#include<stdio.h>
#include<stdlib.h>

int dow(int month, int day, int year)
    {
    const signed char calendar[12] =
        {
        0, 1, -1, 0, 0, 1, 1, 2, 3, 3, 4, 4    // base 30
        };
    return
        ((  ((year-1) * 365L)       // # days of normal years, previous
            + ((year-1) / 4)        // # of possible leap days
            - (((year-1) / 100)     // # of non-century leap days
            - ((year-1) / 400)
            )
                                    // # of days in month passed
        + (calendar[month-1] + ((month-1)*30))     
        + ((
          ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0))
            && (month > 2)
           )
        + day)
        % 7);
    }


void main(int argc, char **argv)
    {
    int day, month, year;

    const char *daystr[7] =
        { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };

    if(argc != 4)
        {
        printf("Enter date [mm dd yyyy]: ");
        scanf("%d %d %d", &month, &day, &year);
        }
    else
        {
        month = atoi(argv[1]);
        day = atoi(argv[2]);
        year = atoi(argv[3]);
        }
    printf("%02d/%02d/%04d is on %s\n", 
        month,day,year, daystr[dow(month,day,year)]);
    }
