UNIT Math;

{ This Unit is designed to meet the demand on
  Turbo Pascal to do scientific calculations  }

(**) INTERFACE (**)
TYPE
  CompStr = String[2*SizeOf(Real)];
  Complex = RECORD
              CASE Byte OF
                0 : (S : CompStr);
                1 : (len  : Byte;
                     R, I : Real);
                2 : (leng : Byte;
                     Rad, Theta : Real);
            END;

  FUNCTION C2S(C : Complex; w, d : Byte) : String;
  FUNCTION P2S(C : Complex; w, d : Byte) : String;
  FUNCTION sinh(X : Real) : Real;
  FUNCTION cosh(X : Real) : Real;
  FUNCTION CmpAdd(A, B : Complex)  : CompStr;
  FUNCTION CmpSub(A, B : Complex)  : CompStr;
  FUNCTION CmpMul(A, B : Complex)  : CompStr;
  FUNCTION CmpDiv(A, B : Complex)  : CompStr;
  FUNCTION CmpExp(X : Complex)  : CompStr;
  FUNCTION CmpSinh(X : Complex) : CompStr;
  FUNCTION CmpCosh(X : Complex) : CompStr;

  FUNCTION RecToPol(X : Complex) : CompStr;
  {rectangular to polar coordinates}
  FUNCTION PoltoREC(X : Complex) : CompStr;
  {polar to rectangular coordinates}

(**) IMPLEMENTATION (**)
  FUNCTION C2S(C : Complex; w, d : Byte) : String;
  VAR RString, IString : String;
  BEGIN
    Str(C.R:w:d, RString);
    Str(C.I:w:d, IString);
    C2S := '(' + RString + ' + ' + IString + 'i)';
  END;

  FUNCTION P2S(C : Complex; w, d : Byte) : String;
  VAR RadString, ThetaString : String;
  BEGIN
    Str(C.R:w:d, RadString);
    Str(C.I:w:d, ThetaString);
    P2S := RadString + ' at ' +
                ThetaString + ' degrees';
  END;

  FUNCTION Sinh(X : Real) : Real;
  BEGIN Sinh := (Exp(X)-Exp(-X))/2; END;

  FUNCTION Cosh(X : Real) : Real;
  BEGIN Cosh := (Exp(X)+Exp(-X))/2; END;

  FUNCTION CmpAdd(A, B : Complex)  : CompStr;
  VAR Temp : Complex;
  BEGIN
    Temp.Len := 12;
    Temp.R := A.R + B.R;
    Temp.I := A.I + B.I;
    CmpAdd := Temp.S;
  END;

  FUNCTION CmpSub(A, B : Complex)  : CompStr;
  VAR Temp : Complex;
  BEGIN
    Temp.Len := 12;
    Temp.R := A.R - B.R;
    Temp.I := A.I - B.I;
    CmpSub := Temp.S;
  END;

  FUNCTION CmpMul(A, B : Complex)  : CompStr;
  VAR Temp : Complex;
  BEGIN
    Temp.Len := 12;
    Temp.R := (A.R * B.R) - (A.I * B.I);
    Temp.I := (A.R * B.I) + (B.R * A.I);
    CmpMul := Temp.S;
  END;

  FUNCTION CmpDiv(A, B : Complex)  : CompStr;
  VAR Temp : Complex;
    TempR : Real;
  BEGIN
    Temp.Len := 12;
    TempR  := Sqr(B.R) + Sqr(B.I);
    Temp.R := ((A.R * B.R) + (A.I * B.I))/TempR;
    Temp.I := ((B.R * A.I) - (A.R * B.I))/TempR;
    CmpDiv := Temp.S;
  END;

  FUNCTION CmpExp(X : Complex) : CompStr;
  VAR Temp : Complex;
  BEGIN
    Temp.Len := 12;
    Temp.R := Exp(X.R) * Cos(X.I);
    Temp.I := Exp(X.R) * Sin(X.I);
    CmpExp := Temp.S;
  END;

  FUNCTION CmpSinh(X : Complex) : CompStr;
  VAR Temp : Complex;
  BEGIN
    Temp.Len := 12;
    Temp.R := Sinh(X.R) * Cos(X.I);
    Temp.I := Cosh(X.R) * Sin(X.I);
    CmpSinh := Temp.S;
  END;

  FUNCTION CmpCosh(X : Complex) : CompStr;
  VAR Temp : Complex;
  BEGIN
    Temp.Len := 12;
    Temp.R := Cosh(X.R) * Cos(X.I);
    Temp.I := Sinh(X.R) * Sin(X.I);
    CmpCosh := Temp.S;
  END;

  FUNCTION RECtoPol(X : Complex) : CompStr;
  VAR Temp : Complex;
  BEGIN
    Temp.Rad := Sqrt(Sqr(X.R) + Sqr(X.I));
    IF Abs(X.R) > 0 THEN
      Temp.Theta := ArcTan(X.I/X.R) * 180/pi
    ELSE Temp.Theta := 90;
    IF (X.R <= 0) THEN
      BEGIN
        IF (X.I < 0) THEN Temp.theta := Temp.theta - 180
        ELSE Temp.theta := Temp.theta + 180;
      END;
    RecToPol := Temp.S;
  END;

  FUNCTION PoltoREC(X : Complex) : CompStr;
  VAR Temp : Complex;
  BEGIN
    Temp.R := X.Rad * Cos(X.Theta * pi/180);
    Temp.I := X.Rad * Sin(X.Theta * pi/180);
    PolToRec := Temp.S;
  END;

END.
