unit BigArray;

{Program to accompany article in issue #10 of the Pascal NewsLetter.     }
{Author: Mitch Davis, (3:634/384.6) +61-3-890-2062.                      }

{ from public domain ideas by Trevor J. Carlsen, 3:690/644 }

{This unit lets you implement whopping great big arrays, larger than the }
{64k offered by Turbo Pascal.  It does this by offering a large array    }
{object.                                                                 }
{The array can have elements of any size, and the array can take all free}
{DOS memory.  Thus, you could conceiveably have an array of reals taking }
{some 400k or more.  Each array can take a subscript in the range of 1 to}
{the parameter you hand the Init method - ie, the array is one-based.    }

{Note this code has NOT been optimised - it needs it very badly!         }
{A future version of this unit (to be published in the PNL) will be      }
{heavily optimised, will offer multidimensional arrays, and will offer   }
{arrays that spill over onto disk, as well as specific support for sparse}
{arrays.  Keep your eyes out for it!                                     }

{This program has NOT been proven correct.  I know it works when used as }
{part of the MDP programs published in PNL #10, but I can't vouch for its}
{operation if and when used in different situations.                     }

{I suggest compiling this in 286 mode, at least until I can get around to}
{optimising it!                                                          }

{$R-,S-,N+}

{$DEFINE OnA286} {Remove this line if you're not on a 186 or higher.}

{$IFDEF OnA286} {$G+} {$ELSE} {$G-} {$ENDIF}

interface

{$IFDEF OnA286}
uses Test186;
{$ENDIF}

type BigDOSArray = object
                     procedure SetElemSize (newsize:word);
                     function GetMaxSize:longint;
                     procedure Init (Elems:longint);
                     function Elem (elemnum:longint):pointer;
                     procedure Done;
                   private
                     base:word; {paragraph of base}
                     linear:longint;
                     size:word; {size of each element}
                   end;

implementation

uses DosMem;

procedure BigDOSArray.SetElemSize;

begin
  size := newsize;
end;

function BigDOSArray.GetMaxSize;

var paras:word;
    bytes:longint;
    elemss:longint;

begin
  GetMaxSize := pred ((longint (DosMem.Largest) shl 4) div size);
end;

procedure BigDOSArray.Init;

var bytes:longint;
    paras:word;

begin
  base := DosMem.Alloc (succ((longint(Elems) * size) shr 4));
  linear := longint (base) shl 4;
end;

function BigDOSArray.Elem;

var offset:longint;

begin
  offset := pred(elemnum) * size + linear;
  Elem := ptr (offset shr 4,offset and $f);
end;

procedure BigDOSArray.Done;

begin
  DosMem.Free (base);
end;

end.
