
/****************************************************************************
*   Function:    int sockrx(int fd, char *bufptr, int toread)               *
*   Operation:   to read nbytes from socket fd into ptr                     *
*                BUT FAST -- WITHOUT PAUSING...                             *
*   Returns:     a 0 for OK, or -1 for error                                *
*   Parameters:  fd, socket file descriptor                                 *
*                bufptr, address of character array to read into            *
*                toread, the maximum number of characters to read into ptr  *
****************************************************************************/

# include <io.h>
#include <errno.h>

extern int errno;

int sockrx(fd, bufptr, toread)
  register int fd;
  register char *bufptr;
  register int toread;
{
  int nread;

  if ((nread = read(fd, bufptr, toread)) < 0) {
    bufptr[0] = 0;
    if (errno == EWOULDBLOCK) {
      return (0);
    } else {
      return (-1);
    }
  }
  bufptr[nread] = 0;
  return (0);
}
