/* MX.C - (c) 1991 Nils Hammar */

/*
	(MX = MaileXport)

	MX.C is a tiny C program that has to be started periodically
	from cron on the UNIX computer that serves as PC-NFS server.
	It must be the same computer as where the email directory
	exists.

	The program examines the directory /usr/mail/pcsend, and
	checks files that is supposed to be written by the program MAILRD
	under MS-DOS.
	It is important that the field "To: ..." is the first line of the
	message to be sent! Any other location of this line is illegal
	and will result in unpredictable effects.

	This program may be used by anybody as long as the source of the
	program is specified.
	I cannot guarantee that this programs will work in all environments,
	and will not be responsible for any malfunctions or peculiar effects
	that this program results in.

	USE THE PROGRAM AT YOUR OWN RISC!

	I recommend that this program is started each five minutes from cron.

	I didn't implement an infinite loop with a sleep because I think that
	this allocates system resources in an ill-behaved way.
	With this method you will always start a fresh program that isn't
	infected with old data.

	Any modifications or enhancements done to this program may be sent to:
	nils@f109f.mil.se, 4341@msg.abc.se or
	Nils.Hammar@f90.n204.z2.fidonet.org
	(Nils Hammar at 2:204/90@fidonet.org)
*/

#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/ino.h>
#include <sys/stat.h>
#include <time.h>

/*	A home-brewn string compare algorithm. */

int		subcompstr(compval, string)
unsigned char	*compval, *string;
{
	int	i;

	if (strlen(compval) > strlen(string)) return(-1);

	i=0;
	while( *(compval + i) == *(string + i) && *(compval + i) != 0) i++;

	if (*(compval + i) == 0) return(0);

	return(1);
}

/*	Process files for a specific user. */

void	analyze(user)
char	*user;
{
	FILE	*f, *g;
	char	line[160],
		touser[160],
		tempfile[160],
		tmp[160],
		tempfile2[160];
	long	tid[1];
	int	i;


/*	Create a temporary filename in /tmp.
	Change here if /usr/mail is on a different disk, since it
	isn't possible to move files between physical disks with the
	"rename" function under all *nix versions. */

	sprintf(tempfile2, "/tmp/mxm.%lx", time(tid));

/*	Rename the file that we will process.
	If this routine fails, don't worry and return.
	(The file might be under processing from the user that owns
	this file, or is this program maybe run twice???) */

	if (rename(user, tempfile2) != 0) return;

/*	If we lost the file after or during the rename,
	then we will have to worry!!! */

	if ((f=fopen(tempfile2, "r")) == NULL)
	{
		perror(tempfile2);
		exit(9);
	}

/*	Create an another temporary file... */

	sprintf(tempfile, "/tmp/mxs.%lx", time(tid));

	if ((g=fopen(tempfile, "w")) == NULL)
	{
		perror(tempfile);
		exit(9);
	}

/*	Read the input file until it's empty. */

	strcpy(touser, "");
	while(fgets(line, 158, f) != NULL)
	{
/*	If we caught a "To:"-field, it isn't a part of the message, it's
	control information for this program! */

		if (subcompstr("To: ", line) == 0)
		{
/*	If it was the secont time we encoutered the "To:"-field,
	we have a message to send. */

			if (*touser != 0)
			{
				fclose(g);
				i=0;
				while(*(touser + i) != 0)
				{
					if (*(touser + i) < ' ')
						*(touser + i)=' ';
					i++;
				}
				sprintf(tmp, "mail %s < %s", touser, tempfile);
				system(tmp);
				unlink(tempfile);

				if ((g=fopen(tempfile, "w")) == NULL)
				{
					perror(tempfile);
					exit(9);
				}
			}

/*	Extract the username that will receive the message. */

			strcpy(touser, line+4);
		}
		else
		{
			i=0;
			while(*(line + i) != 0)
			{
				if (*(line + i) < ' ')
					*(line + i)=0;
				i++;
			}

			fprintf(g, "%s\n", line);
		}
	}

	fclose(g);

	i=0;
	while(*(touser + i) != 0)
	{
		if (*(touser + i) < ' ')
			*(touser + i)=' ';
		i++;
	}

/*	If there was a message to send, do it. This is
	necessary, since a message is terminated either by the
	"To:"-field of the next message, or an end of file. */

	if (*touser != 0)
	{
		sprintf(tmp, "mail %s < %s", touser, tempfile);
		system(tmp);
	}

/*	Clean up! */

	unlink(tempfile);
	fclose(f);
	unlink(tempfile2);
}

void	main()
{
	char		tmp[160],
			toaddr[160],
			path[160];
	DIR		*dp;
	struct dirent	*de;
	struct stat	*buf;

	if((dp=opendir("/usr/mail/pcsend")) == NULL)
	{
		perror("/usr/mail/pcsend");
		exit(9);
	}

/*	This is the way we are working when we look for mail to send.
	If anybody has a better idea, you can tell me... */

	while((de=readdir(dp)) != NULL)
	{
		strcpy(path, "/usr/mail/pcsend/");
		strcat(path, de->d_name);

		if(strcmp(de->d_name, ".") != 0 &&
			strcmp(de->d_name, "..") != 0 &&
			*de->d_name != '0')
		{
			analyze(path);
		}
	}
}
