;;*****************************************************************************
;;                        dl_ip.inc       dl_ip.inc
;;*****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;****************************************************************************
;;
;; dl_ip.inc is the dispatcher for the dl_ip object.  Basicly all this module 
;; does is look up the name in its database, and based on its name, call the 
;; correct routine for that dl_ip type (ATP, ARP ...).  
;;
;;
;; The functions provided by this file are
;;
;;   DL_IP_DECLARE name, real_dl, type
;;      DL_IP_DECLARE makes the association between the DL_IP object 'name' 
;;      and the object 'real_dl' which acutally supplies the routines.  'type'
;;      is the prefix for the real if (eg.  ARP)
;;   
;;   DL_IP_R_READ name, code_label
;;       DL_IP_R_READ declares that the code starting at 'code_label'
;;       should be called whenever a IP packet is read.  BX:ES is initilized 
;;       to the begining of the IP packet before 'macro_code' is called
;;       The code at 'code_label' should call ARP_DL_IP_R_RETURN when it
;;       is done processing the packet.
;;       This procedure can only be called once per 'name'
;;
;;   DL_IP_R_RETURN name
;;       DL_IP_R_RETURN should be executed by the READ routine to signal
;;       that it is done processing the packet.
;;
;;   DL_IP_R_CONT_in_BX_CX_ES_const_BX_CX_DX_BP_SI_DI_ES name, ok
;;       IF_R_CONT determines if the packet returned by R_READ in BX:ES
;;       of length CX is continuous.  If it is it jumps to 'ok' otherwise
;;       it just returns
;;
;;   DL_IP_W_ACCESS_in_CX_out_DI_ES_const_CX_BP name, fail
;;       DL_IP_W_ACCESS returns a pointer to an output buffer for a IP 
;;       packet.  The pointer is returned in DI:ES.  If the output buffer is 
;;       busy, this routine will block.   The buffer returned is at least
;;       min(CX, dl_&name&_ip_mtu) bytes long.If a buffer could not be accessed
;;       then this routine jumps to 'fail'
;;
;;   DL_IP_W_WRITE_in_AX_CX_const_BP name, broadcast
;;       DL_IP_W_WRITE actually signals the link layer to write a packet to the 
;;       network.  The packet is assumed to be in the buffer returned by 
;;       DL_IP_W_ACCESS.  CX is the length of the packet to send.  AX holds the 
;;       last two bytes of the IP address to send the packet to.  (notice we 
;;       are assuming a host portion of less that 16 bits)
;;       if 'broadcast' is not blank, then the packet is written to the
;;       broadcast address.  AX is ignored in this case
;;
;;   DL_IP_IS_BROADCAST_in_BX_ES_const_AX_BX_CX_DX_BP_DI_ES name
;;      DL_IP_IS_BROADCAST_in_BX_ES determines if the packet pointed to
;;      by BX:ES is a broadcast and sets the zero flag if it is NOT a 
;;      broadcast
;;
;;   DL_IP_COPY_in_CX_SI_DI_ES_out_SI_DI_const_BX_BP_ES name
;;      DL_IP_COPY_in_CX_SI_DI_ES copys a packet from the input buffer (pointed 
;;      to by SI and the segement register given in IF_DECLARE) to an output 
;;      buffer (pointed to by DI and dest_reg) of length CX.   It assumes the
;;      output buffer is contiguous.  (and the caller shouldn't care if the 
;;      input buffer is contiguous)  COPY updates the pointers SI and DI
;;      to the end of the packet, and COPY could be called again if CX is not
;;      the total packet length (Note that CX MUST be even if you care about
;;      SI, and DI being updated properly)
;;
;;
;;  The variables provided by this interface are (READ ONLY)
;;
;;      dl_ip_&name&_ip             the IP address
;;      dl_ip_&name&_mask           the network mask
;;      dl_ip_&name&_net            the network (IP addr bitwize AND ip_mask)
;;      dl_ip_&name&_broad          the network broadcast address
;;      dl_ip_&name&_flags          A word exclusively for IP use
;;      dl_ip_&name&_haddr          The hardware address 
;;      dl_ip_&name&_mtu            the mtu (max trans unit) for this interface
;;      dl_ip_&name&_metric         An interface metric (word for routing)
;;
;;      dl_ip_max_mtu               the max mtu for all DL_IP interfaces
;;      dl_ip_min_mtu               the min mtu for all DL_IP interfaces
;;
;;  The flag masks presently defined
;;      ROUTE_DL_SILENT         ;; don't send routing info out this dl_ip
;;      ROUTE_DL_DEAF           ;; don't listen to routing info from this dl_ip
;;      ARP_PROXY_ARP           ;; do proxy arp for all nets not on this subnet
;;      NO_DIR_BROAD            ;; do not broadcast directed broadcasts
;;      NO_REDIRECT             ;; do not send redirect messages
;;
;;*****************************************************************************
dl_ip_max_mtu   = 1500
dl_ip_min_mtu   = 576           ;; this is an internet mandate

;; flags for the dl_ip_&name&_flags structure.  
ROUTE_DL_SILENT     = (1 shl 0)  
ROUTE_DL_DEAF       = (1 shl 1)  
ARP_PROXY_ARP       = (1 shl 2)  
NO_DIR_BROAD        = (1 shl 3)  
NO_REDIRECT         = (1 shl 4)  
ZERO_BROADCAST      = (1 shl 5)


;;*****************************************************************************
;; DL_IP_DECLARE name, real_routine, type
;;   
DL_IP_DECLARE MACRO name, real_routine, type
    .errb <init_flags>

    dl_&name&_name = real_routine
    dl_&name&_type equ <type>
ENDM

;;******************************************************************************
;;   DL_IP_R_READ name, code
;;       
DL_IP_R_READ MACRO name, code
    HELPER macro myname, type, mycode
        type&&_DL_IP_R_READ myname, mycode
    ENDM

    HELPER  %dl_&name&_name, %dl_&name&_type, code
ENDM

;;******************************************************************************
;; DL_IP_R_CONT_in_BX_CX_ES name, ok
;;
DL_IP_R_CONT_in_BX_CX_ES_const_BX_CX_DX_BP_SI_DI_ES MACRO name, ok
    HELPER macro myname, type, myok
        type&&_DL_IP_R_CONT_in_BX_CX_ES_const_BX_CX_DX_BP_SI_DI_ES name, myok
    ENDM

    HELPER  %dl_&name&_name, %dl_&name&_type, ok
ENDM

;;******************************************************************************
;;   DL_IP_R_RETURN name
;;       
DL_IP_R_RETURN MACRO name
    HELPER macro myname, type
        type&&_DL_IP_R_RETURN myname
    ENDM

    HELPER  %dl_&name&_name, %dl_&name&_type
ENDM

;;******************************************************************************
;;   DL_IP_W_ACCESS_in_CX_out_DI_ES name, fail
;;
DL_IP_W_ACCESS_in_CX_out_DI_ES_const_CX_BP MACRO name, fail
    HELPER macro myname, type, myfail
        type&&_DL_IP_W_ACCESS_in_CX_out_DI_ES_const_CX_BP myname, myfail
    ENDM

    HELPER  %dl_&name&_name, %dl_&name&_type, fail
ENDM

;;******************************************************************************
;;   DL_IP_W_WRITE_in_AX_CX name, broadcast
;;
DL_IP_W_WRITE_in_AX_CX_const_BP MACRO name, broadcast
    HELPER macro myname, type, mybroad
        type&&_DL_IP_W_WRITE_in_AX_CX_const_BP     myname, mybroad
    ENDM

    HELPER  %dl_&name&_name, %dl_&name&_type, broadcast
ENDM

;;******************************************************************************
;;   DL_IP_IS_BROADCAST_in_BX_ES name
;;
DL_IP_IS_BROADCAST_in_BX_ES_const_AX_BX_CX_DX_BP_DI_ES MACRO name
    HELPER macro myname, type
        type&&_DL_IP_IS_BROADCAST_in_BX_ES_const_AX_BX_CX_DX_BP_DI_ES myname, type
    ENDM

    HELPER  %dl_&name&_name, %dl_&name&_type
ENDM

;;******************************************************************************
;;   DL_IP_COPY_in_CX_SI_DI_ES_out_SI_DI_const_BX_BP name

DL_IP_COPY_in_CX_SI_DI_ES_out_SI_DI_const_BX_BP_ES MACRO name
    HELPER macro myname, type
        type&&_DL_IP_COPY_in_CX_SI_DI_ES_out_SI_DI_const_BX_BP_ES myname
    ENDM

    HELPER  %dl_&name&_name, %dl_&name&_type
ENDM


