Program Scribble;

   { A simple utility for drawing with the mouse in graphics mode }

USES mouse, graph;

{$I gmouscur.inc}

CONST  EventMask = $55;       { Any button released, or mouse moved }
       Menu      =  20;                       { bottom of menu area }
       HelpTop   = 185;                          { top of help area }
       Box1      = 160;                { right end of each menu box }
       Box2      = 320;
       Box3      = 480;
       HelpMsg1  = 'Click any button on Scribble to begin drawing';
       HelpMsg2  = 'Hold down left button to draw';

VAR    theMouse : resetRec;
       mouses   : locRec;
{ --------------------------- }

PROCEDURE MenuBox (x1, x2 : INTEGER; Item : STRING);

    { Create a menu box between indicated x's at top of screen }

BEGIN
  SetViewPort (x1+1, 1, x2-1, menu-1, FALSE);  { local to help area }
  ClearViewPort;
  OutTextXY (50, 7, item);                           { display text }
  SetViewPort (0, 0, GetMaxX, HelpTop, FALSE);  { drawing work area }
END;
{ --------------------------- }

PROCEDURE Help (Message : STRING);

    { Display help message at bottom of screen }

VAR    x : INTEGER;

BEGIN
  X := (GetMaxX - TextWidth (message)) DIV 2;       { For centering }
  SetViewPort (1, helpTop+1, 638, GetMaxY - 1, FALSE);
  ClearViewPort;
  OutTextXY (x, 3, message);                   { write help message }
  SetViewPort (0, menu, 639, HelpTop, FALSE);   { drawing work area }
END;
{ --------------------------- }

FUNCTION SetUpScreen : BOOLEAN;

    { Prepare screen, return TRUE if done, FALSE if can't }

VAR    driver, mode : INTEGER;

BEGIN
  Driver := CGA;                              { use CGA hi-res mode }
  Mode   := CGAhi;
  InitGraph (driver, mode, '\TP');              { set graphics mode }
  IF GraphResult = grOK THEN                     { if successful... }
    BEGIN
      SetColor (1);                                    { initialize }
      SetTextStyle (DefaultFont, HorizDir, 1);
      MenuBox (0, box1, 'Scribble');              { make menu boxes }
      Rectangle (0, 0, box1, menu);
      MenuBox (box1, box2, ' Clear');
      Rectangle (box1, 0, box2, menu);
      MenuBox (box2, box3, '  Quit');
      Rectangle (box2, 0, box3, menu);
      Rectangle (box3, 0, 639, menu);               { box for meter }
      Rectangle (0, HelpTop, 639, GetMaxY);          { box for help }
      Help (HelpMsg1);                       { initial help message }
      SetUpScreen := TRUE;                             { successful }
    END
  ELSE
    SetUpScreen := FALSE;                            { unsuccessful }
END;
{ --------------------------- }

PROCEDURE UpdateMeter (x, y : INTEGER);

  { Update mouse position meter in upper right corner of display }

VAR    Position : STRING [8];
       Number   : STRING [3];

BEGIN
  Str (x : 3, number);                 { convert position to string }
  Position := number;
  Str (y : 3, number);
  Position := position + ', ' + number;
  MenuBox (box3, 639, position);                       { display it }
END;
{ --------------------------- }

PROCEDURE Work;

    { Draw with mouse until user clicks on Quit selection }

VAR    thru : BOOLEAN;

BEGIN
  Thru := FALSE;
  REPEAT
    TheEvents.flag := 0;                         { clear event flag }
    REPEAT UNTIL theEvents.flag <> 0;        { wait for mouse event }
    CASE theEvents.flag OF
      $0001: BEGIN                                { mouse has moved }
               IF ((theEvents.row > menu) AND
                   (theEvents.row < HelpTop)) THEN   { in work area }
                 IF theEvents.button = 1 THEN BEGIN { and left down }
                   mHide;
                   PutPixel (theEvents.col, theEvents.row, 1); {draw}
                   mShow;
                 END;
               UpdateMeter (theEvents.col, theEvents.row); { update }
             END;
      $0004,
      $0010,
      $0040: BEGIN                            { any button released }
               IF theEvents.row < menu THEN       { if in menu area }
                 IF theEvents.col < box1 THEN           { Scribble? }
                   BEGIN
                     WITH cross DO
                       mGraphCursor (hotX, hotY, seg (image^),
                                     ofs (image^));
                     Help (HelpMsg2);
                   END
                 ELSE
                   IF theEvents.col < box2 THEN            { Clear? }
                     BEGIN
                       mHide;
                       SetViewPort (0, menu+1, GetMaxX,
                                    helpTop-1, TRUE);
                       ClearViewPort;
                       mShow;
                       WITH hand DO
                         mGraphCursor (hotX, hotY, seg (image^),
                                       ofs (image^));
                       Help (HelpMsg1);
                     END
                   ELSE
                     IF theEvents.col < box3 THEN           { Quit? }
                       thru := true;
             END;  { of outer IF }
    END;  { of CASE }
  UNTIL thru;
END;
{ --------------------------- }

BEGIN
  InitGCurs;                             { Initialize cursor images }
  mReset (theMouse);                             { Initialize mouse }
  IF theMouse.exists THEN
    BEGIN
      theEvents.flag := 0;
      IF SetUpScreen THEN                  { if in graphics mode... }
        BEGIN
          mInstTask (EventMask, seg (EventHandler),
                     ofs (EventHandler));         { install handler }
          WITH hand DO                         { show pointing hand }
            mGraphCursor (hotX, hotY, seg (image^), ofs (image^));
          mShow;
          mPos (mouses);                       { Get mouse position }
          UpdateMeter (mouses.column, mouses.row);
          Work;                          { do what the program does }
          mReset (theMouse);                  { shut down the mouse }
          CloseGraph;                           { back to text mode }
        END
      ELSE
        WRITELN ('Graphics mode not available. Program ended.');
    END
  ELSE
    WRITELN ('Mouse not active. Program ended.');
END.
