;
;   Coswitch for Icon V8.5 running in 32-bit protected mode
;   with Zortech C++.
;
;   Author:  Robert Goldberg
;
;   Note: Assemble with PharLap assembler and -twocase switch to
;   preserve lower-case public names (important for Intel linker).
;
;   Coswitch algorithm in C:
;
;   coswitch( old_cs, new_cs, first )
;   int	*old_cs, *new_cs, first;
;   {
;	/* save SP, frame pointers, and other registers in old_cs */
;	if ( first == 0 )
;	{
;	    /* load sp from new_sp[0] and clear frame pointers */
;	    new_context( 0, 0 );
;	    syserr( "new_context() returned in coswitch" );
;	}
;	else
;	{
;	    /* load sp, frame pointers and other registers from new_cs */
;	}
;   }
;
;   Define external functions:
;
	extrn	_new_context:near
	extrn	_syserr:near
;
;   Define error message in appropriate segment and group.
;
dgroup	group	asmdata
	assume	ds:dgroup
	public	errormsg
asmdata	segment	dword public 'DATA'
errormsg db	'new_context() returned in coswitch',0
asmdata	ends
;
;   Define function coswitch in appropriate segment and group.
;
cgroup	group	asmcode
	assume	cs:cgroup
asmcode	segment	dword 'CODE'
	public	_coswitch
	db	'_coswitch',8
_coswitch    proc    near
;
;   Save environment at point of call.
;
;   According to MetaWare's documentation (Chapter 9 - Run-Time Organization)
;   registers EAX, ECX, EDX, FS, GS, and sometimes ES are volatile.  So, a
;   function must preserve registers EBP, ESI, EDI, and EBX across calls.
;   So, save all these registers plus ESP in area pointed to by old_cs.
;
	mov	edx,4[esp]	    ; point to old_cs
	mov	0[edx],esp	    ; save esp
	mov	4[edx],ebp	    ; save ebp
	mov	8[edx],esi	    ; save esi
	mov	12[edx],edi	    ; save edi
	mov	16[edx],ebx	    ; save ebx
;
;   Check first flag to see if first activation of this coexpression.
;
	mov	eax,12[esp]	    ; load first flag
	or	eax,eax		    ; set condition flags
	jnz	notzero		    ; jump if not zero
;
;   First is 0 -
;
;   Set things up for first activation of this coexpression.
;
	mov	edx,8[esp]	    ; point to new_cs area
	mov	esp,0[edx]	    ; set ESP from new_cs
	mov	ebp,esp		    ; set EBP equal to ESP (can't hurt?)
	xor	eax,eax		    ; get a zero
	mov	esi,eax		    ; clear ESI
	mov	edi,eax		    ; clear EDI
	push	eax		    ; push two zeros
	push	eax		    ;   onto stack
	call	_new_context	    ; new_context(0,0) - should not return!
	push	offset errormsg	    ; push offset to error messgae
	call	_syserr		    ; terminate with error
;
;   First is not 0 -
;
;   Restore environment from new_cs.
;
notzero:
	mov	edx,8[esp]	    ; point to new_cs
	mov	esp,0[edx]	    ; restore esp
	mov	ebp,4[edx]	    ; restore ebp
	mov	esi,8[edx]	    ; restore esi
	mov	edi,12[edx]	    ; restore edi
	mov	ebx,16[edx]	    ; restore ebx
	ret			    ; return
_coswitch    endp
asmcode	ends
	end
