/*
 * tsrcfls - routines to create list of source files to be translated.
 */
#include "../h/gsupport.h"
#include "trans.h"
#include "tree.h"
#include "tcode.h"
#include "tsym.h"
#include "tproto.h"

/*
 * The following code is operating-system dependent [@tsrcfls.01].  It includes
 *  files that are system dependent.
 */

#if PORT
   /* nothing is needed */
Deliberate Syntax Error
#endif					/* PORT */

#if AMIGA || ATARI_ST || MACINTOSH || VMS
   /* nothing is needed */
#endif					/* AMIGA || ATARI_AT || ... */

#if MSDOS
#if MICROSOFT
#include <sys/types.h>
#include <sys/stat.h>
#endif					/* MICROSOFT */
#if TURBO
#include <sys/stat.h>
#endif					/* TURBO */
#endif					/* MSDOS */

#if MVS || VM
#if SASC
#include <fcntl.h>
#else					/* SASC */
#include <file.h>
#endif					/* SASC */
#endif					/* MVS || VM */

#if OS2
#if MICROSOFT
#include <sys/types.h>
#include <sys/stat.h>
#endif					/* MICROSOFT */
#endif					/* OS2 */

#if UNIX
#ifndef ATT3B
#include <sys/types.h>
#include <sys/stat.h>
#endif					/* ATT3B */
#endif					/* UNIX */

/*
 * End of operating-system specific code.
 */

/*
 * Prototypes.
 */
hidden int chkread Params((char *dir, char *file));

struct srcfile *srclst = NULL;

static char **pathlst;     /* list of paths from LPATH */

/*
 * init_lnk - set things up to handle link directives.
 */
novalue init_src()
   {
   char *lpath;
   char *sbuf;
   char *s;
   int n_paths;
   int i;

#ifdef EnvVars
   lpath = getenv("LPATH");
#else					/* EnvVars */
   lpath = NULL;
#endif					/* EnvVars */

   if (lpath == NULL)

/*
 * The following code is operating-system dependent [@tsrcfls.02].  Set
 *  default for LPATH.
 */

#if PORT
   /* something is needed */
Deliberate Syntax Error
#endif					/* PORT */

#if AMIGA
   /*
    * There is no environment, so set lpath to the null string. The
    *  current directory is searched anyway and there is no symbol
    *  to force current path search.
    */
      lpath = "";
#endif					/* AMIGA */

#if ATARI_ST || UNIX
      lpath = ".";
#endif					/* ATARI_ST || UNIX */

#if MSDOS || OS2
      lpath = ";";
#endif					/* MSDOS || OS2 */

#if MACINTOSH
#if MPW || LSC
      lpath = ":";
#endif					/* MPW || LSC */
#endif					/* MACINTOSH */

#if MVS || VM
      lpath = "";
#endif					/* MVS || VS */

#if VMS
      lpath = "[]";
#endif					/* VMS */

/*
 * End of operating-system specific code.
 */

   /*
    * Create an array of paths.
    */
   n_paths = 0;
   s = lpath;
   for (;;) {
      while (*s == ' ')
         s++;
      if (*s == '\0')
         break;
      ++n_paths;
      while (*s != '\0' && *s != ' ')
         ++s;
      }
   pathlst = (char **)alloc((unsigned int)(sizeof(char *) * (n_paths + 1)));
   sbuf = (char *)alloc((unsigned int)(strlen(lpath) + 1 + n_paths));

   i = 0;
   s = lpath;
   for (;;) {
      while (*s == ' ')
         ++s;
      if (*s == '\0')
         break;
      pathlst[i++] = sbuf;
      while (*s != '\0' && *s != ' ')
         *sbuf++ = *s++;

/*
 * The following code is operating-system dependent [@tsrcfls.03]. Append path
 *  character.
 */

#if PORT
      /* nothing is needed */
Deliberate Syntax Error
#endif					/* PORT */

#if AMIGA
      sbuf--;
      switch (*sbuf) {
   
         case ':':
         case '/':
                    sbuf++;
                    break;       /* add nothing, delimiter already there */
         default:
                    *sbuf++ = '/';
         }
#endif					/* AMIGA */

#if ATARI_ST || MACINTOSH || MVS || VM || VMS
      /* nothing is needed */
#endif					/* ATARI_ST || MACINTOSH */

#if UNIX || MSDOS || OS2
#if HIGHC_386
      *sbuf++ = '\\';
#else					/* HIGHC_386 */
      *sbuf++ = '/';			/* should check for delimiter */
#endif					/* HIGHC_386 */
#endif					/* UNIX || MSDOS || OS2 */

      *sbuf++ = '\0';
      }

   pathlst[i] = NULL;
   }

/*
 * lnkdcl - determine where the named file is on the path specified in
 *   the PATH environment variable and add the file to the list of
 *   files to be processed.
 */
novalue lnkdcl(name)
char *name;
   {
   struct fileparts *fp;
   char **dir_p;

   if (chkread(SourceDir, name))
      return;

   fp = fparse(name);		/* parse file name */
   if (*fp->dir == '\0') {
      /*
       * No directory included in name, try search path.
       */
      for (dir_p = pathlst; *dir_p != NULL; ++dir_p) {
         if (chkread(*dir_p, name))
            return;
         }
      }

   tfatal("cannot resolve reference to file name", name);
   }

/*
 * chkread - see if file can be read and be sure that it's just an
 *  ordinary file. If so add it to the list of files to be translated.
 */
static int chkread(dir, name)
char *dir;
char *name;
   {
   char buf[MaxFileName];		/* file name construction buffer */

   makename(buf, dir, name, SourceSuffix);

/*
 * The following code is operating-system dependent [@tsrcfls.04]. Check to
 *   see if source file can be read.
 */

#if PORT
   /* something is needed */
Deliberate Syntax Error
#endif					/* PORT */

#if AMIGA
   if (access(buf,4) == 0)
      if (getfa(buf) != -1)
         return 0;
   else
      return 0;
#endif					/* AMIGA */

#if ATARI_ST
   {
   FILE *f;
   if ((f = fopen(buf, ReadText)) == NULL)
      return 0;
   else
      fclose(f);
   }
#endif					/* ATARI_ST */

#if MACINTOSH
#if MPW || LSC
   {
   FILE *f;
   if ((f = fopen(buf,ReadText)) == NULL)
      return 0;
   else
      fclose(f);
   }
#endif					/* MPW || LSC */
#endif					/* MACINTOSH */

#if MSDOS
#if HIGHC_386 || INTEL_386 || ZTC_386 || WATCOM
   {
   FILE *f;
   if ((f = fopen(buf, ReadText)) == NULL)
      return 0;
   else
      fclose(f);
   }
#endif					/* HIGHC_386 || INTEL_386 || ... */
#if MICROSOFT || TURBO
   {
   struct stat statb;
   if (access(buf,4) == 0) {
      stat(buf,&statb);
      if (!(statb.st_mode & S_IFREG))
         return 0;
      }
   else
      return 0;
   }
#else					/* MICROSOFT || TURBO */
   if (access(buf, 4 ) != 0)
      return 0;
#endif					/* MICROSOFT || TURBO */
#endif					/* MSDOS */

#if MVS || VM
   {
   FILE *f;			/* can't use access because it will */
				/* accept LRECL, etc. */

   if ((f = fopen(buf,"r")) == NULL
      return 0;
   else
      fclose(f);
   }
#endif					/* MVS || VM */

#if OS2
#if MICROSOFT
   {
   struct stat statb;
   if (access(buf,4) == 0) {
      stat(buf,&statb);
      if (!(statb.st_mode & S_IFREG))
         return 0;
      }
   else
      return 0;
   }
#endif					/* MICROSOFT || TURBO */
#endif					/* OS2 */

#if UNIX
   {
   struct stat statb;
   if (access(buf,4) == 0) {
      stat(buf,&statb);
      if (!(statb.st_mode & S_IFREG))
         return 0;
      }
   else
      return 0;
   }
#endif					/* UNIX */

#if VMS
   if (access(buf,4) != 0)
      return 0;
#endif					/* VMS */

/*
 * End of operating-system specific code.
 */

   src_file(buf);
   return 1;
   }

/*
 * src_file - add the file name to the list of source files to be translated,
 *   if it is not already on the list.
 */
novalue src_file(name)
char *name;
   {
   struct srcfile **pp;
   struct srcfile *p;

   for (pp = &srclst; *pp != NULL; pp = &(*pp)->next)
     if (strcmp((*pp)->name, name) == 0)
        return;
   p = NewStruct(srcfile);
   p->name = salloc(name);
   p->next = NULL;
   *pp = p;
   }
