/*
 *                   XSPAWN
 *                Version 1.33
 *  (C) Copyright 1990 Whitney Software, Inc.
 *             All Rights Reserved
 */

#include <stdio.h>
#include <stdlib.h>
#ifndef LATTICE
#include <io.h>
#endif
#include <errno.h>
#include "xspawnp.h"

int xsystem( command )
char *command;                   /* command to be passed to COMMAND.COM */
{
    char *argv[ 4 ];
    int rc;

    *argv = getenv( "COMSPEC" );

    if ( command == NULL )
    {
        if ( *argv != NULL && !access( *argv, 0 ))
            return( 1 );
        else
        {
            errno = ENOENT;
            return( 0 );
        }
    }

    argv[ 1 ] = "/c";
    argv[ 2 ] = command;
    argv[ 3 ] = NULL;

    if ( *argv != NULL )
    {
        if (( rc = xspawnve( P_WAIT, *argv, argv, NULL )) != -1 ||
            errno != ENOENT )
        {
            return( rc );
        }
    }

    *argv = "command.com";

    return( xspawnvpe( P_WAIT, *argv, argv, NULL ));
}
