;; UMB_GWJ.ASM
;; Upper Memory Manager for MS-DOS
;; version 1.0
;; Copyright (C) 1993  Grzegorz W. Jablonski
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;
;; To contact the author about changes, enhancements, bug reports, or
;; other comments, send electronic mail to:
;;
;;      gwj@j-23.p.lodz.pl (from Internet sites)
;;
;; If you are unable to contact the author through electronic mail,
;; try sending a letter (as a last resort, only) to the following address:
;;
;;      Grzegorz W. Jablonski
;;      ul. Lanowa 6B m 64
;;      91-103 Lodz
;;      POLAND
;;
;; Please note that mail sent to this address may not yield a response
;; for several months!
;;

.286p
LOCALS

grupa           group   seg_a,seg_b,seg_c

seg_a           segment byte public
		assume  cs:seg_a, ds:nothing
		org     0

rh              struc      ; request header
len             db      ?
dev             db      ?
cmd             db      ?
status          dw      ?
rsvd            dq      ?
ct              db      ?
aoff            dw      ?
aseg            dw      ?
dptr            dd      ?
rh              ends


umbdvr          proc    far
loc_3:
header          dd      0FFFFFFFFh
attributes      dw      8000h
pointers        dw      offset strategy
		dw      offset commands
char_dev        db      '$'
		db      'UMBXXX0'
req_addr        dw      ?,?    ;request packet address
umbdvr          endp

begn            equ     0
lgth            equ     2

strategy        proc    far
		mov     cs:req_addr,bx
		mov     word ptr cs:req_addr+2,es
		retf
strategy        endp

commands        proc    far
		push    ds
		push    es
		pusha
		lds     bx,dword ptr cs:req_addr
		cmp     byte ptr [(rh ptr bx).cmd],0
		jne     noinit
		call    initproc
return:
		popa
		pop     es
		pop     ds
		retf
commands        endp

noinit:
		mov     word ptr [(rh ptr bx).ct],0
		mov     word ptr [(rh ptr bx).status],810Ch
		jmp     short return
seg_a           ends

seg_b           segment
		assume  cs:seg_b,ds:nothing,es:nothing

move_beg:       db 32 DUP(?) ;reserve space for DOS memory block header

;XMS services
xms_entry:      pushf
		cmp     ah,0
		jne     noxmsver
;get XMS version
ifdef DEBUG
		mov     dx,offset versionreq
		call    displayText
endif
		mov     ax,200h
		mov     bx,ax
		xor     dx,dx
		popf
		retf
noxmsver:       push    di
		push    si
		cmp     ah,10h
		je      noumbreq
;function not implemented - uninstall
;possible lack of DOS=UMB line in CONFIG.SYS
ifdef DEBUG
		mov     dx,offset notimpl
		call    displayText
endif
		cmp     [cs:byte ptr uninstalled],0
		jne     ret_xms ;we were uninstalled already
		mov     dx,offset noumb
		call    displayText
		xor     ax,ax
		mov     bl,80h
		jmp short deinst

maxblock        equ     10 ;maksimum number of UMB blocks
;UMB request
noumbreq:
		mov     ax,word ptr [cs:left]
		mov     si,offset data
		dec     ax
		shl     ax,2
		add     si,ax
		mov     di,cs:[si+lgth]
		cmp     di,dx
		jb      tooltl
ifdef DEBUG
		mov     dx,offset umbsuccess
		call    displayText
endif
		mov     dx,di
		mov     bx,cs:[si+begn]
		mov     ax,1
		dec     word ptr cs:[left]
		jmp     short   ret_xms
tooltl:         mov     dx,di
		xor     ax,ax
		cmp     byte ptr cs:[left],0
		jz      lack
ifdef DEBUG
		push    dx
		mov     dx,offset umbtosmall
		call    displayText
		pop     dx
endif
		mov     bl,0b0h
		jmp     short   ret_xms
lack:          mov     bl,0b1h
		xor     dx,dx
		jmp     short   deinst

ret_xms:        pop     si
		pop     di
		popf
		retf
;XMS uninstallation
deinst:         cmp [cs:byte ptr uninstalled],1
		je      short ret_xms
		inc [cs:byte ptr uninstalled]
		push    ax
		push    dx
		push    ds
		lds     dx,dword ptr [cs:old2f]
		mov     ax,252Fh
		int     21h   ;set 2Fh interrupt vector                    
		pop     ds  
ifdef DEBUG
		mov     dx,offset deinstTxt
		call    displayText
endif
		pop     dx
		pop     ax
		jmp     short ret_xms

int2f_entry:    pushf
		push    dx
ifdef DEBUG
		mov     dx,offset int2fcall
		call    displayText
endif
		pop     dx
		cmp     ah,43h ;mutliplex interrupt for XMS
		jne     not_for_us
		cmp     al,0
		jne     no_xms_install
;is XMS installed?
ifdef DEBUG
		push    dx
		mov     dx,offset XMSinstalled
		call    displayText
		pop     dx
endif
		mov     al,80h
		popf
		iret
no_xms_install:
		cmp     al,10h
		jne     not_for_us
;XMS program entry point address request
ifdef DEBUG
		push    dx
		mov     dx,offset XMSaddrreq
		call    displayText
		pop     dx
endif
		mov     bx,cs
		mov     es,bx
		mov     bx,offset seg_b:xms_entry
		popf
		iret
not_for_us:
		popf
		jmp     dword ptr [cs:seg_b:old2f]
;display text pointed by cs:dx
displayText     proc    near
		push    ds
		push    cs
		pop     ds
		push    ax
		mov     ah,9
		int     21h
		pop     ax
		pop     ds
		ret
displayText     endp

old2f:          dd      ?
block_num:     dw      2
data:           dd      maxblock dup(?)
left:    dw      0h
uninstalled:    db      0h
ifdef DEBUG
deinstTxt:      db 13,10,'Int2F handler uninstalled.'
		db 13,10,'$'
versionreq:     db 13,10,'Version number requested.'
		db 13,10,'$'
umbsuccess:     db 13,10
		db 'UMB address returned successfully.'
		db 13,10,'$'
umbtosmall:     db 13,10,'Smaller UMB available.',13,10,'$'
XMSaddrreq:     db 13,10,'XMS entry address returned.'
		db 13,10,'$'
XMSinstalled:   db 13,10,'XMS installation state polling.'
		db 13,10,'$'
notimpl:        db 13,10,'XMS function not implemented'
		db 13,10,'$'
int2Fcall:      db 13,10,'int 2F called',13,10,'$'
endif
noumb:          db 13,10,"Don't install this program "
		db 'without dos=umb line in CONFIG.SYS'
		db 13,10,'$'

move_end:
seg_b           ends

seg_c           segment
		assume  cs:grupa,ds:grupa
initproc        proc    near
		mov     bp,sp
		cld

		push    cs
		pop     ds

		mov     ah, 9
		mov     dx, offset grupa:eHello
		int     21h

		mov     ax,3306h
		int     21h     ; get DOS version
		jc      wrongDOS
		cmp     bl,5
		jb      wrongDOS
		cmp     bl,0Ah
		jb      skip1
wrongDOS:
		mov     dx,offset grupa:DOSnrTxt
		mov     ah,9
		int 21h
		jmp  finish
xmsinst:
;XMS already installed
		mov     dx,offset grupa:XMSinstTxt
		mov     ah,9
		int 21h
		jmp  finish
skip1:
		mov     ax,4300h
		int     2Fh ;is XMS server installed?
		cmp     al,80h
		je      xmsinst
		call    lexer
		jnc     @@1
		jmp     errr
@@1:
;check for space for resident part
;the last bytes are text - may be overwritten by DOS memory block header
		mov     cx,offset move_end-move_beg
		mov     ax,word ptr [grupa:data+lgth]
		add     cx,15
		shr     cx,4
		cmp     cx,ax
		jna     @@2
		jmp     block2small
@@2:
		;initialize left and enable SHADOW-RAM
		mov     ax,word ptr [grupa:block_num]
		mov     word ptr [grupa:left],ax
		mov     si,offset grupa:data
blocks_loop:   push     ax
		mov     bx,word ptr [si+begn] 
		;in bx segment address of block
		mov     dx,[si+lgth] 
		;in dx block length in paragraphs
		add     dx,bx
		and     dx,7fffh
		;;enable proper shadow ram
		and     bx,7fffh
		shr     bx,10
		; bx - first block number
round:          mov     ah,42
		mov     al,15
		;set block attributes - r/w + cache
		call    poke
		mov     ah,41
		mov     al,bl    ;which blok
		call    poke
		mov     ah,40
		mov     al,195   
		;pass parameters to chipset
		call    poke
		inc     bx
		mov     ax,bx
		shl     ax,10
;in ax - first not enabled block of SHADOW-RAM address with MSB reset
		cmp     ax,dx
		jb      round
		;;SHADOW-RAM enabled
		pop     ax
		inc     si
		inc     si
		inc     si
		inc     si
		dec     ax
		jne     blocks_loop

		mov     ax,352fh
		int     21h ;get 2fh vector
		mov     word ptr [grupa:old2f],bx
		mov     word ptr [grupa:old2f+2],es

		mov     ax,word ptr [grupa:data+begn]
		mov     es,ax
		xor     di,di
		mov     cx,offset move_end-move_beg
		mov     si,offset grupa:move_beg
		;mov XMS procedures to UMB
		rep     movsb

		mov     dx,offset seg_b:int2f_entry
		mov     ax,word ptr [grupa:data+begn]
		mov     ds,ax
		mov     ax,252Fh
		int     21h  ;set 2Fh vector 
finish:          lds     bx,dword ptr cs:req_addr
		mov     word ptr [(rh ptr bx).aoff],0
		mov     [(rh ptr bx).aseg],cs
		mov     word ptr [(rh ptr bx).status],100h
		ret
errr:           mov     dx,offset grupa:syntax
		mov     ah,9
		int     21h
		jmp short       finish
block2small:
		mov     dx,offset grupa:toosmall
		mov     ah,9
		int     21h
		jmp     short finish
initproc        endp

lexer           proc    near
		push      ds
		;lexical analyser
		lds     bx,dword ptr cs:req_addr 
		lds     si, [(rh ptr bx).dptr] 
		; ds:si = command line arguments
		cld

s0:             lodsb                           
		; stan 0, skip filename
		call    eol
		je      short @@badch
		call    blank
		jne     short s0

		mov cx,0        ;block counter
		mov di,offset grupa:data
blockl:

s1:             lodsb                           
		; state1, skip whitespace
		call    eol
		je      short done
		call    blank
		je      short s1

		call    getseg
		jc      @@badch
		mov     word ptr cs:[di+begn],bx
		lodsb
		cmp     al,'-'
		jne     @@badch
		lodsb
		call    getseg
		jc      @@badch
		mov     ax,word ptr cs:[di+begn]
		sub     bx,ax
		mov     word ptr cs:[di+lgth],bx
		inc cx
		inc di
		inc di
		inc di
		inc di
		cmp     cx,maxblock
		je      done
		jmp     short blockl
done:
		cmp     cx,0
		je      @@badch
		pop     ds
		mov word ptr cs:[grupa:block_num],cx
		clc
		ret


@@badch:        pop     ds    ;wrong character
		stc
		ret

lexer           endp

;get segment address from command line
getseg          proc    near
		call    hex0f
		ja      short @@badch
		mov     bh, al
		lodsb   ; get second hexadecimal digit
		call    hex0f
		ja      short @@badch
		shl     bh, 4
		or      bh, al
		xor     bl, bl
		lodsb   ; get third hexadecimal digit
		call    hex0f
		ja      short   @@badch
		mov     bl,al  
		lodsb   ; get fourth hexadecimal number
		call    hex0f
		ja      short   @@badch
		shl     bl,4
		or      bl,al
		clc
		ret
@@badch:
		stc
		ret
getseg          endp

;check for eol
eol             proc    near
		cmp     al, 13
		je      short @@1
		cmp     al, 26
@@1:            ret
endp

;check if space or tab
blank           proc    near
		cmp     al, 32
		je      short @@1
		cmp     al, 9
@@1:            ret
endp

;check, if al is hexadecimal digit
hex0f           proc    near
		sub     al,'0'
		cmp     al,9
		ja      @@1
		ret
@@1:            add     al,'0'
		or      al, 32
		sub     al, 'a'
		cmp     al, 5
		jna     @@2
		ret
@@2:            add     al,10
		cmp     al,15
		ret
endp

poke            proc    near
		push    ax
		mov     al,ah
		out     40,al
		pop     ax
		out     36,al
		ret
poke            endp

eHello:         db      13,10
		db      '(c) 1993-11-07 Grzegorz Jablonski'
		db      13,10
		db      'UMB driver version 1.0 '
		db      'for HT-320 chipset.',13,10
		db      "If you haven't done so,",13,10
		db      'enable proper shadows in SETUP or '
		db      'disable remapping.',13,10
		db      '$'
syntax:         db      'Syntax error - '
		db      'driver NOT installed.',13,10,'$'
toosmall:       db      'First declared UMB is too small - '
		db      'driver NOT installed.',13,10,'$'
XMSinstTxt:     db      13,10,'XMM already installed - '
		db      'driver NOT installed.',13,10,'$'
DOSnrTxt:       db      13,10,'This program requires '
		db      'DOS 5.00 or higher - driver NOT '
		db      'installed.',13,10,'$'
end_prog:
seg_c           ends
end
