;; redxms.asm
;; Reduce extended memory size
;; Copyright (C) 1993  Grzegorz W. Jablonski
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;
;; To contact the author about changes, enhancements, bug reports, or
;; other comments, send electronic mail to:
;;
;;      gwj@j-23.p.lodz.pl (from Internet sites)
;;
;; If you are unable to contact the author through electronic mail,
;; try sending a letter (as a last resort, only) to the following address:
;;
;;      Grzegorz W. Jablonski
;;      ul. Lanowa 6B m 64
;;      91-103 Lodz
;;      POLAND
;;
;; Please note that mail sent to this address may not yield a response
;; for several months!
;;
;; This program is to be used together with UMB_GWJ.SYS to decrease
;; reported entended memory size

	ideal                           ; Use TASM Ideal mode syntax
	p286n                           ; Assemble for the 80286 (real mode)
	locals  $$                      ; local labels preceded by '$$'

extsiz  equ     3200                    ; size of extended memory after change

rhds    equ     (rh ds:si)
rhes    equ     (rh es:di)

struc   rh                              ; request header
len     db      ?
dev     db      ?
cmd     db      ?
st      dw      ?
rsvd    dq      ?
ct      db      ?
aoff    dw      ?
aseg    dw      ?
dptr    dd      ?
ends

segment redxms    use16                   ; low-memory resident segment

devhdr  dd      -1                      ; device header
devflg  dw      0a000h
devstr  dw      redxmsstr
devint  dw      redxmsint0
devnam  db      'REDXMSX0'

label   rhptr   dword                   ; pointer to request header
rhoff   dw      ?
rhseg   dw      ?

label           OrgIntr15 dword         ; old interrupt function pointer
int15off        dw       ?
int15seg        dw       ?

proc    redxmsstr far                     ; strategy routine
	assume  cs:redxms

	mov     [redxms:rhoff], bx
	mov     [redxms:rhseg], es
	ret
endp

proc    redxmsint far                     ; resident interrupt routine
	assume  cs:redxms

	push    si                      ; save registers
	push    ds
	lds     si, [redxms:rhptr]        ; ds:si = request header
	mov     [rhds.st], 8103h        ; return error (unknown command)
	pop     ds                      ; restore registers
	pop     si
	ret
endp

proc    intr15  far
	assume  cs:redxms

	cmp     ah,88h
	je      $$1
	jmp     [redxms:OrgIntr15]
$$1:    mov     ax,extsiz
	iret
endp    intr15


label   endres  unknown

oldss   dw      ?
oldsp   dw      ?

proc    rpopf   near    ; for reliable popf
	iret
endp    rpopf

proc    redxmsint0 far                    ; initial interrupt routine
	assume  cs:redxms, ds:redxms

	pushf                           ; save flags
	push    cs
	pusha                           ; save registers
	push    ds
	push    es
	push    cs
	pop     ds
	les     di, [rhptr]             ; es:di = request header
	mov     [rhes.st], 8103h        ; assume error (unknown command)
	mov     al, [rhes.cmd]          ; only cmd 0, INIT is legal
	or      al, al
	jnz     short $$1
	call    init

$$1:    pop     es                      ; restore registers
	pop     ds
	popa
	call    rpopf                   ; restore flags before returning
	ret
endp

proc    init    near                    ; initialize driver
	assume  cs:redxms, ds:redxms

	mov     [oldss], ss             ; save old stack
	mov     [oldsp], sp
	mov     bx, ds
	mov     ss, bx                  ; enable new stack
	mov     sp, offset stktop
	push    es
	xor     ax,ax
	mov     es,ax
	cli
	mov     ax,[es:4*15h]
	mov     [int15off],ax
	mov     ax,[es:4*15h+2]
	mov     [int15seg],ax
	mov     ax,offset intr15
	mov     [es:4*15h],ax
	mov     ax,cs
	mov     [es:4*15h+2],ax
	mov     al,52h
	out     22h,al
	mov     al,0bfh
	out     23h,al
	sti
	mov     ah,52h
	int     21h
	add     bx,45h          ; [es:bx] - extended memory size in kB
	mov     [es:bx],extsiz
	pop     es
	mov     [devint], offset redxmsint; enable resident interrupt routine
	mov     [rhes.aseg], cs         ; discard initialization section
	mov     [rhes.aoff], offset endres
	mov     [rhes.st], 0100h        ; return success code
	mov     ss, [oldss]             ; restore old stack
	mov     sp, [oldsp]
	ret
endp
	align   4                       ; start stack on dword boundary

stkbot  db      512 dup (?)             ; initialization stack
label   stktop  word

ends    redxms
	end
