; ramtest -- a memory test program
; Copyright (C) 1999  Stefan Ziegenbalg
; 
; This program is free software; you can redistribute it and/or  
; modify it under the terms of the GNU General Public License as 
; published by the Free Software Foundation; either version 2 of 
; the License, or (at your option) any later version.
;  
; This software is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
; General Public License for more details.
;  
; You should have received a copy of the GNU General Public
; License along with this program; if not, write to the 
; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
; Boston, MA  02111-1307, USA.


; undefined jump behaviour in masm:  a...b in labels
;
; routines from numstr.inc are required
;
ints macro oo
         push ax
 if ('&oo' eq 'off')
         cli
         mov al,80h
         out 70h,al
  endif
 if ('&oo' eq 'on')
         sti
         mov al,0
         out 70h,al
  endif
         pop ax
 endm
;********************************************************************
;******************************************** XMS driver ... , A20...
;********************************************************************
xmsaddr dd 0

init_xms proc
        push ax
        push bx
        push es
         mov ax,4300h                            ; driver ?
         int 2fh
         cmp al,80h
         jnz erra1
         mov ax,4310h                            ; XMS driver addres
         int 2fh
         mov word ptr cs:[xmsaddr],bx
         mov word ptr cs:[xmsaddr+2],es
        pop es
        pop bx
        pop ax
         ret
mesa1    db 'cant find XMS-driver',10,13,'$'
erra1:   mov dx,offset mesa1
         mov ah,9
         push cs
         pop ds
         int 21h
         mov ax,4c01h
         int 21h
init_xms endp


a20 macro oo
         push ax
 if ('&oo' eq 'off')
         mov ah,6
         call dword ptr cs:[xmsaddr]
  endif
 if ('&oo' eq 'on')
         mov ah,5
         call dword ptr cs:[xmsaddr]
  endif
         pop ax
 endm


meminfo proc
         jmp start
hand     dw 0
siz      dd 0
imes1    db 'Handle         Begin                 End                Size',13,10,'$'
imes2    db 12 dup(' ')
imes3    db 8 dup('0'),' ('
imes3a   db 3 dup(' '),'M)     '
imes4    db 8 dup('0'),' ('
imes4a   db 3 dup(' '),'M)     '
imes5    db 8 dup('0'),' ('
imes5a   db 3 dup(' '),'M)',13,10,'$'

start:  pusha
        push ds
         writemes imes1

         xor ax,ax
         mov hand,ax

lb1:     mov dx,hand
         mov ah,0eh
         call dword ptr cs:[xmsaddr]
         cmp ax,1
         jz jb1
         cmp ax,0
         jnz errb1
         cmp bl,0a2h  ; invalid handle
         jz jb2
         jmp errb1
jb1:     cmp dx,0
         jz jb2
         xor eax,eax
         mov ax,dx
         shl eax,10
         mov siz,eax
         mov dx,hand
         mov ah,0ch
         call dword ptr cs:[xmsaddr]
         cmp ax,1
         jz jb3
         cmp ax,1
         jnz errb1
         cmp bl,0a2h  ; invalid handle
         jz jb2
         cmp bl,0ach  ; block lock count overflowed
         jz jb2
         cmp bl,0adh  ; lock failed
         jz jb2
         jmp errb1
jb3:     mov ax,dx
         shl eax,16
         mov ax,bx
        push eax
         mov ah,0dh
         mov dx,hand
         call dword ptr cs:[xmsaddr]
         cmp ax,1
         jnz errb1
        pop eax
         invoke dw2hexstr, eax, offset imes3
         mov ebx,eax
         shr ebx,20
         invoke w2decstr, bx, offset imes3a, 3
         add eax,siz
         dec eax
         invoke dw2hexstr, eax, offset imes4
         inc eax
         shr eax,20
         invoke w2decstr,ax,offset imes4a, 3
         mov eax,siz
         invoke dw2hexstr, eax, offset imes5
         shr eax,20
         invoke w2decstr, ax, offset imes5a, 3
         invoke w2decstr, hand, offset imes2,6
         writemes imes2

jb2:     inc hand
         jnz lb1
        pop ds
        popa
         ret

mesb1    db 'XMS error',10,13,'$'
errb1:   mov dx,offset mesb1
         mov ah,9
         push cs
         pop ds
         int 21h
         mov ax,4c01h
         int 21h
meminfo endp
