
PAGE 60, 132
TITLE High Resolution Timer
NAME  HiResTimer
.386

_TEXT SEGMENT PUBLIC DWORD USE32 'CODE'
ASSUME CS:_TEXT, DS:nothing, SS:nothing
SS_DOSMEM = 34h

PUBLIC SetHiResTimer,GetHiResTimer,GetMilliSec

;Ŀ
; Descr: sets timer 1 to update 65535*18.2 per second (1.193180 MHz)         
;        Does not affect INT 8 or memory refresh rate                        
; Input:  None                                                               
; Output: None                                                               
; Regs changed: EAX                                                          
;

SetHiResTimer:
        mov al,00110100b           ; timer 1 in mode 2
        out 43h,al
        mov al,0
        out 40h,al
        out 40h,al
        ret

;Ŀ
; Descr:  return timer value as DWORD in EAX (actually only 6 bytes)         
; Input:  None                                                               
; Output: EAX                                                                
; Regs changed: EBX                                                          
;

GetHiResTimer:
        xor eax,eax                ; clear result
        out 43h,al                 ; latch counter 0
        in al,40h                  ; read lsb
        mov ah,al                  ; hide LSB in AH
        in al,40h                  ; read msb
        xchg al,ah
        not ax                     ; invert AX (counter counts down)
        mov bx,SS_DOSMEM           ; selector for 0 - 1Mbyte range
        push es
        mov es,bx
        mov ebx,es:[46Ch]          ; number of 18.2 ticks since midnight
        shl ebx,16                 ; make room for AX
        add eax,ebx                ; number of 65535*18.2 ticks/sec
        pop es                     ; approx 1193 in 1mSec
        ret

;Ŀ
; Descr:  Get # of mSec. Good to approx 14 minutes timings                   
; Input:  None                                                               
; Output: EAX                                                                
; Regs changed: ECX, EDX                                                     
;

GetMilliSec:
        push ebx
        call GetHiResTimer         ; get ticks in EAX
        xor edx,edx                ; dividend = 0:EAX
        mov ecx,1193               ; divisor = ECX
        div ecx                    ; EAX = result, EDX = remainder
        pop ebx
        ret

_TEXT ENDS

END


