unit cmdhist;

{

cmdhist.pas - command-line history (first for rnr, named rnrhist.pas)

}

{$ifdef even_for_compiling_rnr_this_is_not_needed}
{$I rnr-def.pas}
{$endif}

interface

const
  numreadlnhistory=5;
  readlnhistorystringlen=80;

type
  readlnhistoryat=array[1..numreadlnhistory] of string[readlnhistorystringlen];
  readlnhistoryt=
    record
      position: integer;
      strings: readlnhistoryat;
    end;
  readlnhistorypt=^readlnhistoryt;

var
  searchtexthistoryp: readlnhistorypt;
  commandhistoryp: readlnhistorypt;
  filenamehistoryp: readlnhistorypt;
  folderhistoryp: readlnhistorypt;
  sourcehistoryp: readlnhistorypt;

procedure initializehistory(var ahistoryp: readlnhistorypt; reservedsize: longint);

implementation

procedure initializehistory;

var
  tempint: integer;

begin
  ahistoryp := nil;
  if memavail>reservedsize+sizeof(readlnhistoryt)+1024 then
    begin
      new(ahistoryp);
      for tempint := 1 to numreadlnhistory do
        ahistoryp^.strings[tempint] := '';
      ahistoryp^.position := 1;
    end;
end;

end.
