/*
 * MultiMail offline mail reader
 * main

 Copyright (c) 1996 Kolossvary Tamas <thomas@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "error.h"
#include "interfac.h"
#include "isoconv.h"

Interface		*interface = NULL;
#ifdef SIGWINCH
AnsiWindow		*currAnsi = NULL;
AddressBook		*currAddr = NULL;
TaglineWindow		*currTagw = NULL;
#endif
ErrorType		error;
mmail			mm;
Welcome			welcome;
PacketListWindow	packets;
HelpWindow		helpwindow;
AreaListWindow		areas;
LetterListWindow	letters;
LetterWindow		letterwindow;
AddressBook		addresses;
file_list		*packetList;
letter_list		*letterList;
LittleAreaListWindow	*littleareas;

void			memError();
void			fatalError(const char *description);

#ifdef SIGWINCH
void sigwinchHandler(int sig)
{
	if (sig == SIGWINCH)
		if (currAnsi)
			currAnsi->sigwinch();
		else
			if (currAddr)
				currAddr->sigwinch();
			else
				if (currTagw)
					currTagw->sigwinch();
				else
					interface->sigwinch();
	signal(SIGWINCH, sigwinchHandler);
}
#endif

void fatalError(const char *description)
{
	delete interface;
	fprintf(stderr, "\n\nFatal error: %s\n\n", description);
	exit(EXIT_FAILURE);
};

void memError()
{
	fatalError("Out of memory");
}

int main()
{
	isoconvert =
#if defined (__MSDOS__) || defined (__EMX__)
	0;
#else
	1;
#endif
	interface = new Interface();
#ifdef SIGWINCH
	signal(SIGWINCH, sigwinchHandler);
#endif
	interface->KeyHandle();
	delete interface;
	return EXIT_SUCCESS;
}
