/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       aut.c
**     SYSTEM   NAME:       SNMP Authentication Module
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1990/11/28
**
** DESCRIPTION: SNMP Authentication Module
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   AUT.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/SNMP/SNMP/VCS/AUT.C_V  $
**              
**                 Rev 1.1   01 Feb 1991 13:40:16   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/SNMP/SNMP/VCS/AUT.C_V   1.1   01 Feb 1991 13:40:16   etstjan  $";
#endif
#include <bufm.h>
#include "asn1.h"
#include "snmp.h"
#include "aut.h"

 
aut_sck
    AutSck =
{
    NULL,
    0,
    0
};

/**************************************************************
** NAME:        AutAddSrv  
** SYNOPSIS:    aut_srv
**                  *AutAddSrv
**                  (
**                      char        *Com,
**                      unsigned    ComLen,
**                      int         (*Enc) (asn_sck  *Asn),
**                      int         (*Dec) (asn_sck  *Asn)
**                  )
** DESCRIPTION: Gets or Adds an authentication service.
**              Parameters:
**              Com: Community
**              ComLen: Length of community.
**              Enc: Function to encode encryption or NULL.
**              Dec: Function to decode encryption or NULL.   
** RETURNS:     NULL --> error
**              else     pointer to desired service.
**************************************************************/
aut_srv
    *AutAddSrv
    (
        char        *Com,
        unsigned    ComLen,
        int         (*Enc) (asn_sck  *Asn),
        int         (*Dec) (asn_sck  *Asn)
    )
{
    aut_srv
        *Srv;

    if ((Srv = AutGetSrv (Com, ComLen)) != NULL)
        return (Srv);
    if (ComLen > AUT_SZECOM)
        return (NULL);
    if ((Srv = (aut_srv *) IPBufGet (sizeof (aut_srv))) == NULL)
        return (NULL);
    memcpy (Srv->SrvCom, Com, ComLen);
    Srv->SrvComLen = ComLen;
    Srv->SrvEnc = Enc;
    Srv->SrvDec = Dec;
    Srv->SrvNet = NULL;
	Srv->SrvNxt = AutSck.SckSrv;
	AutSck.SckSrv = Srv;
    return (Srv);
}

aut_srv
    *AutGetSrv
    (
        char        *Com,
        unsigned    ComLen
    )
{
	aut_srv
		*Srv;

	Srv = AutSck.SckSrv;
	while (Srv != NULL)
    {
        if (Srv->SrvComLen == ComLen && !memcmp (Srv->SrvCom, Com, ComLen))
            return (Srv);
        Srv = Srv->SrvNxt;
    }
    return (NULL);
}

/**************************************************************
** NAME:        AutAddNet  
** SYNOPSIS:    int
**                  AutAddNet
**                  (
**                      aut_srv     *Srv,
**                      long        Adr,
**                      long        Msk
**                  )
** DESCRIPTION: Adds a network mask to an authentication service.
**              Parameters:
**              Srv: Service
**              Adr: IP address.
**              Msk: IP mask.
**              A host is an authenticated member of the
**              community if (<address of host> & Msk) == Adr.
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
int
    AutAddNet
    (
        aut_srv     *Srv,
        long        Adr,
        long        Msk
    )
{
    aut_net
        *Net;

    if ((Net = (aut_net *) IPBufGet (sizeof (aut_net))) == NULL)
        return (-1);
    Net->NetAdr = Adr;
    Net->NetMsk = Msk;
    Net->NetNxt = Srv->SrvNet;
    Srv->SrvNet = Net;
    return (0);
}

int
    AutAdr
    (
		aut_srv *Srv,
        long    Adr
    )
{
	aut_net
		*Net;

	Net = Srv->SrvNet;
	while (Net != NULL)
    {
        if ((Adr & Net->NetMsk) == Net->NetAdr)
            return (0);
        Net = Net->NetNxt;
    }
    return (-1);
}

int
    AutEnc
    (
        char                *Com,
        unsigned            ComLen,
        long                Adr,
        asn_sck             *Asn
    )
{
    aut_srv
        *Srv;

	if (AutSck.SckSrv == NULL)
        return (0);
    if ((Srv = AutGetSrv (Com, ComLen)) == NULL)
        return (-1);
    if (Srv->SrvNet == NULL)
        return (0);
	if (AutAdr (Srv, Adr) < 0)
        return (-1);
    if (Srv->SrvEnc == NULL)
        return (0);
    if (Srv->SrvEnc (Asn) < 0)
        return (-1);
    return (0);
}

int
    AutDec
    (
        char                *Com,
        unsigned            ComLen,
        long                Adr,
        asn_sck             *Asn
    )
{
    aut_srv
        *Srv;

	if (AutSck.SckSrv == NULL)
        return (0);
    if ((Srv = AutGetSrv (Com, ComLen)) == NULL)
    {
		AutSck.SckBadCom++;
        return (-1);
    }
    if (Srv->SrvNet == NULL)
        return (0);
	if (AutAdr (Srv, Adr) < 0)
    {
		AutSck.SckBadUse++;
        return (-1);
    }
    if (Srv->SrvDec == NULL)
        return (0);
    if (Srv->SrvDec (Asn) < 0)
    {
		AutSck.SckBadUse++;
        return (-1);
    }
    return (0);
}
